<?php
class Paginacao {
	public $urlvar		= 'pag';
	public $currentPage	= 0;
	public $numres		= 15;
	public $limit;
	public $page;
	public $tag;
	
	private $goto;
	private $paginas;
	private $items;
	private $hidden;
	private $debug		= FALSE;
	
	public function __construct(){
		global $act;
		
		if($GET = $_GET[$this->urlvar])
			$this->currentPage = $GET;
		
		$this->goto	= $act->url($this->urlvar);
		$this->page	= $_GET['page'];
		
		$this->setlimit($this->numres);
	}
	
	public function target($str = ''){
		$this->goto .= $str;
	}
	
	public function attachvar($var, $value){
		$this->hidden .= '<input type="hidden" name="'.$var.'" value="'.$value.'"/>';
	}
	
	public function setitems($nr){
		$this->items = $nr;
	}
	
	public function settag($val){
		$this->tag = '-'.$val;
	}
	
	public function setlimit($nr){
		$this->numres = $nr;
		$this->limit = " LIMIT ".($nr * $this->currentPage).", ".$nr;
	}
	
	public function debug(){
		$this->debug = TRUE;
	}

	public function paging($showCombo = false)
	{
		global $sql;
		global $act;
		
		if(!$this->items)
			$error = ' necessrio especificar o <b>n de registos</b> a apresentar (\$class->setitems(1000))<br />';
		
		if(!$error){
			$this->paginas = @ceil($this->items / $this->numres);
			
			$rtn[] = '<table id="pagination'.$this->tag.'" class="pagination"><tr>';
			
			if($this->currentPage >= 1)
				$rtn[] = '<td class="arrow init submit"><form action="'.$this->goto.'" method="post">'.$this->hidden.'</form></td>';
			else
				$rtn[] = '<td class="arrow init"></td>';
			
			
			if($this->paginas >= 6 && $this->currentPage >= 4){ 
				$comeca	= $this->currentPage - 1; 
				$acaba	= $this->currentPage + 4; 
				$pag	= $comeca - 4;
				
				if($pag < 0)
					$pag = 0;
				
				$rtn[] = '<td class="more">...</td>';
			}else{
				$comeca	= 0; 
				$acaba	= 5;
			}
			
			if($this->currentPage == ($this->paginas-3)){ $comeca = ($this->currentPage-2); $acaba = $this->paginas; }
			if($this->currentPage == ($this->paginas-2)){ $comeca = ($this->currentPage-3); $acaba = $this->paginas; }
			if($this->currentPage == ($this->paginas-1)){ $comeca = ($this->currentPage-4); $acaba = $this->paginas; }
			if($this->paginas <= 4){ $comeca = 0; $acaba = $this->paginas; }
			
			for ($i=$comeca;$i<$acaba;$i++){ 
				if ($this->currentPage == $i)
					$rtn[] = '<td class="number current">'.($i+1).'</td>'; 
				else
					$rtn[] = '<td class="number submit"><form action="'.$this->goto.'&amp;'.$this->urlvar.'='.$i.'" method="post">'.$this->hidden.($i+1).'</form></td>';
			}
			
			if($this->paginas >= 6 && $this->currentPage < ($this->paginas-4))
			{ 
				$pag = $acaba + 1;
				
				if($pag >= $this->paginas)
					$pag = $this->paginas - 1;
				
				$rtn[] = '<td class="more">...</td>';
			}
			
			if($this->currentPage < ($this->paginas-1) && $this->paginas > 1)
				$rtn[] = '<td class="arrow end submit"><form action="'.$this->goto.'&amp;'.$this->urlvar.'='.($this->paginas-1).'" method="post">'.$this->hidden.'</form></td>';
			else
				$rtn[] = '<td class="arrow end"></td>'; 
			
			
			if($showCombo){
				$rtn[] = '<td class="comboPag">';
				$rtn[] = '<form name="formgopag" action="" method="get">'.$this->hidden;
				$rtn[] = '<input type="hidden" name="page" value="'.$this->page.'" />';
				$rtn[] = '<select name="'.$this->urlvar.'" class="selectPagCombo">';
					
					for($k=0;$k<$this->paginas;$k++)
						$rtn[] = '<option value="'.$k.'"'.($this->currentPage == $k ? 'selected="selected"' : '').'>'.($k+1).'</option>';
					
				$rtn[] = '</select>';
				$rtn[] = '</form>';
				$rtn[] = '</td>';
			}
			
			$rtn[] = '</tr></table>';
			$rtn[] = '<div class="clear"></div>';
			
			if($this->items > $this->numres)
				return implode('',$rtn);
			else
				return '';
		}else{
			if($this->debug)
				echo $error;
			
			return '';
		}
	}
	
	
	public function isFinalPage($pag) //$pag  a pagina corrente ($_GET)
	{
		if ($pag == ($this->paginas - 1))
			return true;
		else
			return false;
	}	
	
}
?>