<?php
function dotCrypt( $string, $action = 'e' )
{
    // Alterar estes valores
    $secret_key = 'my_simple_secret_key';
    $secret_iv  = 'my_simple_secret_iv';

    $output         = false;
    $encrypt_method = "AES-256-CBC";
    $key            = hash('sha256', $secret_key);
    $iv             = substr(hash('sha256', $secret_iv), 0, 16);

    if ( $action == 'e' ) {
        $output = base64_encode(openssl_encrypt($string, $encrypt_method, $key, 0, $iv));
    } else if ( $action == 'd' ) {
        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
    }

    return $output;
}

function console( $data, $context = 'Debug a partir de PHP' )
{

    // Buffering to solve problems frameworks, like header() in this and not a solid return.
    ob_start();

    $output = 'console.info( \'' . $context . ':\' );';
    $output .= 'console.log(' . json_encode($data) . ');';
    $output = sprintf('<script>%s</script>', $output);

    echo $output;
}

function normalizeFilename( $string )
{
    $clean_name = strtr($string, array( '?' => 'S', '?' => 'Z', '?' => 's', '?' => 'z', '?' => 'Y', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'C', '' => 'E', '' => 'E', '' => 'E', '' => 'E', '' => 'I', '' => 'I', '' => 'I', '' => 'I', '' => 'N', '' => 'O', '' => 'O', '' => 'O', '' => 'O', '' => 'O', '' => 'O', '' => 'U', '' => 'U', '' => 'U', '' => 'U', '' => 'Y', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'c', '' => 'e', '' => 'e', '' => 'e', '' => 'e', '' => 'i', '' => 'i', '' => 'i', '' => 'i', '' => 'n', '' => 'o', '' => 'o', '' => 'o', '' => 'o', '' => 'o', '' => 'o', '' => 'u', '' => 'u', '' => 'u', '' => 'u', '' => 'y', '' => 'y' ));
    $clean_name = strtr($clean_name, array( '' => 'TH', '' => 'th', '' => 'DH', '' => 'dh', '' => 'ss', '?' => 'OE', '?' => 'oe', '' => 'AE', '' => 'ae', '' => 'u' ));

    $clean_name = preg_replace(array( '/\s/', '/\.[\.]+/', '/[^\w_\.\-]/' ), array( '_', '.', '' ), $clean_name);
    return $clean_name;
}

function fileHashRev( $hash )
{
    $resposta[ 'hash' ] = substr($hash, 0, strpos($hash, '.'));
    $resposta[ 'map' ]  = '';
    $resposta[ 'map' ]  .= substr($resposta[ 'hash' ], 0, 1) . "/";
    $resposta[ 'map' ]  .= substr($resposta[ 'hash' ], 1, 1) . "/";
    $resposta[ 'map' ]  .= substr($resposta[ 'hash' ], 2, 1) . "/";

    return $resposta[ 'map' ] . $hash;
}


///////////////////////////////////////////////////////
// -------------| DETERMINAR CORDENADAS |----------- //
///////////////////////////////////////////////////////
function normalize( $stripAccents )
{
    return strtr($stripAccents, '���������������������������������������������������', 'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
}

function determinaCoordenadas( $equip )
{
    global $sql;

    $sql->query('SET CHARACTER SET utf8');
    $equipamento = $sql->fetch($sql->query('SELECT * FROM equipamentos WHERE id="' . $equip . '"'));

    $address     = $equipamento->local_morada . ' ' . $equipamento->local_localidade . ' ' . $equipamento->local_concelho . ' ' . $equipamento->local_distrito . ' ' . $equipamento->local_pais . '';
    $coordinates = file_get_contents('http://maps.googleapis.com/maps/api/geocode/json?address=' . urlencode($address) . '&sensor=true&oe=utf8');
    $coordinates = json_decode($coordinates);

    $lat = $coordinates->results[ 0 ]->geometry->location->lat;
    $lng = $coordinates->results[ 0 ]->geometry->location->lng;

    $value = $coordinates->results[ 0 ]->geometry->location->lat . ',' . $coordinates->results[ 0 ]->geometry->location->lng;
    $sql->query('SET CHARACTER SET latin1');
    return ( $value );
}


///////////////////////////////////////////////////////
// ------------------| FUNCTIONS |------------------ //
///////////////////////////////////////////////////////

// MARCA DO SITE
function getBrand( $l )
{
    global $generic;

    switch ( $l ) {
        case 'pt'    :
            return '<a href="' . $base . '">' . $generic->title . '</a> &copy; ' . $generic->year . ' <a target="_blank" href="http://www.dotpro.pt">DotPro</a> (uma empresa <a target="_blank" href="http://www.f3m.pt">F3M</a>)';
        default        :
            return '<a href="' . $base . '">' . $generic->title . '</a> &copy; ' . $generic->year . ' <a target="_blank" href="http://www.dotpro.pt">DotPro</a> (a <a target="_blank" href="http://www.f3m.pt">F3M</a> company)';
    }
}

/* ---------------------------------------------------- */
// MAIL BODY DISPLAY
function mailbody( $html, $client = true )
{

    global $login;
    global $generic;
    global $langvars;
    global $base;

    $rtn .= '<div style="width:600px;margin:10px auto;padding:10px;background:#000;border:5px solid #bd411b;color:#ccc;">';
    $rtn .= '<img alt="logo" src="' . $base . 'img/site/logo.png" style="margin:-10px 0 0 -10px;" />';
    $rtn .= clear();
    $rtn .= $client ? $langvars[ 'email_hello' ] . ' ' . $login->firstname . ' ' . $login->lastname . ',<br /><br />' : '';
    $rtn .= $html;
    $rtn .= '<br />' . $generic->title;
    $rtn .= '</div>';

    return $rtn;
}

// VARIAVEIS DE PAGAMENTO
function paymentData( $mPayment, $total, $payment, $deliveryVal, $deliveryName, $next = true )
{

    global $lang;
    global $base;
    global $lang;
    global $store;
    global $login;
    global $langvars;
    global $paypalData;

    if ( $mPayment == 'PP' ) {

        $rtn .= '<form action="' . $paypalData[ 'link' ] . '" method="post">';

        $rtn .= '<input type="hidden" name="cmd" value="_cart">';
        $rtn .= '<input type="hidden" name="business" value="' . $paypalData[ 'email' ] . '">';
        $rtn .= '<input type="hidden" name="image_url" value="' . $base . 'img/site/logo.png">';
        $rtn .= '<input type="hidden" name="upload" value="1">';
        $rtn .= '<input type="hidden" name="rm" value="2">';
        $rtn .= '<input type="hidden" name="cbt" value="' . $langvars[ 'store_paypalcomplete' ] . '">';
        $rtn .= '<input type="hidden" name="return" value="' . $base . '">';
        $rtn .= '<input type="hidden" name="cancel_return" value="' . $base . '">';
        $rtn .= '<input type="hidden" name="lc" value="' . strtoupper($lang) . '">';
        $rtn .= '<input type="hidden" name="currency_code" value="' . $store->coin . '">';

        $rtn .= '<input type="hidden" name="first_name" value="' . $login->firstname . '">';
        $rtn .= '<input type="hidden" name="last_name" value="' . $login->lastname . '">';
        $rtn .= '<input type="hidden" name="address1" value="' . $login->address . '">';
        $rtn .= '<input type="hidden" name="city" value="' . $login->local . '">';
        $rtn .= '<input type="hidden" name="email" value="' . $login->email . '">';
        $rtn .= '<input type="hidden" name="phone" value="' . $login->cellphone . '">';
        $rtn .= '<input type="hidden" name="zip" value="' . $login->zipcode4 . '-' . $login->zipcode3 . '"> ';
        $rtn .= '<input type="hidden" name="country" value="' . strtoupper($lang) . '">';

        $rtn .= '<input type="hidden" name="item_name_1" value="' . $langvars[ 'store_totalbuy' ] . '" />';
        $rtn .= '<input type="hidden" name="amount_1" value="' . $total . '" />';
        $rtn .= '<input type="hidden" name="quantity_1" value="1" />';

        $rtn .= '<input type="hidden" class="charges" name="item_name_2" value="' . $langvars[ 'store_charges' ] . '" />';
        $rtn .= '<input type="hidden" class="charges" name="amount_2" value="' . $payment . '" />';
        $rtn .= '<input type="hidden" class="charges" name="quantity_2" value="1" />';

        $rtn .= '<input type="hidden" name="' . $deliveryName . '" value="' . $deliveryVal . '" />';

        $rtn .= '<input type="submit" value="Efectuar pagamento" class="r button" />';
        $rtn .= clear();
        $rtn .= '</form>';

    } elseif ( $next )
        $rtn .= '<p class="continueBuy"><a href="' . $base . '">' . $langvars[ 'store_continue' ] . '</a></p>';

    return $rtn;
}

// LIMPAR VARIAVEIS DO CARRINHO
function unsetSessionCart()
{
    unset($_SESSION[ 'cartvars' ]);
    @session_regenerate_id();
}

// TOTAL CREDIT
function getCreditTotal()
{
    global $sql;
    global $login;

    $dbdata = $sql->fetch($sql->query('SELECT SUM(value) AS total FROM dc_users_credit WHERE iduser = "' . $login->id . '" AND !ISNULL(status) ORDER BY id DESC'));
    return ceil($dbdata->total * 100) / 100;
}

// DESCRI��O DO SITE
function webInfo()
{

    global $sql;
    global $lang;
    global $generic;

    return array(
        'title' => $generic->title . ( $dbdata ? ' | ' . $dbdata->title : '' ),
        'desc'  => $dbdata ? strip_tags($dbdata->description) : $generic->description );
}

// FEEDS
function getFeed( $url )
{
    $content = file_get_contents($url);
    $x       = new SimpleXmlElement($content);
    foreach ( $x->channel->item as $entry )
        $return[] = '<div><a href="' . $entry->link . '" title="' . $entry->title . '">' . $entry->title . '</a><p>' . $entry->description . '</p></div>';
    return $return;
}

// REDES SOCIAIS
function getSocial( $size = 32 )
{

    global $generic;
    global $social;
    global $base;

    foreach ( $social as $k => $v ) {
        $field = 'url_' . $v;
        $rtn[] = $generic->$field ? '<a href="' . $generic->$field . '" target="_blank"><img title="' . $k . '" alt="' . $k . '" src="' . $base . 'img/social/' . $v . '_' . $size . '.png" align="absmiddle" /></a>' : '';
    }
    return is_array($rtn) ? implode('', $rtn) : '';
}

// CRIAR "SHADOWBOX"
function shadowbox( $content )
{
    $rtn[] = '<table class="shadowbox">';
    $rtn[] = '<tr>';
    $rtn[] = '<td class="corner left_top"></td><td class="horizontal top"></td><td class="corner right_top"></td>';
    $rtn[] = '</tr><tr>';
    $rtn[] = '<td class="vertical left"></td><td class="center-content">' . $content . '</td><td class="vertical right"></td>';
    $rtn[] = '</tr><tr>';
    $rtn[] = '<td class="corner left_bottom"></td><td class="horizontal bottom"></td><td class="corner right_bottom"></td>';
    $rtn[] = '</tr>';
    $rtn[] = '</table>';
    return is_array($rtn) ? implode('', $rtn) : '';
}

// GERAR PASSWORD
function getPassword( $length = 12, $num = true, $up = true, $low = true )
{
    $password = '';
    $i        = 0;
    $interval .= $num ? '0123456789' : '';
    $interval .= $up ? 'QWERTYUIOPASDFGHJKLZXCVBNM' : '';
    $interval .= $low ? 'qwertyuiopasdfghjklzxcvbnm' : '';
    while ( $i < $length ) {
        $char = substr($interval, mt_rand(0, strlen($interval) - 1), 1);
        if ( !strstr($password, $char) ) {
            $password .= $char;
            $i++;
        }
    }
    return $password;
}

// REDIMENSIONAR IMAGEM
function resizeImage( $crop, $src, $newW, $newH = 0, $quality = 100 )
{

    $source = new Imagick($src);
    $source->thumbnailImage($newW, $newH);
    $source->writeImage($crop);
    $source->clear();
    $source->destroy();
    chmod($crop, 0777);
    return;

}

// CORTAR IMAGENS
function cropImage( $thumb_image_name, $image, $width, $height, $start_width, $start_height, $quality = 100, $scale = 1 )
{

    $source = new Imagick($image);
    $source->cropImage($width, $height, $start_width, $start_height);
    $source->writeImage($thumb_image_name);
    $source->clear();
    $source->destroy();
    chmod($thumb_image_name, 0777);
    return;

}

// DADOS PARA EMAIL
function getMailData( $tag )
{
    global $sql;
    global $lang;

    $dbdata = $sql->fetch($sql->query('SELECT title,description FROM dc_content WHERE tag = "' . $tag . '" AND lang = "' . $lang . '"'));

    return array(
        'subject' => $dbdata->title,
        'text'    => $dbdata->description );
}

// NUMERO IMPAR
function is_odd( $int )
{
    return ( $int & 1 );
}

// CLEAR
function clear( $t = 'div' )
{
    return '<' . $t . ' class="clear"></' . $t . '>';
}

// VALIDAR URL
function validar_url( $url )
{
    return preg_match('|^http(s)?://[a-z0-9-]+(\.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i', $url);
}

// URL -> ARRAY
function urlarray()
{
    $pageURL = 'http';
    if ( $_SERVER[ "HTTPS" ] == "on" ) {
        $pageURL .= "s";
    }
    $pageURL .= "://";
    if ( $_SERVER[ "SERVER_PORT" ] != "80" )
        $pageURL .= $_SERVER[ "SERVER_NAME" ] . ":" . $_SERVER[ "SERVER_PORT" ] . $_SERVER[ "REQUEST_URI" ];
    else
        $pageURL .= $_SERVER[ "SERVER_NAME" ] . $_SERVER[ "REQUEST_URI" ];

    return parse_url($pageURL);
}

// LISTAR TABELAS DA BASE DE DADOS
function listTables( $db )
{
    $res    = mysql_list_tables($db);
    $numtbl = mysql_num_rows($res);
    for ( $i = 0; $i < $numtbl; $i++ )
        $tabelas[] = mysql_tablename($res, $i);
    mysql_free_result($res);
    return $tabelas;
}

// STRING -> ARRAY
function strToArray( $str, $char, $field = false )
{
    $arr = explode($char, $str);
    return !is_bool($field) ? $arr[ $field ] : $arr;
}

// EMAIL COM ANEXO
function mail_attachment( $filename, $path, $mailto, $from_mail, $from_name, $replyto, $subject, $message )
{
    $file      = $path . $filename;
    $file_size = filesize($file);
    $handle    = fopen($file, "r");
    $content   = fread($handle, $file_size);
    fclose($handle);
    $content  = chunk_split(base64_encode($content));
    $uid      = md5(uniqid(time()));
    $name     = basename($file);
    $header[] = "From: " . $from_name . " <" . $from_mail . ">\r\n";
    $header[] = "Reply-To: " . $replyto . "\r\n";
    $header[] = "MIME-Version: 1.0\r\n";
    $header[] = "Content-Type: multipart/mixed; boundary=\"" . $uid . "\"\r\n\r\n";
    $header[] = "This is a multi-part message in MIME format.\r\n";
    $header[] = "--" . $uid . "\r\n";
    $header[] = "Content-type:text/plain; charset=iso-8859-1\r\n";
    $header[] = "Content-Transfer-Encoding: 7bit\r\n\r\n";
    $header[] = $message . "\r\n\r\n";
    $header[] = "--" . $uid . "\r\n";
    $header[] = "Content-Type: application/octet-stream; name=\"" . $filename . "\"\r\n"; // use different content types here
    $header[] = "Content-Transfer-Encoding: base64\r\n";
    $header[] = "Content-Disposition: attachment; filename=\"" . $filename . "\"\r\n\r\n";
    $header[] = $content . "\r\n\r\n";
    $header[] = "--" . $uid . "--";
    return mail($mailto, $subject, "", implode('', $header));
}

// VERIFICAR EXTEN��O DE FICHEIRO
function checkExt( $filename )
{
    return strtolower(pathinfo($filename, PATHINFO_EXTENSION));
}

// VERIFICAR IMAGEM
function checkImage( $file, $pref = '' )
{
    global $base;
    return file_exists($pref . $file) ? '<img alt="image" src="' . $base . $file . '" />' : '';
}

// LIMPAR FICHEIROS DE REGISTOS
function removeRegistItems( $dir )
{
    if ( is_dir($dir) ) {
        foreach ( @scandir($dir) as $item ) {

            $file  = $dir . $item;
            $point = false;

            if ( $item != '.' && $item != '..' )
                $point = true;

            if ( $point && !is_dir($file) ) {
                mysql_query('DELETE FROM dc_content_imgSettings WHERE file = "' . $file . '"');
                unlink($file);
            } elseif ( $point && is_dir($file) )
                removeRegistItems($file . '/');
        }
        rmdir($dir);
    }
}

// LIMITAR STRING
function limitChar( $str, $limit )
{
    return strlen($str) > $limit ? preg_replace('/\s+?(\S+)?$/', '', substr($str, 0, $limit)) . '...' : $str;
}

// VERIFICAR PASTA
function filesOnDir( $dir, $ext = '' )
{
    $rtn = false;
    if ( is_dir($dir) ) {
        foreach ( scandir($dir) as $i ) {
            if ( $i != '.' && $i != '..' ) {
                if ( $ext && checkExt($i) == $ext )
                    $rtn = true;
                elseif ( !$ext )
                    $rtn = true;
            }
        }
    }
    return $rtn;
}

// LISTAR PASTA
function listdir( $dir, $ext = '' )
{
    if ( is_dir($dir) && filesOnDir($dir) ) {
        foreach ( scandir($dir) as $i ) {

            $file = $dir . $i;

            if ( $i != '.' && $i != '..' && !is_dir($file) ) {
                if ( $ext && checkExt($i) == $ext )
                    $rtn[] = array( 'file' => htmlentities($file), 'name' => $i );
                elseif ( !$ext )
                    $rtn[] = array( 'file' => htmlentities($file), 'name' => $i );
            }
        }
    }
    if ( is_array($rtn) ) natsort2d($rtn);
    return is_array($rtn) ? $rtn : false;
}

function natsort2d( &$aryInput )
{
    $aryTemp = $aryOut = array();
    foreach ( $aryInput as $key => $value ) {
        reset($value);
        $aryTemp[ $key ] = current($value);
    }
    natsort($aryTemp);
    foreach ( $aryTemp as $key => $value ) {
        $aryOut[] = $aryInput[ $key ];
    }
    $aryInput = $aryOut;
}

// VERIFICAR IP
function ipAddress( $ipAddr )
{
    //verify the IP address for the
    ip2long($ipAddr) == -1 || ip2long($ipAddr) === false ? trigger_error("Invalid IP", E_USER_ERROR) : "";
    $ipDetail = array(); //initialize a blank array

    //get the XML result from hostip.info
    $xml = file_get_contents("http://api.hostip.info/?ip=" . $ipAddr);

    //get the city name inside the node <gml:name> and </gml:name>
    preg_match("@<Hostip>(\s)*<gml:name>(.*?)</gml:name>@si", $xml, $match);

    //assing the city name to the array
    $ipDetail[ 'city' ] = $match[ 2 ];

    //get the country name inside the node <countryName> and </countryName>
    preg_match("@<countryName>(.*?)</countryName>@si", $xml, $matches);

    //assign the country name to the $ipDetail array
    $ipDetail[ 'country' ] = $matches[ 1 ];

    //get the country name inside the node <countryName> and </countryName>
    preg_match("@<countryAbbrev>(.*?)</countryAbbrev>@si", $xml, $cc_match);
    $ipDetail[ 'country_code' ] = $cc_match[ 1 ]; //assing the country code to array

    //return the array containing city, country and country code
    return $ipDetail;
}

// NUMERO DE LINGUAGENS
function nLang()
{
    global $lng;
    return sizeof($lng->getall());
}

function order( $db, $arr )
{

    foreach ( $arr as $k => $array ) {
        $order = $k + 1;
        $code  = str_replace('recordsArray_', '', $array);

        mysql_query('UPDATE ' . $db . ' SET `order` = "' . $order . '" WHERE `' . ( is_numeric($code) ? 'id' : 'code' ) . '` = "' . $code . '"');
    }
}

//////////////////////////////////////////////////////////
//						ADMINISTRATOR					//
//////////////////////////////////////////////////////////

// VALORES PARA INSERIR
function getInsertValues( $post )
{
    foreach ( $post as $f => $v ) {
        if ( $v ) {
            $field[] = '`' . $f . '`';
            $value[] = '"' . cleanstr($v) . '"';
        }
    }
    return array( $field, $value );
}

// VALORES PARA EDITAR
function getEditValues( $post )
{
    foreach ( $post as $f => $v )
        $edit[] = '`' . $f . '`=' . ( $v!="" ? '"' . cleanstr($v) . '"' : 'NULL' );

    return $edit;
}

function cleanstr( $str )
{
    //return $str;
    $str = str_replace('"', '\'\'', $str);
    $str = str_replace('À', '&#192;', $str);
    $str = str_replace('Á', '&#193;', $str);
    $str = str_replace('Â', '&#194;', $str);
    $str = str_replace('Ã', '&#195;', $str);
    $str = str_replace('É', '&#201;', $str);
    $str = str_replace('Ó', '&#211;', $str);
    $str = str_replace('Ô', '&#212;', $str);
    $str = str_replace('Õ', '&#213;', $str);
    $str = str_replace('à', '&#224;', $str);
    $str = str_replace('á', '&#225;', $str);
    $str = str_replace('â', '&#226;', $str);
    $str = str_replace('ã', '&#227;', $str);
    $str = str_replace('ç', '&#231;', $str);
    $str = str_replace('è', '&#232;', $str);
    $str = str_replace('é', '&#233;', $str);
    $str = str_replace('ê', '&#234;', $str);
    $str = str_replace('ì', '&#236;', $str);
    $str = str_replace('í', '&#237;', $str);
    $str = str_replace('ò', '&#242;', $str);
    $str = str_replace('ó', '&#243;', $str);
    $str = str_replace('ô', '&#244;', $str);
    $str = str_replace('õ', '&#245;', $str);
    $str = str_replace('º', '&#186;', $str);
//    return str_replace('"', '\"', $str);
   return $str;
}

// SELECIONAR PRODUTOS DA SUB-CATEGORIA
function getProducts( $arr, $sel = '' )
{

    global $sql;
    global $lang;

    //$rtn[]	= '<option value=""></option>';
    foreach ( $arr as $id ) {

        list($cat, $subcat) = explode('|', $id);

        $res = $sql->query('
							   SELECT p.id, p.code, p.ref, p.name
							   FROM dc_store_products AS p
							   JOIN dc_store_products_rel AS c ON c.idreg = p.code
							   WHERE c.idcat = "' . $cat . '"' . ( $subcat ? ' AND c.idsubcat = "' . $subcat . '"' : '' ) . ' AND p.lang = "' . $lang . '"
							   ORDER BY p.order ASC');
        if ( $sql->nrows($res) ) {
            $dbcat  = $sql->fetch($sql->query('SELECT name FROM dc_store_products_category WHERE code = "' . $cat . '" AND lang = "' . $lang . '"'));
            $dbscat = $sql->fetch($sql->query('SELECT name FROM dc_store_products_subCategory WHERE code = "' . $subcat . '" AND lang = "' . $lang . '"'));
            $rtn[]  = '<option class="bold" disabled="disabled">' . $dbcat->name . ( $subcat ? ' - ' . $dbscat->name : '' ) . '</option>';

            $father = $cat . '|' . $subcat;

            while ( $prod = $sql->fetch($res) )
                $rtn[] = '<option class="margin-left" value="' . $father . '|' . $prod->code . '" ' . ( is_array($sel) && in_array($prod->code, $sel) ? 'selected="selected"' : '' ) . '>� ' . $prod->ref . ' - ' . $prod->name . '</option>';
        }
    }
    return implode('', $rtn);
}

// SELECIONAR PRODUTOS DA CATEGORIA NA LOJA
function getCatProdStore( $arr )
{

    global $sql;
    global $lang;

    //$rtn[]	= '<option value=""></option>';
    foreach ( $arr as $cat ) {

        $res = $sql->query('
							   SELECT p.id, p.code, p.ref, p.name
							   FROM dc_store_products AS p
							   JOIN dc_store_products_rel AS c ON c.idreg = p.code
							   WHERE c.idcat = "' . $cat . '" AND p.lang = "' . $lang . '"
							   ORDER BY p.order ASC');
        if ( $sql->nrows($res) ) {
            $dbdata = $sql->fetch($sql->query('SELECT name FROM dc_store_products_category WHERE code = "' . $cat . '" AND lang = "' . $lang . '"'));
            $rtn[]  = '<option class="bold" disabled="disabled">' . $dbdata->name . '</option>';

            while ( $prod = $sql->fetch($res) )
                $rtn[] = '<option class="margin-left" value="' . $cat . '||' . $prod->code . '" >� ' . $prod->ref . ' - ' . $prod->name . '</option>';
        }
    }
    return @implode('', $rtn);
}

// SELECIONAR SUB-CATEGORIAS DA LOJA
function getsubCatStore( $arr, $sel = '' )
{

    global $sql;
    global $lang;

    //$rtn[]	= '<option value=""></option>';
    foreach ( $arr as $id ) {
        $res = $sql->query('SELECT id, code, name FROM dc_store_products_subCategory WHERE idcat = "' . $id . '" AND lang = "' . $lang . '" ORDER BY `order` ASC');
        if ( $sql->nrows($res) ) {
            $cat   = $sql->fetch($sql->query('SELECT name FROM dc_store_products_category WHERE code = "' . $id . '" AND lang = "' . $lang . '"'));
            $rtn[] = '<option class="bold" disabled="disabled">' . $cat->name . '</option>';

            while ( $subcat = $sql->fetch($res) )
                $rtn[] = '<option class="margin-left" value="' . $id . '|' . $subcat->code . '" ' . ( is_array($sel) && in_array($subcat->code, $sel) ? 'selected="selected"' : '' ) . '>� ' . $subcat->name . '</option>';
        }
    }
    return @implode('', $rtn);
}

// SELECIONAR CARACTERISTICAS DOS PRODUTOS
function getsubInfoStore( $arr, $sel = '' )
{

    global $sql;
    global $lang;

    $rtn[] = '<option value=""></option>';
    foreach ( $arr as $id ) {
        $res = $sql->query('SELECT id, code, name FROM dc_store_products_info_subCategory WHERE idcat = "' . $id . '" AND lang = "' . $lang . '" ORDER BY `order`,name ASC');
        if ( $sql->nrows($res) ) {
            $cat   = $sql->fetch($sql->query('SELECT name FROM dc_store_products_info_category WHERE code = "' . $id . '" AND lang = "' . $lang . '"'));
            $rtn[] = '<option class="bold" disabled="disabled">' . $cat->name . '</option>';

            while ( $subcat = $sql->fetch($res) )
                $rtn[] = '<option class="margin-left" value="' . $id . '|' . $subcat->code . '" ' . ( is_array($sel) && in_array($subcat->code, $sel) ? 'selected="selected"' : '' ) . '>� ' . $subcat->name . '</option>';
        }
    }
    return implode('', $rtn);
}

// SELECIONAR CARACTERISTICAS DOS PRODUTOS - PRE�OS
function getsubInfoStore_price( $prod, $arr )
{

    global $sql;
    global $lang;

    if ( is_array($arr) ) {
        foreach ( $arr as $code ) {
            if ( $code ) {
                $dbdata = $sql->fetch($sql->query('
													  SELECT s.name,r.price
													  FROM dc_store_products_info_subCategory AS s
													  JOIN dc_store_products_info_rel AS r ON r.idsubcat = s.code
													  WHERE s.code = "' . $code . '" AND s.lang = "' . $lang . '" AND r.idreg = "' . $prod . '"'));

                $rtn .= '<div class="inputAlign">';
                $rtn .= '<p>' . $dbdata->name . '</p>';
                $rtn .= '<input type="text" name="info[price][' . $code . ']" value="' . number_format($dbdata->price, 2) . '" class="half put5inline" />';
                $rtn .= '</div>';
            }
        }
    }
    return $rtn;
}

// SELECIONAR UTILIZADORES DA CATEGORIA
function getUsers( $arr, $sel = '' )
{

    global $sql;

    $rtn[] = '<option value=""></option>';
    foreach ( $arr as $id ) {
        if ( $sel )
            $subcat = $id;
        else
            list($subcat, $user) = explode('|', $id);

        $res = $sql->query('SELECT u.id,u.firstname,u.lastname FROM dc_users_category_rel AS r JOIN dc_users AS u ON u.id = r.idreg WHERE idsubcat = "' . $subcat . '" ORDER BY u.firstname,u.lastname ASC');
        if ( $sql->nrows($res) ) {
            $cat   = $sql->fetch($sql->query('SELECT name FROM dc_group_subCategory WHERE code = "' . $subcat . '"'));
            $rtn[] = '<option class="bold" disabled="disabled">' . $cat->name . '</option>';

            while ( $usr = $sql->fetch($res) )
                $rtn[] = '<option class="margin-left" value="' . $subcat . '|' . $usr->id . '" ' . ( is_array($sel) && in_array($usr->id, $sel) ? 'selected="selected"' : '' ) . '>� ' . $usr->firstname . ' ' . $usr->lastname . '</option>';
        }
    }
    return implode('', $rtn);
}

// #####################| GRUPOS DO SITE
// ADICIONAR
function insertLang( $dbtable, $field, $value, $cat = false )
{

    global $lng;
    global $sql;

    $code  = getPassword(8);
    $dbrel = $dbtable . '_rel';

    foreach ( $lng->getall() as $l )
        $query = $sql->query('INSERT INTO ' . $dbtable . ' (' . implode(',', $field) . ',`lang`,`code`) VALUES (' . implode(',', $value) . ',"' . $l . '","' . $code . '")');

    if ( $cat ) {
        deleteSubCat($dbrel, $code);
        insertSubCat($dbrel, $code, $cat[ 'cat' ], $cat[ 'subcat' ]);
    }

    return $query ? true : false;
}

// EDITAR
function editGroupLang( $dbtable, $id, $code, $edit, $cat )
{

    global $lng;
    global $sql;

    $query = $sql->query('UPDATE ' . $dbtable . ' SET ' . implode(',', $edit) . ' WHERE `id` = "' . $id . '"');
    $dbrel = $dbtable . '_rel';

    deleteSubCat($dbrel, $code);
    insertSubCat($dbrel, $code, $cat[ 'cat' ], $cat[ 'subcat' ]);

    return $query ? true : false;
}

// #####################| PRODUTOS DA LOJA
// ADICIONAR
function insertProdStoreLang( $dbtable, $field, $value, $cat, $stock, $info )
{

    global $lng;
    global $sql;
    global $act;

    $code      = getPassword(8);
    $dbrelCat  = $dbtable . '_rel';
    $dbrelInfo = $dbtable . '_info_rel';

    foreach ( $lng->getall() as $l )
        $query = $sql->query('INSERT INTO ' . $dbtable . ' (' . implode(',', $field) . ',`lang`,`code`) VALUES (' . implode(',', $value) . ',"' . $l . '","' . $code . '")');

    $cat ? insertCatStore($dbrelCat, $code, $cat) : false;
    $info ? insertCatStore($dbrelInfo, $code, $info) : false;
    $stock ? insertProdStock($code, $stock) : false;

    return $query ? true : false;
}

// EDITAR
function editProdStoreLang( $dbtable, $id, $code, $edit, $cat, $stock, $info )
{

    global $lng;
    global $sql;

    $query     = $sql->query('UPDATE ' . $dbtable . ' SET ' . implode(',', $edit) . ' WHERE `id` = "' . $id . '"');
    $dbrelCat  = $dbtable . '_rel';
    $dbrelInfo = $dbtable . '_info_rel';

    $cat ? insertCatStore($dbrelCat, $code, $cat) : false;
    $info ? insertCatStore($dbrelInfo, $code, $info) : false;
    $stock ? insertProdStock($code, $stock) : false;

    return $query ? true : false;
}

// ADICIONAR STOCK AO PRODUTO
function insertProdStock( $code, $stock )
{

    global $lng;
    global $sql;

    mysql_query('DELETE FROM dc_store_stock WHERE idprod = "' . $code . '"');
    foreach ( $stock as $tag => $val )
        mysql_query('INSERT INTO dc_store_stock (idcat,idprod,stock) VALUES ("' . $tag . '","' . $code . '","' . $val . '")');
}

// ADICIONAR CATEGORIAS AO PRODUTO
function insertCatStore( $dbrel, $code, $cat )
{

    global $lng;
    global $sql;

    deleteSubCat($dbrel, $code);

    $catVals = array();

    if ( is_array($cat[ 'subcat' ]) ) {
        foreach ( $cat[ 'subcat' ] as $val ) {

            list($c, $sc) = explode('|', $val);
            $catVals[] = $c;

            insertSubCat($dbrel, $code, $c, $sc, $cat[ 'price' ][ $sc ]);
        }
    }
    foreach ( $cat[ 'cat' ] as $val )
        if ( !in_array($val, $catVals) )
            insertSubCat($dbrel, $code, $val, false, false);
}

// PESQUISAR PRODUTOS DA LOJA POR CATEGORIAS
function getsubCatStorePesq( $code, $sub = '' )
{

    global $sql;
    global $lang;

    $rtn[] = '<option></option>';

    $res = $sql->query('SELECT id, code, name FROM dc_store_products_subCategory WHERE idcat = "' . $code . '" AND lang = "' . $lang . '" ORDER BY `order` ASC');
    while ( $subcat = $sql->fetch($res) )
        $rtn[] = '<option class="margin-left" value="' . $subcat->code . '" ' . ( $subcat->code == $sub ? 'selected="selected"' : '' ) . '>' . $subcat->name . '</option>';

    return implode('', $rtn);
}

// #####################| PROMO��ES
// ADICIONAR
function insertPromo( $dbtable, $field, $value, $catUser, $catProd )
{

    global $lng;
    global $sql;

    $code = getPassword(8);

    foreach ( $lng->getall() as $l )
        $query = $sql->query('INSERT INTO ' . $dbtable . ' (' . implode(',', $field) . ',`lang`,`code`) VALUES (' . implode(',', $value) . ',"' . $l . '","' . $code . '")');

    deletePromoCat($code);
    $catUser ? insertPromoUser($code, $catUser) : '';
    $catProd ? insertPromoProd($code, $catProd) : '';

    return $query ? true : false;
}

// EDITAR
function editPromo( $dbtable, $id, $code, $edit, $catUser, $catProd )
{

    global $lng;
    global $sql;

    $query = $sql->query('UPDATE ' . $dbtable . ' SET ' . implode(',', $edit) . ' WHERE `id` = "' . $id . '"');

    deletePromoCat($code);
    $catUser ? insertPromoUser($code, $catUser) : '';
    $catProd ? insertPromoProd($code, $catProd) : '';

    return $query ? true : false;
}

// RELA��ES COM  PRODUTOS
function insertPromoProd( $code, $cat )
{
    foreach ( $cat as $p ) {
        list($cat, $subcat, $prod) = explode('|', $p);
        mysql_query('INSERT INTO dc_store_promotions_prod_rel (`idpromo`,`idcat`,`idsubcat`,`idprod`) VALUES ("' . $code . '","' . $cat . '","' . $subcat . '","' . $prod . '")');
    }
}

// RELA��ES COM UTILIZADORES
function insertPromoUser( $code, $cat )
{
    foreach ( $cat as $u ) {
        list($subcat, $user) = explode('|', $u);
        mysql_query('INSERT INTO dc_store_promotions_user_rel (`idpromo`,`idsubcat`,`iduser`) VALUES ("' . $code . '","' . $subcat . '","' . $user . '")');
    }
}

// APAGAR RELA��ES
function deletePromoCat( $code )
{
    mysql_query('DELETE FROM dc_store_promotions_prod_rel WHERE idpromo = "' . $code . '"');
    mysql_query('DELETE FROM dc_store_promotions_user_rel WHERE idpromo = "' . $code . '"');
}

// #####################| NEWSLETTER
// ADICIONAR
function insertNewsletter( $dbtable, $field, $value, $user, $news )
{

    global $lng;
    global $sql;

    $code = getPassword(8);

    foreach ( $lng->getall() as $l )
        $query = $sql->query('INSERT INTO ' . $dbtable . ' (' . implode(',', $field) . ',`lang`,`code`) VALUES (' . implode(',', $value) . ',"' . $l . '","' . $code . '")');

    deleteNewsletterRel($code);
    $user ? insertNewsletterUser($code, $user) : '';
    $news ? insertNewsletterNews($code, $news) : '';

    return $query ? true : false;
}

// EDITAR
function editNewsletter( $dbtable, $id, $code, $edit, $user, $news )
{

    global $lng;
    global $sql;

    $query = $sql->query('UPDATE ' . $dbtable . ' SET ' . implode(',', $edit) . ' WHERE `id` = "' . $id . '"');

    deleteNewsletterRel($code);
    $user ? insertNewsletterUser($code, $user) : '';
    $news ? insertNewsletterNews($code, $news) : '';

    return $query ? true : false;
}

// RELA��ES COM USERS
function insertNewsletterUser( $code, $arr )
{
    foreach ( $arr as $u ) {
        list($group, $id) = explode('|', $u);
        mysql_query('INSERT INTO dc_newsletter_user_rel (`idnewsletter`,`idusergroup`,`iduser`) VALUES ("' . $code . '","' . $group . '","' . $id . '")');
    }
}

// RELA��ES COM NOTICIAS
function insertNewsletterNews( $code, $arr )
{
    foreach ( $arr as $id )
        mysql_query('INSERT INTO dc_newsletter_news_rel (`idnewsletter`,`idnews`) VALUES ("' . $code . '","' . $id . '")');
}

// APAGAR RELA��ES
function deleteNewsletterRel( $code )
{
    mysql_query('DELETE FROM dc_newsletter_user_rel WHERE idnewsletter = "' . $code . '"');
    mysql_query('DELETE FROM dc_newsletter_news_rel WHERE idnewsletter = "' . $code . '"');
}

// MOSTRADOR DE NEWSLETTERS ENVIADAS
function showSentNewsletter( $sent, $newsletter, $finish = false )
{
    global $sql;

    $total   = $sql->nrows($sql->query('SELECT u.id FROM dc_newsletter_user_rel AS r JOIN dc_users AS u ON u.id = r.iduser WHERE r.idnewsletter = "' . $newsletter . '" AND !ISNULL(u.newsletter)'));
    $percent = number_format(( $sent / $total ) * 100, 2, ',', '');

    return ( $finish ? ( $sent == $total ? 'true' : 'false' ) . '##' : '' ) . '<p>� Enviados ' . $sent . ' de ' . $total . ' - (' . $percent . '%)</p>';
    if ( $finish && $sent == $total ) unset($_SESSION[ 'sendNewsletter' ]);
}

// #####################| GERAL
// LISTAGEM DAS IMAGENS NO DOTCONTROL
function listCutImgBox( $img, $hidden, $file, $del = false, $multidel = false, $order = false, $align = false )
{

    global $sql;
    global $lang;
    global $dclang;

    $side = array(
        'left'  => $dclang[ 'alignLeft' ],
        //'center'	=> $dclang['alignCenter'],
        'right' => $dclang[ 'alignRight' ] );

    $dbdata = $sql->fetch($sql->query('SELECT title,align FROM dc_content_imgSettings WHERE file = "' . $file . '" AND lang = "' . $lang . '"'));

    $move  = $order ? ' move' : '';
    $multi = $multidel ? ' imgexplorer' : '';

    $rtn[] = '<div class="image_galery' . $move . '" id="' . $file . '">';
    $rtn[] = '<div class="img-content' . $multi . '">';
    $rtn[] = '<table cellspacing="0" cellpadding="0">';
    $rtn[] = '<tr><td colspan="2" class="thumb">' . $img . '</td></tr>';
    if ( $del ) {
        $rtn[] = '<tr>';
        $rtn[] = '<td class="title">';
        if ( $align ) {
            foreach ( $side as $s => $t )
                $rtn[] = '<div class="align img_' . $s . '" title="' . $t . '"><img class="icon-hover' . ( $dbdata->align == $s ? ' current' : '' ) . '" alt="img" src="img/icon-align_' . $s . '.png" /></div>';
        }
        $rtn[] = '</td>';
        $rtn[] = '<td class="delete">';
        $rtn[] = '<form action="" method="POST">';
        $rtn[] = $hidden;
        $rtn[] = '<input class="confirm" align="absmiddle" type="image" src="img/btn_apagar16.png" />';
        $rtn[] = '</form>';
        $rtn[] = '</td>';
        $rtn[] = '</tr>';
        if ( $align ) {
            $rtn[] = '<tr>';
            $rtn[] = '<td colspan="2"><input type="text" class="imgDesc" value="' . $dbdata->title . '" title="' . $dclang[ 'saveImgDesc' ] . '" /></td>';
            $rtn[] = '</tr>';
        }
    }
    $rtn[] = '</table>';
    $rtn[] = '</div>';
    $rtn[] = '<div id="clear"></div>';
    $rtn[] = '</div>';

    return implode('', $rtn);
}

// INSERIR REL. DAS CATEGORIAS (GRUPOS E LOJA)
function insertSubCat( $dbrel, $code, $cat, $subcat, $price )
{
    mysql_query('INSERT INTO ' . $dbrel . ' (idreg,idcat,idsubcat,price) VALUES ("' . $code . '","' . $cat . '",' . ( $subcat ? '"' . $subcat . '"' : 'NULL' ) . ',' . ( $price ? '"' . $price . '"' : 'NULL' ) . ')');
}

// APAGAR REL. DAS CATEGORIAS (GRUPOS E LOJA)
function deleteSubCat( $dbrel, $code )
{
    mysql_query('DELETE FROM ' . $dbrel . ' WHERE idreg = "' . $code . '"');
}

//////////////////////////////////////////////////////
//						STORE						//
//////////////////////////////////////////////////////

// FINALIZA��O DA COMPRA - VALORES REAIS DO CARRINHO
function submitForm()
{

    global $langvars;
    global $lang;

    $p     = 1;
    $rtn[] = '<input type="hidden" name="item_name_' . $p . '" value="' . $langvars[ 'store_totalbuy' ] . '" />';
    $rtn[] = '<input type="hidden" name="amount_' . $p . '" value="' . strToArray(getTotalCart(), '|', 3) . '" class="totalCartValue" />';
    $rtn[] = '<input type="hidden" name="quantity_' . $p . '" value="1" />';

    return implode('', $rtn);
}

// ADICIONAR AO CARRINHO
function addCart( $code, $amount, $stk, $ft )
{
    global $sql;
    global $store;
    global $langvars;
    global $lang;
    global $user;


    if ( $ft ) {
        if ( sizeof($ft) > 1 ) {
            foreach ( $ft as $k ) {
                list($c, $s) = explode('##', $k);
                $str[] = 'r.idinfosubcat = "' . $s . '"';
            }
            $res = $sql->query('SELECT r.code FROM dc_store_buy_prod_info_rel AS r JOIN dc_store_shoppingCart AS s ON s.code = r.code WHERE r.idprod = "' . $code . '" AND s.' . $user[ 'str' ] . ' = "' . $user[ 'id' ] . '" AND ' . implode(' OR ', $str) . ' ORDER BY `code` ASC');
            while ( $dbdata = $sql->fetch($res) ) {
                if ( $tmp == $dbdata->code ) {
                    $delCode = $dbdata->code;
                    break;
                }
                $tmp = $dbdata->code;
            }
        } else {
            foreach ( $ft as $k ) {
                list($c, $s) = explode('##', $k);
                $dbdata = $sql->fetch($sql->query('
													  SELECT r.code
													  FROM dc_store_buy_prod_info_rel AS r
													  JOIN dc_store_shoppingCart AS s ON s.code = r.code
													  WHERE r.idprod = "' . $code . '" AND r.idinfocat = "' . $c . '" AND r.idinfosubcat = "' . $s . '" AND s.' . $user[ 'str' ] . ' = "' . $user[ 'id' ] . '"'));

                $delCode = $dbdata->code ? $dbdata->code : false;
            }
        }
    } else
        $dbdata = $sql->fetch($sql->query('SELECT code FROM dc_store_shoppingCart WHERE idprod = "' . $code . '" AND ' . $user[ 'str' ] . ' = "' . $user[ 'id' ] . '"'));

    if ( !$delCode )
        $delCode = $dbdata->code ? $dbdata->code : false;

    if ( $delCode ) {
        $sql->query('DELETE FROM dc_store_shoppingCart WHERE code = "' . $delCode . '"');
        $sql->query('DELETE FROM dc_store_buy_prod_info_rel WHERE code = "' . $delCode . '"');
    }

    $prod = $sql->fetch($sql->query('SELECT s.stock FROM dc_store_products AS p JOIN dc_store_stock AS s ON s.idprod = p.code WHERE s.idcat = "' . $stk . '" AND p.lang = "' . $lang . '" AND p.code = "' . $code . '"'));

    if ( $prod->stock >= $amount ) {

        $ftcode = getPassword(8);
        $field  = array( '`' . $user[ 'str' ] . '`', '`code`', '`idprod`', '`amount`', '`date`', '`coin`', '`idstock`' );
        $value  = array( '"' . $user[ 'id' ] . '"', '"' . $ftcode . '"', '"' . $code . '"', '"' . $amount . '"', '"' . date('Y-m-d') . '"', '"' . $store->coin . '"', '"' . $stk . '"' );

        $query = $sql->query('INSERT INTO dc_store_shoppingCart (' . implode(',', $field) . ') VALUES (' . implode(',', $value) . ')');

        if ( $ft ) {
            foreach ( $ft as $k ) {
                list($c, $s) = explode('##', $k);
                $sql->query('INSERT INTO dc_store_buy_prod_info_rel (`code`,`idprod`,`idinfocat`,`idinfosubcat`) VALUES ("' . $ftcode . '","' . $code . '","' . $c . '","' . $s . '")');
            }
        }

        list($total[ 'item' ], $total[ 'tax' ], $total[ 'voucher' ], $total[ 'total' ], $total[ 'num' ]) = strToArray(getTotalCart(), '|');

        return json_encode($total);
    } else
        return json_encode($langvars[ 'store_noStock' ]);
}

// APAGAR DO CARRINHO
function delCart( $code )
{
    global $sql;

    $sql->query('DELETE FROM dc_store_shoppingCart WHERE code = "' . $code . '"');
    $sql->query('DELETE FROM dc_store_buy_prod_info_rel WHERE code = "' . $code . '"');

    list($total[ 'item' ], $total[ 'tax' ], $total[ 'voucher' ], $total[ 'total' ], $total[ 'num' ]) = strToArray(getTotalCart(), '|');
    $total[ 'delivery' ] = getDeliveryStatus();

    return json_encode($total);
}

// DEFINIR NUMERO DE PRODUTOS A ENCOMENDAR
function setAmount( $code, $num )
{
    global $sql;
    global $langvars;
    global $lang;

    $prod = $sql->fetch($sql->query('
										SELECT sk.stock
										FROM dc_store_shoppingCart AS s
										JOIN dc_store_products AS p ON p.code = s.idprod
										JOIN dc_store_stock AS sk ON sk.idcat = s.idstock
										WHERE s.code = "' . $code . '" AND sk.idprod = p.code AND p.lang = "' . $lang . '"'));

    if ( $prod->stock >= $num ) {
        $query = $sql->query('UPDATE dc_store_shoppingCart SET `amount` = "' . $num . '" WHERE code = "' . $code . '"');

        list($total[ 'item' ], $total[ 'tax' ], $total[ 'voucher' ], $total[ 'total' ], $total[ 'num' ]) = strToArray(getTotalCart(), '|');
        $total[ 'delivery' ] = getDeliveryStatus();

        return json_encode($total);
    } else
        return json_encode($langvars[ 'store_noStock' ]);
}

// VERIFICAR STOCK NA FINALIZA��O DA COMPRA
function checkStock( $val )
{
    global $sql;
    global $langvars;
    global $lang;

    foreach ( $val as $id ) {

        $prod = $sql->fetch($sql->query('
											SELECT p.ref,p.name,s.amount,sk.stock
											FROM dc_store_shoppingCart AS s
											JOIN dc_store_products AS p ON p.code = s.idprod
											JOIN dc_store_stock AS sk ON sk.idcat = s.idstock
											WHERE s.id = "' . $id . '" AND sk.idprod = p.code AND p.lang = "' . $lang . '"'));

        if ( $prod->stock < $prod->amount )
            $alert[] = '<li>' . $prod->ref . ' - ' . $prod->name . ' (<b>' . $langvars[ 'store_stock' ] . ': ' . $prod->stock . '</b>)</li>';
    }

    if ( is_array($alert) )
        return implode('', $alert);
    else
        return true . '|#|' . submitForm();
}

// TOTAIS DO CARRINHO DE COMPRAS
function getTotalCart()
{

    global $sql;
    global $lang;
    global $user;

    $res = $sql->query('
						  SELECT s.idprod,s.code AS itemCode,s.amount,t.value AS tax
						  FROM dc_store_shoppingCart AS s
						  JOIN dc_store_products AS p ON p.code = s.idprod
						  JOIN dc_store_tax AS t ON t.id = p.idtax
						  WHERE s.' . $user[ 'str' ] . ' = "' . $user[ 'id' ] . '" AND p.lang = "' . $lang . '"');

    while ( $cart = $sql->fetch($res) ) {
        list($promo, $realVal, $pvp) = checkProdValues($cart->idprod, $cart->itemCode);
        $items[] = array( 'amount' => $cart->amount, 'value' => $pvp, 'tax' => $cart->tax );
    }

    if ( is_array($items) ) {
        foreach ( $items as $k => $val ) {

            $calcAmount = $val[ 'value' ] * $val[ 'amount' ];


            $totalVoucher += $calcAmount;
            $totalTax     += $calcAmount * getIva($val[ 'tax' ]);
        }
    }

    $total = ( $totalVoucher + $totalTax ) - $_SESSION[ 'cartvars' ][ 'creditval' ];

    $voucher = checkVoucherValue(checkVoucherCode(), $total);
    $total   = setVoucherDiscount($total);

    $values[] = number_format($totalVoucher, 2);
    $values[] = number_format($totalTax, 2);
    $values[] = number_format($voucher, 2);
    $values[] = number_format($total, 2);
    $values[] = $sql->nrows($res);

    return implode('|', $values);
}

// CALCULAR DESCONTOS E PROMO��ES
function checkProdValues( $idprod, $info = false )
{

    global $sql;
    global $login;
    global $simbol;
    global $lang;

    $promoProd = $sql->fetch($sql->query('SELECT idpromo FROM dc_store_promotions_prod_rel WHERE idprod = "' . $idprod . '"'));
    $promoUser = $sql->fetch($sql->query('SELECT idpromo FROM dc_store_promotions_user_rel WHERE iduser = "' . $login->id . '"'));

    $prod  = $sql->fetch($sql->query('SELECT * FROM dc_store_products WHERE code = "' . $idprod . '"'));
    $value = $prod->pvp;
    $pvp   = $value;

    if ( $info ) {
        $res2 = $sql->query('SELECT s.price FROM dc_store_products_info_rel AS s JOIN dc_store_buy_prod_info_rel AS r ON r.idinfosubcat = s.idsubcat WHERE r.code = "' . $info . '" AND s.idreg = "' . $idprod . '"');
        while ( $ft = $sql->fetch($res2) )
            $pvp += $ft->price;
    }

    if ( $promoProd || $promoUser ) {

        $cond = array( 'initdate <= "' . date('Y-m-d') . '"', 'enddate >= "' . date('Y-m-d') . '"', 'type = "promotion"', 'status = "1"', 'lang="' . $lang . '"' );

        if ( $promoUser )
            $promo = $sql->fetch($sql->query('SELECT * FROM dc_store_promotions WHERE code = "' . $promoUser->idpromo . '" AND ' . implode(' AND ', $cond) . ' ORDER BY `order` ASC LIMIT 1'));
        if ( $promoProd && !$promo )
            $promo = $sql->fetch($sql->query('SELECT * FROM dc_store_promotions WHERE code = "' . $promoProd->idpromo . '" AND ' . implode(' AND ', $cond) . ' ORDER BY `order` ASC LIMIT 1'));

        if ( $promo->percent ) {
            $discount  = $value * ( $promo->percent / 100 );
            $promotion = '-' . $promo->percent . '%';
        } elseif ( $promo->value ) {
            $discount  = $promo->value;
            $promotion = '-' . $discount . $simbol;
        }
        $pvp -= $discount;
    }
    return array( $promotion, $value, $pvp );
}

// APLICAR DESCONTO DO VOUCHER
function setVoucherDiscount( $value, $voucher = false )
{

    if ( !$voucher )
        $voucher = checkVoucherCode();

    if ( $voucher )
        return $value - checkVoucherValue($voucher, $value);
    else
        return $value;
}

// VERIFICAR VOUCHER
function checkVoucherCode()
{

    global $sql;
    global $login;

    $condition = array( 'code = "' . $_SESSION[ 'cartvars' ][ 'vouchercode' ] . '"', 'user = "' . $login->id . '"', 'initdate <= "' . date('Y-m-d') . '"', 'enddate >= "' . date('Y-m-d') . '"', 'status = "1"', 'ISNULL(used)' );
    $voucher   = $sql->fetch($sql->query('SELECT id,percent,value,minValue FROM dc_store_voucher WHERE ' . implode(' AND ', $condition)));

    if ( $voucher )
        return $voucher;
    else
        return false;
}

// VERIFICAR VALOR DO VOUCHER
function checkVoucherValue( $voucher, $value )
{
    if ( $value >= $voucher->minValue )
        return $voucher->percent ? ( $value * ( $voucher->percent / 100 ) ) : $voucher->value;
    else
        return 0;
}

// VERIFICAR PROMO��ES DE PORTES GR�TIS
function checkFreeDelivery()
{

    global $sql;
    global $lang;

    $promo = $sql->fetch($sql->query('
										SELECT freedeliveryminvalue,freedeliveryminitems FROM dc_store_promotions
										WHERE initdate <= "' . date('Y-m-d') . '" AND enddate >= "' . date('Y-m-d') . '" AND `type` = "freedelivery" AND status = "1"
										ORDER BY `order` ASC LIMIT 1'));

    if ( $promo )
        return $promo;
}

// APLICAR OU N�O PROMO��ES DE PORTES GR�TIS
function getDeliveryStatus()
{

    list($total[ 'item' ], $total[ 'tax' ], $total[ 'voucher' ], $total[ 'total' ]) = strToArray(getTotalCart(), '|');

    $freedel = checkFreeDelivery();

    $deliveryValue = $freedel->freedeliveryminvalue;
    $deliveryItems = $freedel->freedeliveryminitems;
    $name          = 'handling_cart';

    if ( $deliveryValue )
        return $name . ( str_replace(',', '', $total[ 'total' ]) >= $deliveryValue ? '_free' : '' );
    elseif ( $deliveryItems )
        return $name . ( getCartAmount() >= $deliveryItems ? '_free' : '' );
    else
        return $name;
}

// VERIFICAR NUMERO DE ITEMS NO CARRINHO
function getCartAmount()
{
    list($total[ 'item' ], $total[ 'tax' ], $total[ 'voucher' ], $total[ 'total' ], $total[ 'num' ]) = strToArray(getTotalCart(), '|');
    return $total[ 'num' ];
}

// VERIDICAR SE MOSTRA PRE�OS COM IVA OU N�O
function checkIva( $val, $tax )
{
    global $simbol;
    global $store;

    return number_format($store->showtax ? calcIva($val, $tax) : $val, 2) . $simbol;
}

// IVA
function getIva( $tax )
{
    return $tax / 100;
}

// CALCULAR VALOR COM IVA
function calcIva( $val, $tax )
{
    return $val * ( getIva($tax) + 1 );
}

// VAL FORMAT
function valformat( $val, $s = false )
{
    global $simbol;

    $sym = $s ? $s : $simbol;
    return number_format($val, 2) . $sym;
}

function normalize_special_characters( $str )
{
    $str            = ereg_replace(chr(ord("`")), "'", $str);
    $str            = ereg_replace(chr(ord("")), "'", $str);
    $str            = ereg_replace(chr(ord("")), ",", $str);
    $str            = ereg_replace(chr(ord("`")), "'", $str);
    $str            = ereg_replace(chr(ord("")), "'", $str);
    $str            = ereg_replace(chr(ord("")), "\"", $str);
    $str            = ereg_replace(chr(ord("")), "\"", $str);
    $str            = ereg_replace(chr(ord("")), "'", $str);
    $unwanted_array = array( '`' => 'S', 'a' => 'a', '}' => 'Z', '~' => 'z', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'A', '' => 'C', '' => 'E', '' => 'E',
                             '' => 'E', '' => 'E', '' => 'I', '' => 'I', '' => 'I', '' => 'I', '' => 'N', '' => 'O', '' => 'O', '' => 'O', '' => 'O', '' => 'O', '' => 'O', '' => 'U',
                             '' => 'U', '' => 'U', '' => 'U', '' => 'Y', '' => 'B', '' => 'Ss', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'a', '' => 'c',
                             '' => 'e', '' => 'e', '' => 'e', '' => 'e', '' => 'i', '' => 'i', '' => 'i', '' => 'i', '' => 'o', '' => 'n', '' => 'o', '' => 'o', '' => 'o', '' => 'o',
                             '' => 'o', '' => 'o', '' => 'u', '' => 'u', '' => 'u', '' => 'y', '' => 'y', '' => 'b', '' => 'y' );
    $str            = strtr($str, $unwanted_array);
    $str            = ereg_replace(chr(149), "&#8226;", $str);
    $str            = ereg_replace(chr(150), "&ndash;", $str);
    $str            = ereg_replace(chr(151), "&mdash;", $str);
    $str            = ereg_replace(chr(153), "&#8482;", $str);
    $str            = ereg_replace(chr(169), "&copy;", $str);
    $str            = ereg_replace(chr(174), "&reg;", $str);
    return $str;
}

// RETORNA ID DO V�DEO DO YOUTUBE
function getIdYoutube( $url )
{
    parse_str(parse_url($url, PHP_URL_QUERY), $yt);
    return $yt[ 'v' ];
}

function listFolderFiles( $dir )
{
    $fileInfo     = scandir($dir);
    $allFileLists = [];

    foreach ( $fileInfo as $folder ) {
        if ( $folder !== '.' && $folder !== '..' ) {
            if ( is_dir($dir . DIRECTORY_SEPARATOR . $folder) === true ) {
                $allFileLists[ $folder . '/' ] = listFolderFiles($dir . DIRECTORY_SEPARATOR . $folder);
            } else {
                $allFileLists[ $folder ] = $folder;
            }
        }
    }

    return $allFileLists;
}

?>
