<?php
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
function getWorkdays($date1, $date2, $workSat = FALSE, $patron = NULL) {
	if (!defined('SATURDAY')) define('SATURDAY', 6);
	if (!defined('SUNDAY')) define('SUNDAY', 0);
	if (!defined('THURSDAY')) define('THURSDAY', 4);

	// Array of all public festivities
	$publicHolidays = array('01-01', '04-25', '05-01','07-04', '06-10', '08-15', '10-05', '11-01', '12-01', '12-08','12-25');
	// The Patron day (if any) is added to public festivities
	if ($patron) {
		$publicHolidays[] = $patron;
	}

	/*
     * Array of all Easter Mondays in the given interval
     */
	$yearStart = date('Y', strtotime($date1));
	$yearEnd   = date('Y', strtotime($date2));

	for ($i = $yearStart; $i <= $yearEnd; $i++) {
		$easter = date('Y-m-d', easter_date($i));
		list($y, $m, $g) = explode("-", $easter);
		$monday = mktime(0,0,0, date($m), date($g)+1, date($y));
		$easterMondays[] = $monday;
	}

	$start = strtotime($date1);
	$end   = strtotime($date2);
	$workdays = 0;
	for ($i = $start; $i <= $end; $i = strtotime("+1 day", $i)) {
		$day = date("w", $i);  // 0=sun, 1=mon, ..., 6=sat
		$mmgg = date('m-d', $i);
		$somou=false;

		if (
			$day != SUNDAY && (!in_array($mmgg, $publicHolidays)
				||
				(in_array($mmgg, $publicHolidays) && $day == THURSDAY && date("Y-m-d",$i) == $date1)) &&	!in_array($i, $easterMondays) && !($day == SATURDAY && $workSat == FALSE)) {
		$somou=true;
			$workdays++;
		}
		
//		echo "<p style='".($somou?"color:green;":"color:red;")."'>".date('Y-m-d',$i)." ($workdays)</p>";
	}
//	echo "-----------------------------------------------";
	return intval($workdays);
}
function get_holidays()
{
	// arrays
	$days_array = array();

	// You have to put there your source of holidays and make them as array...
	// For example, database in Codeigniter:
	// $days_array = $this->my_model->get_holidays_array();

	return $days_array;
}
function get_workdays($from,$to)
{
	// arrays
	$days_array = array();
	$skipdays = array("Saturday", "Sunday");
	$skipdates = get_holidays();

	// other variables
	$i = 0;
	$current = $from;

	if($current == $to) // same dates
	{
		$timestamp = strtotime($from);
		if (!in_array(date("l", $timestamp), $skipdays)&&!in_array(date("Y-m-d", $timestamp), $skipdates)) {
			$days_array[] = date("Y-m-d",$timestamp);
		}
	}
	elseif($current < $to) // different dates
	{
		while ($current < $to) {
			$timestamp = strtotime($from." +".$i." day");
			if (!in_array(date("l", $timestamp), $skipdays)&&!in_array(date("Y-m-d", $timestamp), $skipdates)) {
				$days_array[] = date("Y-m-d",$timestamp);
			}
			$current = date("Y-m-d",$timestamp);
			$i++;
		}
	}

	return $days_array;
}
function get_working_hours($from,$to,$t)
{
	// timestamps
	$from_timestamp = strtotime($from);
	$to_timestamp = strtotime($to);

	// work day seconds
	$workday_start_hour = 0;
	if($t==1)
	$workday_end_hour = 24;
	else
	$workday_end_hour = 24;
	$workday_seconds = ($workday_end_hour - $workday_start_hour)*3600;

	// work days beetwen dates, minus 1 day
	$from_date = date('Y-m-d',$from_timestamp);
	$to_date = date('Y-m-d',$to_timestamp);
	$workdays_number = count(get_workdays($from_date,$to_date))-1;
	$workdays_number = $workdays_number<0 ? 0 : $workdays_number;

	// start and end time
	$start_time_in_seconds = date("H",$from_timestamp)*3600+date("i",$from_timestamp)*60;
	$end_time_in_seconds = date("H",$to_timestamp)*3600+date("i",$to_timestamp)*60;

	// final calculations
	$working_hours = ($workdays_number * $workday_seconds + $end_time_in_seconds - $start_time_in_seconds) / 86400 * 24;

	return number_format(($working_hours/24),2);
}
function checkFinalizado($id){
	global $sql;
	global $admin;
	$q = $sql->query('SELECT * FROM processos WHERE IDGDProcesso="'.$id.'"');
	while($r=$sql->fetch($q)){
		$id = $r->IDGDProcesso;
		$check           = $sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="' . $id . '"'));
		$checkIfHasUsers = $sql->fetch($sql->query('SELECT `id` FROM `intervenientes` WHERE `id_processo`="' . $id . '" '));
		$checkIfPago     = $sql->fetch($sql->query('SELECT `id` FROM `intervenientes` WHERE `id_processo`="' . $id . '" AND `pago`!=1  AND (`status`=1 OR `tipo_user`=2)'));
		$isdone    = false;
		$getProc   = $sql->fetch($sql->query('SELECT * FROM processos WHERE idGDProcesso="' . $id . '"'))->valorfatura;
		$getProc2  = $sql->fetch($sql->query('SELECT * FROM processos WHERE idGDProcesso="' . $id . '"'))->valorfatura2;
		$getPagSum = $sql->fetch($sql->query('SELECT SUM(valor) AS sum FROM pagamentos_processo WHERE id_processo="' . $id . '"'))->sum;
		if ( $getPagSum == ( $getProc + $getProc2 ) ) {
			$isdone = true;
			// var_dump($getProc);
			// var_dump($getProc2);
			// var_dump($getPagSum);
		}
		if ( $check->numfatura && $check->dataFaturacao && ($check->valorfatura2==0 || $check->valorfatura2>0 && $check->numfatura2 && $check->dataFaturacao2 ) && !$checkIfPago->id && $check->IDWorkFlowState == "131" && $checkIfHasUsers && $isdone ) {
			{
				$getProcInfo = $sql->fetch($sql->query('SELECT * FROM processos WHERE idGDProcesso="' . $id . '"'));
				$sql->query('UPDATE `processos` SET `IDWorkFlowState`=137 WHERE `IDGDProcesso`="' . $id . '"');
				$sql->query('UPDATE `alertas` SET `lido`=1,`lido_por`=1456,`data_lido`="' . date('Y-m-d') . '",`hora_lido`="' . date('H:i:s') . '" WHERE `processo_id`="' . $id . '" AND `lido`=0');
				$sql->query("INSERT INTO GDProcessoWorkflow (`idgdprocesso`,`workflowdate`,`idfrom`,`idto`,`iduser`,`comentario`) VALUES ('" . $id . "','" . date('Y-m-d H:i:s') . "','" . $getProcInfo->IDWorkFlowState . "','137','" . $admin->codExterno . "','A avaliação foi Finalizada')");

			}
		}
	}
}
function clean($string) {
   $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

   $string = cleanString($string); // Replaces all spaces with hyphens.

   return $string; // Removes special chars.
}

function validateDate($date, $format = 'Y-m-d')
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
function getState($id) {
  global $sql;
  $checkState = $sql->fetch($sql->query('SELECT IDWorkFlowState FROM processos WHERE IDGDProcesso="'.$id.'"'));
  return $checkState->IDWorkFlowState;

}
function cleanString($text) {
    $utf8 = array(
        '/[áàâãªä]/u'   =>   'a',
        '/[ÁÀÂÃÄ]/u'    =>   'A',
        '/[ÍÌÎÏ]/u'     =>   'I',
        '/[íìîï]/u'     =>   'i',
        '/[éèêë]/u'     =>   'e',
        '/[ÉÈÊË]/u'     =>   'E',
        '/[óòôõºö]/u'   =>   'o',
        '/[ÓÒÔÕÖ]/u'    =>   'O',
        '/[úùûü]/u'     =>   'u',
        '/[ÚÙÛÜ]/u'     =>   'U',
        '/ç/'           =>   'c',
        '/Ç/'           =>   'C',
        '/ñ/'           =>   'n',
        '/Ñ/'           =>   'N',
        '/–/'           =>   '-', // UTF-8 hyphen to "normal" hyphen
        '/[’‘‹›‚]/u'    =>   ' ', // Literally a single quote
        '/[“”«»„]/u'    =>   ' ', // Double quote
        '/ /'           =>   ' ', // nonbreaking space (equiv. to 0x160)
    );
    return preg_replace(array_keys($utf8), array_values($utf8), $text);
}
function verificaProcessoNumero ($numero,$ano,$cliente) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

	$codigos = $sql->fetch($sql->query('SELECT COUNT(*) AS numero FROM processos WHERE interno_processo LIKE "%'.$ano.'/'.$numero.'%" AND cliente_id="'.$cliente.'"'));

	//$codigos = $sql->fetch($sql->query('SELECT COUNT(*) AS numero FROM codigos WHERE numero="'.$numero.'" AND ano="'.$ano.'"'));
	if($codigos->numero == 0) {


		$codigos2 = $sql->fetch($sql->query('SELECT COUNT(*) AS numero FROM codigos WHERE numero="'.$numero.'" AND ano="'.$ano.'"'));

		if($codigos2->numero == 0) {
			$rtn[] = 0;
		} else {
			$rtn[] = 1;
		}

		//$rtn[] = 1;
	} else {
		$rtn[] = 0;
	}

	return implode('',$rtn);
}

function DuplicateMySQLRecord ($table, $id_field, $id, $tarefa) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

    // load the original record into an array
    $result = mysql_query("SELECT * FROM {$table} WHERE {$id_field}={$id}");
    $original_record = mysql_fetch_assoc($result);

    // insert the new record and get the new auto_increment id
    mysql_query("INSERT INTO {$table} (`{$id_field}`) VALUES (NULL)");
    $newid = mysql_insert_id();

    // generate the query to update the new record with the previous values
    $query = "UPDATE {$table} SET ";
    foreach ($original_record as $key => $value) {
        if ($key != $id_field && $key != 'agendamento_id' && $key != 'agendamento_hora' && $key != 'agendamento_confirmado' && $key != 'interno_processo' && $key != 'orcamento_aprovado' && $key != 'interno_estado') {
            $query .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
        }
		if ($key == 'interno_estado') {
			$query .= '`'.$key.'` = "41", ';
		}
		if ($key == 'agendamento_id') {
			$query .= '`'.$key.'` = "0", ';
		}
		if ($key == 'agendamento_hora') {
			$query .= '`'.$key.'` = NULL, ';
		}
		if ($key == 'agendamento_confirmado') {
			$query .= '`'.$key.'` = "0", ';
		}
		if ($key == 'orcamento_aprovado') {
			$query .= '`'.$key.'` = "1", ';
		}
		if ($key == 'interno_processo') {
			$subnum 	= $sql->fetch($sql->query('SELECT * FROM codigos WHERE id_processo="'.$id.'"'));
			$revnum 	= $sql->fetch($sql->query('SELECT * FROM codigos WHERE ano="'.$subnum->ano.'" AND numero="'.$subnum->numero.'" AND sub="'.$subnum->sub.'" ORDER BY `revisao` DESC LIMIT 1'));
			$revisao 	= ($revnum->revisao+1);
			$rev = explode('-', $value);

			$query .= '`'.$key.'` = "'.$rev[0].'-'.$rev[1].'-r'.$revisao.'", ';
		}
    }
    $query = substr($query,0,strlen($query)-2); // lop off the extra trailing comma
    $query .= " WHERE {$id_field}={$newid}";
    mysql_query($query);

	$codigos 	= $sql->fetch($sql->query('SELECT * FROM codigos WHERE id_processo="'.$id.'"'));
	$queryfile 	= 'INSERT INTO `codigos` (`ano`,`numero`,`sub`,`revisao`,`id_processo`) VALUES("'.$codigos->ano.'","'.$codigos->numero.'","'.$codigos->sub.'","'.$revisao.'","'.$newid.'");';
	mysql_query($queryfile);

	$tarefa 	= $sql->fetch($sql->query('SELECT * FROM processos_tarefas WHERE id="'.$tarefa.'"'));
	$querytask 	= 'INSERT INTO `processos_tarefas` (`id_tarefa`,`id_processo`,`estado`) VALUES("'.$tarefa->id_tarefa.'","'.$newid.'","10");';
	mysql_query($querytask);

    // return the new id
    return $newid;
}
// DIAS DA SEMANA
function diasemana($data) {
	global $lang;
	$ano =  substr("$data", 0, 4);
	$mes =  substr("$data", 5, -3);
	$dia =  substr("$data", 8, 9);

	$diasemana = date("w", mktime(0,0,0,$mes,$dia,$ano) );
	if ($lang=="pt") {
		switch($diasemana) {
			case"0": $diasemana = "Domingo".$lang;       break;
			case"1": $diasemana = "Segunda-Feira"; break;
			case"2": $diasemana = "Terca-Feira";   break;
			case"3": $diasemana = "Quarta-Feira";  break;
			case"4": $diasemana = "Quinta-Feira";  break;
			case"5": $diasemana = "Sexta-Feira";   break;
			case"6": $diasemana = "Sabado";        break;
		}
	}
	elseif ($lang=="es") {
		switch($diasemana) {
			case"0": $diasemana = "Domingo";       break;
			case"1": $diasemana = "Lunes"; break;
			case"2": $diasemana = "Martes";   break;
			case"3": $diasemana = "Miercoles";  break;
			case"4": $diasemana = "Jueves";  break;
			case"5": $diasemana = "Viernes";   break;
			case"6": $diasemana = "Sabado";        break;
		}
	}

	return "$diasemana";
}

// DIAS DA SEMANA
function mes($data) {


	switch($data) {
		case"1": $mes = "Janeiro"; break;
		case"2": $mes = "Fevereiro";   break;
		case"3": $mes = "Marco";  break;
		case"4": $mes = "Abril";  break;
		case"5": $mes = "Maio";   break;
		case"6": $mes = "Junho";        break;
		case"7": $mes = "Julho";        break;
		case"8": $mes = "Agosto";        break;
		case"9": $mes = "Setembro";        break;
		case"10": $mes = "Outubro";        break;
		case"11": $mes = "Novembro";        break;
		case"12": $mes = "Dezembro";        break;

	}

	return "$mes";
}

// LISTAGEM DE DOCUMENTOS DO PROCESSO
function listarEquipamentosAnexos($equipamento) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

	$rescount = $sql->query('SELECT COUNT(*) AS eacount FROM equipamentos_anexos WHERE id_equipamento="'.$equipamento.'"');
	if($rescount->eacount != '0') {
		$res = $sql->query('SELECT * FROM equipamentos_anexos WHERE id_equipamento="'.$equipamento.'"');
		while($file = $sql->fetch($res)) {
			$string = explode(';', $file->anexo);
			$string = $string[0];

			if (strpos($file->anexo,';')) {
				$url = 'http://qualynspect.no-ip.org/admctrl/output/index/equipamentos_anexos/anexo/';
				$nstring = strstr($file->anexo, ';');
				$namestring = str_replace(';','',$nstring);
			} else {
				$url = $base.'include/upload_equipamentos/'.$equipamento.'/';
				$namestring = $file->anexo;
			}

			$rtn[] = '<p id="doc-'.$file->id.'"><a href="'.$url.''.$string.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a>'.delete_button('style="float:right;"','onclick="dp.equipamentos.uploadfilesDelete('.$file->id.');"').'';
			$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));
			$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->data.' '.$langvars['form_indayas'].' '.$file->hora.'</span></p>';
		}
	}
	if($rescount->eacount == '0') {
		$rtn[] = 'Nao existem ficheiros anexados a este equipamento.';
	}
	$rtn[] = '';

	return implode('',$rtn);
}
// LISTAGEM DE DOCUMENTOS DO PROCESSO
function listarProcessoDocs($processo) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;
	global $acesso;

	$pinfo = $sql->fetch($sql->query('SELECT * FROM processos WHERE id="'.$processo.'"'));


	$resone = $sql->query('SELECT * FROM files_groups');
	while($fileginfo = $sql->fetch($resone)) {

	/* if($fileginfo->id == '1' && $acesso->orcamento_ver == '0') {

	} else { */
		if($fileginfo->id == '1' && $acesso->orcamento_ver == '1') {
			$rtn[] = '<h2>'.$fileginfo->descricao.'</h2>';
			$rtn[] = '<div class="line-subtitle"></div>';
		}
		if($fileginfo->id == '2' && $acesso->reltec_ver == '1') {
			$rtn[] = '<h2>'.$fileginfo->descricao.'</h2>';
			$rtn[] = '<div class="line-subtitle"></div>';
		}
		if($fileginfo->id == '3' && $acesso->relaprov_ver == '1') {
			$rtn[] = '<h2>'.$fileginfo->descricao.'</h2>';
			$rtn[] = '<div class="line-subtitle"></div>';
		}
		if($fileginfo->id == '4' && $acesso->outros_ver == '1') {
			$rtn[] = '<h2>'.$fileginfo->descricao.'</h2>';
			$rtn[] = '<div class="line-subtitle"></div>';
		}
	/* } */
		$rescount = $sql->fetch($sql->query('SELECT COUNT(*) AS fcount FROM files WHERE id_processo="'.$pinfo->id.'" AND `group`="'.$fileginfo->id.'" AND status="1"'));

		$res = $sql->query('SELECT * FROM files WHERE id_processo="'.$pinfo->id.'" AND `group`="'.$fileginfo->id.'" AND status="1" ORDER BY `id`');
		while($file = $sql->fetch($res)) {
				$string2 = explode('.', $file->description);
				$string2 = $string[0];
				$nstring2 = strstr($file->description, '.');
				$namestring2 = str_replace('.','',$nstring2);

				if($fileginfo->id == 1 && $acesso->orcamento_ver == '1') {
					$rtn[] = '<p id="doc-'.$file->id.'">';
						$rtn[] = '<a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
						if($acesso->orcamento_del == '1') {
							$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDelete('.$file->id.');"');
						}

						$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));

						$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->upload_data.' '.$langvars['form_indayas'].' '.$file->upload_hora.'</span>';
					$rtn[] = '</p>';
				}
				if($fileginfo->id == 2 && $acesso->reltec_ver == '1') {
					$rtn[] = '<p id="doc-'.$file->id.'">';
						$rtn[] = '<a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
						if($acesso->reltec_del == '1') {
							$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDelete('.$file->id.');"');
						}

						$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));

						$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->upload_data.' '.$langvars['form_indayas'].' '.$file->upload_hora.'</span>';
					$rtn[] = '</p>';
				}
				if($fileginfo->id == 3 && $acesso->relaprov_ver == '1') {
					$rtn[] = '<p id="doc-'.$file->id.'">';

						if ( $file->size == 1) {
						$rtn[] = '<a href="'.$base.'upload/OldImport/'.$file->description.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
						}
						else {
						$rtn[] = '<a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
						}
						if($acesso->relaprov_del == '1') {
							$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDelete('.$file->id.');"');
						}

						$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));

						$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->upload_data.' '.$langvars['form_indayas'].' '.$file->upload_hora.'</span>';
					$rtn[] = '</p>';
				}
				if($fileginfo->id == 4 && $acesso->outros_ver == '1') {
					$rtn[] = '<p id="doc-'.$file->id.'">';
						$rtn[] = '<a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
						if($acesso->outros_del == '1') {
							$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDelete('.$file->id.');"');
						}

						$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));

						$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->upload_data.' '.$langvars['form_indayas'].' '.$file->upload_hora.'</span>';
					$rtn[] = '</p>';
				}

				/*
				if($fileginfo->id == 1 && $acesso->orcamento_ver == '0') {

				} else {
					$rtn[] = '<p id="doc-'.$file->id.'"><a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>'.delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDelete('.$file->id.');"').'';
					$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));
					$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->upload_data.' '.$langvars['form_indayas'].' '.$file->upload_hora.'</span></p>';
				}
				*/

		}
		if($fileginfo->id == 1) {
			$count = 0;
			if($acesso->orcamento_ver == '1') {
				if(!empty($pinfo->orcamento_pdf)) {
					$string = explode(';', $pinfo->orcamento_pdf);
					$string = $string[0];
					$nstring = strstr($pinfo->orcamento_pdf, ';');
					$namestring = str_replace(';','',$nstring);
					$hash = basename($string);
					$tmp = pathinfo($hash);

					$rtn[] = '<p id="docOLD-'.$pinfo->id.'" class="orcamento_pdf" >';
						$rtn[] = '<a href="'.$base.'upload/processos/orcamento_pdf/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a>';
						if($acesso->orcamento_del == '1') {
							$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDeleteOLD('.$pinfo->id.');"');
						}
					$rtn[] = '</p>';

				} elseif ($rescount->fcount == '0' && $count == 0) {
					$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
				}
			}
			$count++;
		}

		if($fileginfo->id == 2) {
			$count = 0;
			if($acesso->reltec_ver == '1') {
				$res2 = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$pinfo->id.'"');
				while($reltec = $sql->fetch($res2)) {

					if(!empty($reltec->relatorio_tecnico_pdf)) {
						$string = explode(';', $reltec->relatorio_tecnico_pdf);
						$string = $string[0];
						$nstring = strstr($reltec->relatorio_tecnico_pdf, ';');
						$namestring = str_replace(';','',$nstring);
						$hash = basename($string);
						$tmp = pathinfo($hash);

						$rtn[] = '<p id="docOLD-'.$reltec->id.'" class="relatorio_tecnico_pdf" >';
							$rtn[] = '<a href="'.$base.'upload/separacao/relatorio_tecnico_pdf/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a>';
							if($acesso->reltec_del == '1') {
								$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDeleteOLD('.$reltec->id.');"');
							}
						$rtn[] = '</p>';

					} elseif ($rescount->fcount == '0' && $count == 0) {
						$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
					}
					$count++;
				}
			}
		}
		if($fileginfo->id == 3) {
			$count = 0;
			if($acesso->relaprov_ver == '1') {
				$res2 = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$pinfo->id.'"');
				while($reltec = $sql->fetch($res2)) {

					if(!empty($reltec->relatorio_final_assinado)) {
						$string = explode(';', $reltec->relatorio_final_assinado);
						$string = $string[0];
						$nstring = strstr($reltec->relatorio_final_assinado, ';');
						$namestring = str_replace(';','',$nstring);
						$hash = basename($string);
						$tmp = pathinfo($hash);

						$rtn[] = '<p id="docOLD-'.$reltec->id.'" class="relatorio_final_assinado">';
							$rtn[] = '<a href="'.$base.'upload/separacao/relatorio_final_assinado/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a>';
							if($acesso->relaprov_del == '1') {
								$rtn[] = delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDeleteOLD('.$reltec->id.');"');
							}
						$rtn[] = '</p>';

					} elseif ($rescount->fcount == '0' && $count == 0) {
						$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
					}
					$count++;
				}
			}
		}
		if($fileginfo->id == 4) {
			if($acesso->outros_ver == '1') {
				if ($rescount->fcount == '0') {
					$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
				}
			}
		}
	}

	$rtn[] = '';

	return implode('',$rtn);
}

// LISTAGEM DE DOCUMENTOS DO PROCESSO CLIENTE
function listarProcessoDocsCliente($processo) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	$pinfo = $sql->fetch($sql->query('SELECT * FROM processos WHERE id="'.$processo.'"'));

	$show=1;
	$tarefa = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$processo.'" GROUP BY id_processo ');
	while($result = $sql->fetch($tarefa)) {
		if ( $result->formalidades_enviado == "0") { $show=0; }
	}

	$resone = $sql->query('SELECT * FROM files_groups WHERE id IN("1","3")');
	while($fileginfo = $sql->fetch($resone)) {

	if($fileginfo->id == '1' && $admin->idadmingroup == '9') {

	} else {
		$rtn[] = '<h2>'.$langvars['var_estado_'.$fileginfo->id].'</h2>';
		$rtn[] = '<div class="line-subtitle"></div>';
	}
		$rescount = $sql->fetch($sql->query('SELECT COUNT(*) AS fcount FROM files WHERE id_processo="'.$pinfo->id.'" AND `group`="'.$fileginfo->id.'" AND status="1"'));

		$res = $sql->query('SELECT * FROM files WHERE id_processo="'.$pinfo->id.'" AND `group`="'.$fileginfo->id.'" AND status="1" ORDER BY `id`');
		while($file = $sql->fetch($res)) {
				$string2 = explode('.', $file->description);
				$string2 = $string[0];
				$nstring2 = strstr($file->description, '.');
				$namestring2 = str_replace('.','',$nstring2);

				if($fileginfo->id == 1 && $admin->idadmingroup == '9') {

				} else {
					if ( $file->size==1 ) {
					$rtn[] = '<p id="doc-'.$file->id.'"><a href="'.$base.'upload/OldImport/'.$file->description.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
					}
					else {
					$rtn[] = '<p id="doc-'.$file->id.'"><a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>';
					}
					$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));
					$rtn[] = '<br><span style="color:#CCC;">'.$langvars['form_insertto'].' '.$userinfo->firstname.', '.$langvars['form_inday'].' '.$file->upload_data.' '.$langvars['form_indayas'].' '.$file->upload_hora.'</span></p>';
				}
		}
		if($fileginfo->id == 1) {
			$count = 0;
			if($admin->idadmingroup != '9') {
				if(!empty($pinfo->orcamento_pdf)) {
					$string = explode(';', $pinfo->orcamento_pdf);
					$string = $string[0];
					$nstring = strstr($pinfo->orcamento_pdf, ';');
					$namestring = str_replace(';','',$nstring);
					$hash = basename($string);
					$tmp = pathinfo($hash);

					$rtn[] = '<p id="docOLD-'.$pinfo->id.'" class="orcamento_pdf" ><a href="'.$base.'upload/processos/orcamento_pdf/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a></p>';

				} elseif ($rescount->fcount == '0' && $count == 0) {
					$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
				}
			}
			$count++;
		}

		if ( $show=="1") {
			if($fileginfo->id == 3) {
				$count = 0;
				$res2 = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$pinfo->id.'"');
				while($reltec = $sql->fetch($res2)) {

					if(!empty($reltec->relatorio_final_assinado)) {
						$string = explode(';', $reltec->relatorio_final_assinado);
						$string = $string[0];
						$nstring = strstr($reltec->relatorio_final_assinado, ';');
						$namestring = str_replace(';','',$nstring);
						$hash = basename($string);
						$tmp = pathinfo($hash);

						$rtn[] = '<p id="docOLD-'.$reltec->id.'" class="relatorio_final_assinado"><a href="'.$base.'upload/separacao/relatorio_final_assinado/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a></p>';

					} elseif ($rescount->fcount == '0' && $count == 0) {
						$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
					}
					$count++;
				}
			}
		}
	if($fileginfo->id == 4) {
			if ($rescount->fcount == '0') {
				$rtn[] = '<p style="color:#CCC;"> '.$langvars['var_nofiles'].' </p>';
			}
		}
	}

	return implode('',$rtn);



	/*



	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	$pinfo = $sql->fetch($sql->query('SELECT * FROM processos WHERE id="'.$processo.'"'));


	$show=1;
	$tarefa = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$pinfo->id.'" ');
	while($result = $sql->fetch($tarefa)) {
		if ( $result->formalidades_enviado == "0") { $show=0; }
	}


	$resone = $sql->query('SELECT * FROM files_groups WHERE id IN ("1","3") ');
	while($fileginfo = $sql->fetch($resone)) {

	if($fileginfo->id == '1' && $admin->idadmingroup == '9') {

	} else {
		if ( $fileginfo->id != '3') {	$rtn[] = '<h2>'.$fileginfo->descricao.'</h2>'; }
		else {  $rtn[] = '<h2>'.$langvars['client_relatorio'].'</h2>'; }
		$rtn[] = '<div class="line-subtitle"></div>';
	}
		$rescount = $sql->fetch($sql->query('SELECT COUNT(*) AS fcount FROM files WHERE id_processo="'.$pinfo->id.'" AND `group`="'.$fileginfo->id.'" AND status="1"'));

		$res = $sql->query('SELECT * FROM files WHERE id_processo="'.$pinfo->id.'" AND `group`="'.$fileginfo->id.'" AND status="1" ORDER BY `id`');
		while($file = $sql->fetch($res)) {
				$string2 = explode('.', $file->description);
				$string2 = $string[0];
				$nstring2 = strstr($file->description, '.');
				$namestring2 = str_replace('.','',$nstring2);

				$rtn[] = '<p id="doc-'.$file->id.'"><a href="'.$base.'include/upload/'.$pinfo->id.'/'.$file->name.'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$file->description.'</a>'.delete_button('style="float:right;"','onclick="dp.calendario.uploadfilesDelete('.$file->id.');"').'';
				$userinfo = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id = '.$file->userid.''));
				$rtn[] = '<br><span style="color:#CCC;">Inserido por '.$userinfo->firstname.', no dia '.$file->upload_data.' as '.$file->upload_hora.'</span></p>';

		}
		if($fileginfo->id == 1) {
			$count = 0;
			if($admin->idadmingroup != '9') {
				if(!empty($pinfo->orcamento_pdf)) {
					$string = explode(';', $pinfo->orcamento_pdf);
					$string = $string[0];
					$nstring = strstr($pinfo->orcamento_pdf, ';');
					$namestring = str_replace(';','',$nstring);
					$hash = basename($string);
					$tmp = pathinfo($hash);

					$rtn[] = '<p id="docOLD-'.$pinfo->id.'" class="orcamento_pdf" ><a href="'.$base.'upload/processos/orcamento_pdf/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a></p>';
				} elseif ($rescount->fcount == '0' && $count == 0) {
					$rtn[] = '<p style="color:#CCC;">'.$langvars['var_nofiles'].' </p>';
				}
			}
			$count++;
		}

		if($fileginfo->id == 2) {
			$count = 0;
			$res2 = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$pinfo->id.'"');
			while($reltec = $sql->fetch($res2)) {

				if(!empty($reltec->relatorio_tecnico_pdf)) {
					$string = explode(';', $reltec->relatorio_tecnico_pdf);
					$string = $string[0];
					$nstring = strstr($reltec->relatorio_tecnico_pdf, ';');
					$namestring = str_replace(';','',$nstring);
					$hash = basename($string);
					$tmp = pathinfo($hash);

					$rtn[] = '<p id="docOLD-'.$reltec->id.'" class="relatorio_tecnico_pdf" ><a href="'.$base.'upload/separacao/relatorio_tecnico_pdf/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a></p>';
				} elseif ($rescount->fcount == '0' && $count == 0) {
					$rtn[] = '<p style="color:#CCC;">'.$langvars['var_nofiles'].' </p>';
				}
				$count++;
			}
		}
		if ( $show=="1") {
			if($fileginfo->id == 3) {
				$count = 0;
				$res2 = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo="'.$pinfo->id.'"');
				while($reltec = $sql->fetch($res2)) {

					if(!empty($reltec->relatorio_final_assinado)) {
						$string = explode(';', $reltec->relatorio_final_assinado);
						$string = $string[0];
						$nstring = strstr($reltec->relatorio_final_assinado, ';');
						$namestring = str_replace(';','',$nstring);
						$hash = basename($string);
						$tmp = pathinfo($hash);

						$rtn[] = '<p id="docOLD-'.$reltec->id.'" class="relatorio_final_assinado"><a href="'.$base.'upload/separacao/relatorio_final_assinado/'.fileHashRev($tmp['filename'] . '.' . $tmp['extension']).'" target="_blank"><img src="'.$base.'img/site/file.png" style="margin-right: 5px;" />'.$namestring.'</a></p>';

					} elseif ($rescount->fcount == '0' && $count == 0) {
						$rtn[] = '<p style="color:#CCC;">'.$langvars['var_nofiles'].' </p>';
					}
					$count++;
				}
			}
		}
		elseif($fileginfo->id == 3)  {
		$rtn[] = '<p style="color:#CCC;">'.$langvars['var_nofiles'].' </p>';
		}
	}



	return implode('',$rtn);*/
}

// VERIFICAÇÃO DE VALVULAS NO PROCESSO
function verificaProcessoValvulas($processo) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

	$val = $sql->fetch($sql->query('SELECT COUNT(*) AS valvulas FROM processos_tarefas WHERE campo3 LIKE "s%" AND id_tarefa="15" AND id_processo="'.$processo.'"'));

	if($val->valvulas == 0) {

		$numeroval = $sql->fetch($sql->query('SELECT COUNT(*) AS numeroval FROM `processos_tarefas` WHERE campo3_valreal IS NOT NULL AND id_tarefa="15" AND id_processo="'.$processo.'"'));

		if($numeroval->numeroval == 0) {
			$rtn[] = '<center><img src="'.$base.'img/site/x.png" style="vertical-align: bottom;" /></center>';
		} else {

			$i = 0;
			$resr = $sql->query('SELECT * FROM processos_tarefas WHERE campo3_valreal IS NOT NULL AND id_tarefa="15" AND id_processo="'.$processo.'"');
			while($resultreal = $sql->fetch($resr)) {
				$totalreal = $i+$resultreal->campo3_valreal;

				$i++;
			}
			$n = 0;
			$resnr = $sql->query('SELECT * FROM processos_tarefas WHERE campo3_valnaoreal IS NOT NULL AND id_tarefa="15" AND id_processo="'.$processo.'"');
			while($resultnreal = $sql->fetch($resnr)) {
				$totalnreal = $n+$resultnreal->campo3_valnaoreal;

				$n++;
			}

			$totalnrealfinal = (empty($totalnreal) ? '0' : $totalnreal);

			$rtn[] = '<center>'.$totalreal.' - <img src="'.$base.'img/site/v.png" style="vertical-align: bottom;" /></br>';
			$rtn[] = $totalnrealfinal.' - <img src="'.$base.'img/site/x.png" style="vertical-align: bottom;" /></center>';

		}
	} else {
		$rtn[] = '<center><img src="'.$base.'img/site/v.png" style="vertical-align: bottom;" /></center>';
	}

	return implode('',$rtn);
}
// VERIFICAÇÃO DE N2 NO PROCESSO
function verificaProcessoN2($processo) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

	$tnitro = $sql->fetch($sql->query('SELECT COUNT(*) AS nitrogenio FROM processos_tarefas WHERE campo2 LIKE "s%" AND id_tarefa="15" AND id_processo="'.$processo.'"'));

	if($tnitro->nitrogenio == 0) {
		$rtn[] = '<center><img src="'.$base.'img/site/x.png" style="vertical-align: bottom;" /></center>';
	} else {
		$rtn[] = '<center><img src="'.$base.'img/site/v.png" style="vertical-align: bottom;" /></center>';
	}

	return implode('',$rtn);
}
// EVENT ONCLICK FORMALIDADES
function clickFormalidades($id,$section) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

	if($section == 'FATURADO') {
		$rtn[] = '<script>
		$(document).ready(function(){
			$("#formalidades'.$section.'-'.$id.'").on("click",function(){
				var myPlayer = document.getElementById("formalidadesFaturadoEdit-'.$id.'");
				myPlayer.click();
			});
		});
		</script>';
	} else {
		$rtn[] = '
		<script>
		$(document).ready(function(){
			$("#formalidades'.$section.'-'.$id.'").on("click",function(){
				var vars	= { "action"	: "checkFormalidades'.$section.'",
								"id"		: $("#formalidades'.$section.'-'.$id.'").parent().attr("id"),
								"status"	: $("#formalidades'.$section.'-'.$id.'").attr("name") };
				$.post(base + "include/ajax.php", vars, function(rtn){
					var id = $("#formalidades'.$section.'-'.$id.'").parent().attr("id");
					$(".calendar'.$section.'-"+id+"").html(rtn);
				});
			});
		});
		</script>';
	}

	return implode('',$rtn);
}
// VERIFICAÇÃO FORMALIDADES VPN
function checkFormalidadesVPN($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_vpn="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FVPN-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = clickFormalidades($id,'VPN');
		$rtn[] = '<div id="formalidadesVPN-'.$id.'" name="1" class="sucess-check"></div>';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_vpn="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FVPN-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = clickFormalidades($id,'VPN');
		$rtn[] = '<div id="formalidadesVPN-'.$id.'" name="0" class="error-check"></div>';
	}

	return implode('',$rtn);
}
// VERIFICAÇÃO FORMALIDADES AUSTRIA
function checkFormalidadesAUSTRIA($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_austria="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FAUSTRIA-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = clickFormalidades($id,'AUSTRIA');
		$rtn[] = '<div id="formalidadesAUSTRIA-'.$id.'" name="1" class="sucess-check"></div>';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_austria="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FAUSTRIA-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = clickFormalidades($id,'AUSTRIA');
		$rtn[] = '<div id="formalidadesAUSTRIA-'.$id.'" name="0" class="error-check"></div>';
	}

	return implode('',$rtn);
}
// VERIFICAÇÃO FORMALIDADES FATURADO
function checkFormalidadesFATURADO($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_faturado="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FFAT-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$default	= $sql->fetch($sql->query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$id.'"'));
			if($default->formalidades_enviado == '1') {
				$query = $sql->query('UPDATE processos_tarefas SET estado="80" WHERE id_processo = "'.$id.'"');
			}
		$rtn[] = clickFormalidades($id,'FATURADO');
		$rtn[] = '<div id="formalidadesFATURADO-'.$id.'" name="1" class="sucess-check" style="display:inline-block;"></div>';
		$rtn[] = '<div id="formalidadesFaturadoEdit-'.$id.'" class="editafatura" processo="'.$id.'" name="formalidadesFATURA" style="padding-left:5px;padding-top:3px;vertical-align:top;display:inline-block;"></div>';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_faturado="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FFAT-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = clickFormalidades($id,'FATURADO');
		$rtn[] = '<div id="formalidadesFATURADO-'.$id.'" name="0" class="error-check" style="display:inline-block;"></div>';
		$rtn[] = '<div id="formalidadesFaturadoEdit-'.$id.'" class="editafatura" processo="'.$id.'" name="formalidadesFATURA" style="padding-left:5px;padding-top:3px;vertical-align:top;display:inline-block;"></div>';
	}

	return implode('',$rtn);
}
// VERIFICAÇÃO FORMALIDADES ENVIADO
function checkFormalidadesENVIADO($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_enviado="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FENV-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
			$default	= $sql->fetch($sql->query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$id.'"'));
			if($default->formalidades_faturado_pdf != '') {
				$query = $sql->query('UPDATE processos_tarefas SET estado="80" WHERE id_processo = "'.$id.'"');
			}
		$rtn[] = clickFormalidades($id,'ENVIADO');
		$rtn[] = '<div id="formalidadesENVIADO-'.$id.'" name="1" class="sucess-check"></div>';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_enviado="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FENV-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = clickFormalidades($id,'ENVIADO');
		$rtn[] = '<div id="formalidadesENVIADO-'.$id.'" name="0" class="error-check"></div>';
	}

	return implode('',$rtn);
}
/***************************************************/
/******************* FORMULÁRIOS *******************/
/***************************************************/
// CHECKBOX
function checkbox($id,$name,$value,$checked,$class,$placeholder){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	//$rtn	.= '<input type="checkbox" name="'.$name.'" value="'.$value.'" placeholder="'.$placeholder.'" />';
	$rtn	.= '<input id="'.$id.'" name="'.$name.'" class="css-checkbox '.$class.'" type="checkbox" value="'.$value.'" '.$checked.' />';
	$rtn	.= '<label for="'.$id.'" class="css-label '.$id.'">'.$placeholder.'</label>';
	return $rtn;
}
// INPUT TEXT
function text_input($name,$value,$placeholder,$class){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<input type="text" name="'.$name.'" value="'.$value.'" class="'.$class.'" '.$placeholder.' />';
	return $rtn;
}
// INPUT EMAIL
function email_input($name,$value,$placeholder,$class){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<input type="email" name="'.$name.'" value="'.$value.'" placeholder="'.$placeholder.'" class="'.$class.'" />';
	return $rtn;
}
// INPUT PASSWORD
function password_input($name,$value,$placeholder,$class){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<input type="password" name="'.$name.'" value="'.$value.'" placeholder="'.$placeholder.'" class="'.$class.'" />';
	return $rtn;
}
// RADIO
function radio($name,$value,$placeholder){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<input type="radio" name="'.$name.'" value="'.$value.'" />';
	return $rtn;
}
// TEXTEAREA
function textarea($name,$value,$placeholder){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<textarea name="'.$name.'" placeholder="'.$placeholder.'">'.$value.'</textarea>';
	return $rtn;
}
// INPUT SUBMIT
function submit($name,$value,$placeholder,$class){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<input type="submit" name="'.$name.'" value="'.$value.'" class="'.$class.'" />';
	return $rtn;
}
/***************************************************/
/***************************************************/
/***************************************************/
function array_map_deep($fn, $arr) {
    $rarr = array();
    foreach ($arr as $k => $v) {
        $rarr[$k] = is_array($v)
            ? array_map_deep($fn, $v)
            : $fn($v); // or call_user_func($fn, $v)
    }
    return $rarr;
}

function convert_encoding($val) {
	return mb_convert_encoding($val, 'ISO-8859-1', 'auto');
}
/***************************************************/
/********************** BUTÕES *********************/
/***************************************************/
// BUTÃO VER
function view_button($url,$options){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<a href="'.$url.'" '.$options.' title="Ver"><img src="'.$base.'img/site/lupa.png" /></a>';
	return $rtn;
}
// EDITAR
function edit_button($url,$options){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<a href="'.$url.'" '.$options.' title="Editar"><img src="'.$base.'img/site/edit.png" /></a>';
	return $rtn;
}
// ELIMINAR
function delete_button($url,$options){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	if($options == 'class="delFuncionario"') {
		$rtn	.= '<span id="delete" '.$options.'  title="Inactivar" '.$url.'><img src="'.$base.'img/site/delete.png" /></span>';
	}
	elseif($options == 'class="actFuncionario"') {
		$rtn	.= '<span id="delete" '.$options.'  title="Activar" '.$url.'><img src="'.$base.'img/site/check.png" /></span>';
	}
	else {
		$rtn	.= '<span id="delete" '.$options.'  title="Apagar" '.$url.'><img src="'.$base.'img/site/delete.png" /></span>';
	}

	return $rtn;
}

// CANCELAR
function cancel_button($url,$options){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<span id="cancelar" title="Cancelar" '.$options.' '.$url.'><img src="'.$base.'img/site/cancel.png" /></span>';
	return $rtn;
}
// CANCELAR PENDENTES
function cancel_button_pen($url,$options){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<span id="cancelar" title="Cancelar" '.$options.' '.$url.'><img src="'.$base.'img/site/cancel.png" /></span>';
	return $rtn;
}
// RETIRAR ESTADO CANCELADO
function recancel_button($url,$options){
	global $login;
	global $generic;
	global $langvars;
	global $base;

	$rtn	.= '<span id="recancelar" title="Cancelar" '.$options.' '.$url.'><img src="'.$base.'img/site/de-cancel.png" /></span>';
	return $rtn;
}
/***************************************************/
/*********************** AÇÕES *********************/
/***************************************************/
// APAGAR TIPO FICHEIRO
function delFiletype($id){
	global $sql;

	$sql->query('DELETE FROM filetypes WHERE id = "'.$id.'" ');

	return json_encode($total);
}

// APAGAR CARRINHA
function delVan($id){
	global $sql;

	$sql->query('DELETE FROM carrinhas WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR USER
function delUser($id){
	global $sql;

	$sql->query('DELETE FROM dc_admin WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR CLIENTE
function delClient($id){
	global $sql;

	$sql->query('DELETE FROM clientes WHERE id = "'.$id.'"');

	return json_encode($total);
}


// APAGAR NOTICIA
function delNoticias($id){
	global $sql;

	$sql->query('DELETE FROM noticias WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR TAREFA
function delTask($id){
	global $sql;

	$sql->query('DELETE FROM tarefas WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR PROCESSO TIPO
function delProcessoTipo($IDGDProcessoTipo){
	global $sql;

	$sql->query('DELETE FROM GDProcessoTipo WHERE IDGDProcessoTipo = "'.$IDGDProcessoTipo.'"');

	return 'DELETE FROM GDProcessoTipo WHERE IDGDProcessoTipo = "'.$IDGDProcessoTipo.'"';
}
// APAGAR TIPO IMOVEL
function delImovelTipo($id){
	global $sql;

	$sql->query('DELETE FROM GDImovelTipo WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR DEPARTAMENTO
function delDepartamento($idGDDepartamento){
	global $sql;

	$sql->query('DELETE FROM GDDepartamento WHERE idGDDepartamento = '.$idGDDepartamento.' ');

	return json_encode($total);
}
// APAGAR DELEGACAO
function delDelegacao($codDelegacao){
	global $sql;
	$sql->query('DELETE FROM delegacoes WHERE codDelegacao = "'.$codDelegacao.'"');

	return json_encode($total);
}
// APAGAR PAIS
function delCountry($codPais){
	global $sql;

	$sql->query('DELETE FROM paises WHERE codPais = "'.$codPais.'"');

	return json_encode($total);
}
// APAGAR BANCO
function delbanco($codBanco){
	global $sql;

	$sql->query('DELETE FROM nrUser WHERE IdUser = "'.$codBanco.'"');

	return json_encode($total);
}
// APAGAR FUNCIONARIOS
function delFuncionario($codFuncionario){
	global $sql;

	$sql->query('UPDATE `nrUser` SET `Activo`=0 WHERE IdUser = "'.$codFuncionario.'"');

	return json_encode($total);
}
// ACTIVAR FUNCIONARIOS
function actFuncionario($codFuncionario){
	global $sql;

	$sql->query('UPDATE `nrUser` SET `Activo`=1 WHERE IdUser = "'.$codFuncionario.'"');

	return json_encode($total);
}
// APAGAR TIPO DE EQUIPAMENTO
function delTypeEquipment($id){
	global $sql;

	$sql->query('DELETE FROM equipamentos_tipo WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR EQUIPAMENTO
function delEquipment($id){
	global $sql;

	$sql->query('DELETE FROM equipamentos WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR PROCESSO
function delProcess($id){
	global $sql;
	global $admin;

	$sql->query('DELETE FROM processos WHERE id = "'.$id.'"');
	$sql->query('DELETE FROM codigos WHERE id_processo = "'.$id.'"');
	$sql->query('DELETE FROM processos_tarefas WHERE id_processo = "'.$id.'"');

	/* registo de histório da eliminação */
	$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("deleteprocess","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');


	return json_encode($total);
}
// CANCELAR PROCESSO
function cancelProcess($id){
	global $sql;
	global $admin;

	$sql->query('UPDATE processos SET interno_estado="100" WHERE id = "'.$id.'"');

	/* registo de histório do cancelamento */
	$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("cancelprocesso","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');

	return json_encode($total);
}
// CANCELAR PROCESSO
function cancelProcess_pen($id){
	global $sql;
	global $admin;

	$sql->query('UPDATE processos SET interno_estado="31" WHERE id = "'.$id.'"');

	/* registo de histório do cancelamento */
	$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("cancelprocesso","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');

	return json_encode($total);
}
// RETIRAR ESTADO CANCELADO DO PROCESSO
function recancelProcess($id){
	global $sql;
	global $admin;

	$processo	= $sql->fetch($sql->query('SELECT * FROM processos WHERE id = "'.$id.'"'));
	$ficheiros	= $sql->fetch($sql->query('SELECT COUNT(*) AS numberFiles FROM files WHERE `group` = "1" AND `id_processo` = "'.$id.'" AND status="1"'));

	if($processo->orcamento_aprovado == '1') {
		$sql->query('UPDATE processos SET interno_estado="40" WHERE id = "'.$id.'"');
		/* registo de histório */
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("recancelprocesso40","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
	} else {

		if(!empty($processo->orcamento_pdf) || $ficheiros->numberFiles > 0) {
			$sql->query('UPDATE processos SET interno_estado="30" WHERE id = "'.$id.'"');
			/* registo de histório */
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("recancelprocesso30","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		} else {
			$sql->query('UPDATE processos SET interno_estado="20" WHERE id = "'.$id.'"');
			/* registo de histório */
			$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("recancelprocesso20","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		}

	}

	return json_encode($total);
}
// APAGAR AGENDAMENTO (calendario)
function delAgendamento($id){
	global $sql;

	$sql->query('UPDATE processos SET `agendamento_id`="0",`agendamento_confirmado`=NULL,`agendamento_hora`=NULL,`agendamento_apontamentos`=NULL, `interno_estado`=40 WHERE id = "'.$id.'"');

	return json_encode($total);
}
// APAGAR AGENDAMENTO TOTAL
function delAgen($id){
	global $sql;

	$sql->query('UPDATE processos SET `interno_estado`="40",`agendamento_id`="0",`agendamento_confirmado`=NULL,`agendamento_hora`=NULL,`agendamento_apontamentos`=NULL WHERE agendamento_id = "'.$id.'"');
	$sql->query('DELETE FROM agendamentos WHERE id = "'.$id.'"');

	return json_encode($total);
}
// ANULAR OT
function delOT($id){
	global $sql;

	$sql->query('UPDATE agendamentos SET completo="0" WHERE id = "'.$id.'"');
	$sql->query('UPDATE processos SET interno_estado="50" WHERE agendamento_id = "'.$id.'"');

	return json_encode($total);
}
// COPIAR DADOS DO CLIENTE
function copyInfoClient($id){
	global $sql;

	$sql->query('SET CHARACTER SET utf8');
	$default	= $sql->fetch($sql->query('SELECT * FROM clientes WHERE id = "'.$id.'"'));
	$total = array('morada' => $default->morada, 'cp' => $default->cp, 'telefone' => $default->telefone, 'localidade' => $default->localidade, 'freguesia' => $default->freguesia, 'concelho' => $default->concelho, 'distrito' => $default->distrito, 'pais' => $default->pais, 'gps' => $default->gps, 'nome' => $default->nome);

	return json_encode($total);
}
// COPIAR DADOS DA QTEC
function copyInfoQTEC($id){
	global $sql;

	$sql->query('SET CHARACTER SET utf8');
	$default	= $sql->fetch($sql->query('SELECT * FROM dc_public WHERE id = "1"'));
	$total = array('morada' => $default->qtec_morada, 'cp' => $default->qtec_cp, 'telefone' => $default->qtec_telefone, 'localidade' => $default->qtec_localidade, 'freguesia' => $default->qtec_freguesia, 'concelho' => $default->qtec_concelho, 'distrito' => $default->qtec_distrito, 'pais' => $default->qtec_pais, 'gps' => $default->qtec_gps);

	return json_encode($total);
}
// CAMPOS EXTRA DEPENDENDO DO TIPO DE EQUIPAMENTO (NOVO PROCESSO - IN)
function getOptionsTypeEquipmentInProcess($id,$equipamento){
	global $sql;
	global $lang;
	global $langvars;

	$dbdata		= $sql->fetch($sql->query('SELECT * FROM equipamentos WHERE id = "'.$equipamento.'"'));

	$res	= $sql->query('SELECT * FROM equipamentos_tipo WHERE id = "'.$id.'"');
	while($subcat = $sql->fetch($res)) {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_mtbf'].'</span>'.text_input('form[revisao]',$subcat->revisao,'','').'</p>';
		if($subcat->option_n_fabrico == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_nfabric'].'</span>'.text_input('form[nr_fabrico]',$dbdata ? $dbdata->nr_fabrico : $_REQUEST['form']['nr_fabrico'],'','').'</p>';
		}
		if($subcat->option_fabricante == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_fabric'].'</span>'.text_input('form[fabricante]',$dbdata ? $dbdata->fabricante : $_REQUEST['form']['fabricante'],'','').'</p>';
		}
		if($subcat->option_registo == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_nregist'].'</span>'.text_input('form[nr_registo]',$dbdata ? $dbdata->nr_registo : $_REQUEST['form']['nr_registo'],'','').'</p>';
		}
		if($subcat->option_volume == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_volume'].'</span>'.text_input('form[volume]',$dbdata ? $dbdata->volume : $_REQUEST['form']['volume'],'','').'</p>';
		}
		if($subcat->option_timbre == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_timbre'].'</span>'.text_input('form[timbre]',$dbdata ? $dbdata->timbre : $_REQUEST['form']['timbre'],'','').'</p>';
		}
		if($subcat->option_ano == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_year'].'</span>'.text_input('form[ano]',$dbdata ? $dbdata->ano : $_REQUEST['form']['ano'],'','').'</p>';
		}
		if(!empty($subcat->extra_1)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_1.'</span>'.text_input('form[extra_1]',$dbdata ? $dbdata->extra_1 : $_REQUEST['form']['extra_1'], '', '').'</p>';
		}
		if(!empty($subcat->extra_2)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_2.'</span>'.text_input('form[extra_2]',$dbdata ? $dbdata->extra_2 : $_REQUEST['form']['extra_2'], '', '').'</p>';
		}
		if(!empty($subcat->extra_3)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_3.'</span>'.text_input('form[extra_3]',$dbdata ? $dbdata->extra_3 : $_REQUEST['form']['extra_3'], '', '').'</p>';
		}
		if(!empty($subcat->extra_4)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_4.'</span>'.text_input('form[extra_4]',$dbdata ? $dbdata->extra_4 : $_REQUEST['form']['extra_4'], '', '').'</p>';
		}
		if(!empty($subcat->extra_5)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_5.'</span>'.text_input('form[extra_5]',$dbdata ? $dbdata->extra_5 : $_REQUEST['form']['extra_5'], '', '').'</p>';
		}

	}

	return implode('',$rtn);
}
// LISTAGEM EQUIPAMENTOS (NOVO PROCESSO)
function getEquipmentAddProcess($id,$sub=''){
	global $sql;
	global $lang;

	$rtn[] = '<option></option>';

	$res	= $sql->query('SELECT * FROM equipamentos WHERE cliente_id = "'.$id.'"');
	while($subcat = $sql->fetch($res))
		$rtn[] = '<option class="margin-left" value="'.$subcat->id.'" '.($subcat->id == $sub ? 'selected="selected"' : '').'>'.$subcat->cliente_ref.($subcat->cliente_ref != '' ? ' | ' : '').$subcat->local_nome.($subcat->nr_fabrico != '' ? ' | ' : '').$subcat->nr_fabrico.'</option>';

	return implode('',$rtn);
}
// CAMPOS EXTRA DEPENDENDO DO TIPO DE EQUIPAMENTO (NOVO PROCESSO - IN)
function getOptionsTypeEquipment($id){
	global $sql;
	global $lang;
	global $langvars;

	//$rtn[] = '<p><span class="input-text">'.$langvars['form_nregist'].'</span><div id="nEquipReg"><input id="quantidadeEquip" name="addEquipReg[]" style="margin-bottom: 5px;" type="text" value="" /></div></p>';

	$res	= $sql->query('SELECT * FROM equipamentos_tipo WHERE id = "'.$id.'"');
	while($subcat = $sql->fetch($res)) {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_mtbf'].'</span>'.text_input('addEquip[revisao]',$subcat->revisao,'','').'</p>';
		if($subcat->option_n_fabrico == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_nfabric'].'</span>'.text_input('addEquip[nr_fabrico]','','','').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[nr_fabrico]" value="" />';
		}
		if($subcat->option_fabricante == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_fabric'].'</span>'.text_input('addEquip[fabricante]','','','').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[fabricante]" value="" />';
		}
		if($subcat->option_registo == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_nregist'].'</span>'.text_input('addEquip[nr_registo]','','','').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[nr_registo]" value="" />';
		}
		if($subcat->option_volume == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_volume'].'</span>'.text_input('addEquip[volume]','','','').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[volume]" value="" />';
		}
		if($subcat->option_timbre == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_timbre'].'</span>'.text_input('addEquip[timbre]','','','').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[timbre]" value="" />';
		}
		if($subcat->option_ano == '1') {
			$rtn[] = '<p><span class="input-text">'.$langvars['form_year'].'</span>'.text_input('addEquip[ano]','','','').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[ano]" value="" />';
		}
		if(!empty($subcat->extra_1)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_1.'</span>'.text_input('addEquip[extra_1]','', '', '').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[extra_1]" value="" />';
		}
		if(!empty($subcat->extra_2)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_2.'</span>'.text_input('addEquip[extra_2]','', '', '').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[extra_2]" value="" />';
		}
		if(!empty($subcat->extra_3)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_3.'</span>'.text_input('addEquip[extra_3]','', '', '').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[extra_3]" value="" />';
		}
		if(!empty($subcat->extra_4)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_4.'</span>'.text_input('addEquip[extra_4]','', '', '').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[extra_4]" value="" />';
		}
		if(!empty($subcat->extra_5)) {
			$rtn[] = '<p><span class="input-text">'.$subcat->extra_5.'</span>'.text_input('addEquip[extra_5]','', '', '').'</p>';
		} else {
			$rtn[] = '<input type="hidden" name="addEquip[extra_5]" value="" />';
		}
	}

	return implode('',$rtn);
}
// NOVOS EQUIPAMENTOS (IN PROCESSO)
function addNewEquipmentProcess($tipo_id,$cliente_id,$cliente_ref,$revisao,$nr_fabrico,$fabricante,$nr_registo,$volume,$timbre,$ano,$extra_1,$extra_2,$extra_3,$extra_4,$extra_5,$observacoes,$local_nome,$local_telefone,$local_obs,$local_gps,$local_morada,$local_cp,$local_localidade,$local_freguesia,$local_concelho,$local_distrito,$local_pais){
	global $sql;
	global $lang;
	global $langvars;
	global $act;

	if (is_array($cliente_ref)) {
		foreach ($cliente_ref as $ref) {

			$sql->query('SET CHARACTER SET utf8');
			$sql->query('INSERT INTO `equipamentos`  (`tipo_id`,`cliente_id`,`revisao`,`cliente_ref`,`nr_fabrico`,`fabricante`,`nr_registo`,`volume`,`timbre`,`ano`,`extra_1`,`extra_2`,`extra_3`,`extra_4`,`extra_5`,`observacoes`,`local_nome`,`local_telefone`,`local_obs`,`local_gps`,`local_morada`,`local_cp`,`local_localidade`,`local_freguesia`,`local_concelho`,`local_distrito`,`local_pais`) VALUES ("'.$tipo_id.'","'.$cliente_id.'","'.$revisao.'","'.$ref['value'].'","'.$nr_fabrico.'","'.$fabricante.'","'.$nr_registo.'","'.$volume.'","'.$timbre.'","'.$ano.'","'.$extra_1.'","'.$extra_2.'","'.$extra_3.'","'.$extra_4.'","'.$extra_5.'","'.$observacoes.'","'.$local_nome.'","'.$local_telefone.'","'.$local_obs.'","'.cleanstr(str_replace("'","\'",$local_gps)).'","'.$local_morada.'","'.$local_cp.'","'.$local_localidade.'","'.$local_freguesia.'","'.$local_concelho.'","'.$local_distrito.'","'.$local_pais.'")');

			$default	= $sql->fetch($sql->query('SELECT * FROM equipamentos ORDER BY `id` DESC LIMIT 1'));

			$valor = determinaCoordenadas($default->id);
			$query = $sql->query('UPDATE equipamentos SET local_google = "'.$valor.'" WHERE id = "'.$default->id.'"');

			$res	= $sql->query('SELECT * FROM equipamentos WHERE id="'.$default->id.'"');
			while($subcat = $sql->fetch($res)) {
				$rtn[] = '<option class="margin-left" value="'.$subcat->id.'" selected="selected">'.$subcat->cliente_ref.($subcat->cliente_ref != '' ? ' | ' : '').$subcat->local_nome.($subcat->nr_fabrico != '' ? ' | ' : '').$subcat->nr_fabrico.'</option>';

			}
		}
	}

	return implode('',$rtn);
}
// CHECK APROVADO (IN LISTAGEM PENDENTES)
function checkPending($id){
	global $sql;
	global $langmail;
	global $assinatura;
	global $admin;

	$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("OA","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');

	//ENVIO DE MAIL P/ RESPONSAVEL

	//QUERY DESTINO
	$tecnico = mysql_fetch_array(mysql_query('SELECT * FROM processos WHERE id = "'.$id.'" '));
	$cliente = mysql_fetch_array(mysql_query('SELECT * FROM clientes WHERE id = "'.$tecnico['cliente_id'].'" '));

	$to      = array('pmpimenta@qtec.pt','hlgouveia@qtec.pt');
	$subject = 'ORÇAMENTO APROVADO ';
	$editado = str_replace('#PROCESSO',$tecnico['interno_processo'],$langmail['email_adjudicado']);
	$editado = str_replace('#CLIENTE',utf8_encode($cliente['nome']),$editado);
	$message = $editado.$assinatura;


	echo sendEmail($to, $subject, $message);

	$sql->query('UPDATE processos SET interno_estado="40", orcamento_aprovado="1" WHERE id = "'.$id.'"');

	return json_encode('1');
}
// CHECK APROVADO (IN LISTAGEM PENDENTES)
function checkPending_rev($id){
	global $sql;
	global $langmail;
	global $assinatura;
	global $admin;

	$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("OA","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');

	//ENVIO DE MAIL P/ RESPONSAVEL

	//QUERY DESTINO
	$tecnico = mysql_fetch_array(mysql_query('SELECT * FROM processos WHERE id = "'.$id.'" '));
	$cliente = mysql_fetch_array(mysql_query('SELECT * FROM clientes WHERE id = "'.$tecnico['cliente_id'].'" '));

	$to      = array('pmpimenta@qtec.pt','hlgouveia@qtec.pt');
	$subject = 'ORÇAMENTO APROVADO ';
	$editado = str_replace('#PROCESSO',$tecnico['interno_processo'],$langmail['email_adjudicado']);
	$editado = str_replace('#CLIENTE',utf8_encode($cliente['nome']),$editado);
	$message = $editado.$assinatura;


	echo sendEmail($to, $subject, $message);

	$sql->query('UPDATE processos SET interno_estado="30", orcamento_aprovado="1" WHERE id = "'.$id.'"');

	return json_encode('1');
}

// CHECK PASSAR PARA OT (AGENDAMENTOS)
function checkPendingOT($id){
	global $sql;
	global $langmail;
	global $assinatura;

	$sql->query('UPDATE agendamentos SET completo="1" WHERE id = "'.$id.'"');
	$sql->query('UPDATE processos SET interno_estado="60" WHERE agendamento_id = "'.$id.'"');



//ENVIO DE MAIL P/ TECNICOS

	//QUERY DESTINO
	$tecnico = mysql_fetch_array(mysql_query('SELECT * FROM agendamentos WHERE id = "'.$id.'" '));
	//QUERY EMAILS
	$email1 = mysql_fetch_array(mysql_query('SELECT * FROM dc_admin WHERE id = "'.$tecnico['tecnico1'].'" '));
	$email2 = mysql_fetch_array(mysql_query('SELECT * FROM dc_admin WHERE id = "'.$tecnico['tecnico2'].'" '));
	$email3= mysql_fetch_array(mysql_query('SELECT * FROM dc_admin WHERE id = "'.$tecnico['tecnico3'].'" '));
	$email4 = mysql_fetch_array(mysql_query('SELECT * FROM dc_admin WHERE id = "'.$tecnico['tecnico4'].'" '));
	if ( $email1['email'] ) { $emailgeral .= $email1['email']; }
	if ( $email2['email'] ) { $emailgeral .= ','.$email2['email']; }
	if ( $email3['email'] ) { $emailgeral .= ','.$email3['email']; }
	if ( $email4['email'] ) { $emailgeral .= ','.$email4['email']; }


	$to      = array($emailgeral);
	$subject = 'NOVO AGENDAMENTO';
	$editado = str_replace('#OT',$id,$langmail['email_ot']);
	$editado = str_replace('#DIA',$tecnico['data'],$editado);

	$query = $sql->query('SELECT `t1`.`interno_processo`, `t2`.`nome`  FROM `processos` AS t1 INNER JOIN `clientes` AS t2 ON `t1`.`cliente_id`=`t2`.`id` WHERE agendamento_id ='.$id.'  ');
		while ($row2 = mysql_fetch_assoc($query)) {
			$editado .=' <br>PROCESSO: <strong>'.$row2['interno_processo'].' - '.$row2['nome'].'</strong> ';
		}

	$message .= $editado.'<br>'.$tecnico['extra'].$assinatura;
	echo sendEmail($to, $subject, $message);

	return json_encode($total);
}
// CALENDÁRIO
function calendario($datainicio,$datafim,$carrinha,$prints){
	global $sql;
	global $lang;
	global $langvars;
	global $act;

	//$data = '2013-05-30';
	$data = date('Y-m-d');

	if(date('D', time()) === 'Mon') {
		$dataSegunda = date('Y-m-d');
		//$dataSegunda = date('Y-m-d', strtotime($data. ' last Monday'));
	} else {
		$dataSegunda = date('Y-m-d', strtotime($data. ' last Monday'));
	}
	$dataDomingo = date('Y-m-d', strtotime($dataSegunda. ' + 7 Days'));


	if($carrinha != '') { $teamID = 'AND `equipa`="'.$carrinha.'"'; $teamID2 = 'AND `agendamentos`.`equipa`="'.$carrinha.'"'; } else { $teamID = ''; $teamID2 = ''; }
	if($datainicio != '') { $data1 = $datainicio; } else { $data1 = $dataSegunda; }
	//if($datafim != '') { $data2 = date('Y-m-d', strtotime($datafim. ' + 0 Days')); } else { $data2 = $dataDomingo; }
	if($datafim != '') { $data2 = date('Y-m-d', strtotime($datafim. ' + 1 Days')); } else { $data2 = $dataDomingo; }

	$begin = new DateTime( ''.$data1.'' );
	$end = new DateTime(''.$data2.'' );

	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);

	foreach ($period as $dt) {
		$rtn[] = '<h2>';
			$rtn[] = $dt->format("Y-m-d").' <span style="vertical-align: middle; color: #AAA;">('.diasemana($dt->format("Y-m-d")).')</span>';
			if ( $prints != 'a' ) {
			//$rtn[] = '<span class="clickadd-'.$dt->format("Y-m-d").' btn-adicionar" id="'.$dt->format("Y-m-d").'" onclick="dp.calendario.agendamentoNew(this);" style="">ADICIONAR</span>';
			}
		$rtn[] = '</h2>';
		$rtn[] = '<div class="line-subtitle"></div>';
		$rtn[] = '<div class="popUpBack" id="popUpBack-'.$dt->format("Y-m-d").'" style="display:none"></div>';
			$rtn[] = '<div id="viewFormAgenda-'.$dt->format("Y-m-d").'" style="display:none" class="formularioPopUp">';
			$rtn[] = '<form id="addAgendamentoForm" method="POST" action>';
				$rtn[] = '<span class="clickback-'.$dt->format("Y-m-d").'" id="'.$dt->format("Y-m-d").'" onclick="dp.calendario.agendamentoClose(this);" style="position: absolute; right: 20px;cursor:pointer;">';
					$rtn[] = '<img src="'.$base.'img/site/pop_sprite.png" />';
				$rtn[] = '</span>';
				$rtn[] = '<h0>'.$langvars['title_calendar'].'</h0>';
				$rtn[] = '<div class="line-title" style="margin-bottom:20px;"></div>';
				/*
				$rtn[] = '<table>';
					$rtn[] = '<tr>';
						$rtn[] = '<td>';
							$rtn[] = '<h2>DADOS DO AGENDAMENTO</h2>';
							$rtn[] = '<div class="line-subtitle" style="margin-bottom:20px;"></div>';
							$rtn[] = '<p><span class="input-text">'.$langvars['form_date'].'</span>'.text_input('calendar[data]',$dt->format("Y-m-d"),'','datepicker').'</p>';
							$rtn[] = '<p><span class="input-text">'.$langvars['form_obs'].'</span>'.textarea('calendar[observacoes]','', '').'</p>';
							$rtn[] = '<p>';
								$rtn[] = '<span class="input-text" style="padding-right:2px;">'.$langvars['form_van'].'</span>';
								$rtn[] = '<select name="calendar[equipa]" class="select-pesq chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2">';
									$rtn[] = '<option></option>';
								$res = $sql->query('SELECT * FROM carrinhas ORDER BY `descricao` ASC');
								while($car = $sql->fetch($res))
									$rtn[] = '<option value="'.$car->id.'">'.$car->descricao.'</option>';
							$rtn[] = '</select>';
							$rtn[] = '</p>';
							$rtn[] = '<p>';
								$rtn[] = '<span class="input-text" style="padding-right:2px;">'.$langvars['form_tecnic'].'s</span>';
								$rtn[] = '<select  multiple="multiple" name="calendarTec[]" class="select-tecnicAgenda chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2">';
									$rtn[] = '<option></option>';
								//$res = $sql->query('SELECT * FROM dc_admin WHERE idadmingroup="9" ORDER BY `firstname` ASC');
								$res = $sql->query('SELECT `ad`.`id`, `ad`.`firstname` FROM dc_admin ad INNER JOIN dc_permissoes_admin perm ON `ad`.`idadmingroup`=`perm`.`id` WHERE `perm`.`agendamentos` = "1" AND `ad`.`status`="1" ORDER BY `ad`.`firstname` ASC');
								while($car = $sql->fetch($res))
									$rtn[] = '<option value="'.$car->id.'">'.$car->firstname.'</option>';
								$rtn[] = '</select>';
							$rtn[] = '</p>';

						$rtn[] = '</td>';
						$rtn[] = '<th class="border"></th>';
						$rtn[] = '<td>';
							$rtn[] = '<h2>PROCESSOS</h2>';
							$rtn[] = '<div class="line-subtitle" style="margin-bottom:20px;"></div>';
							$rtn[] = '<p>';
								$rtn[] = '<span class="input-text" style="padding-right:2px;">'.$langvars['form_incode'].'</span>';
								$rtn[] = '<select name="idprocessoAgenda" id="select-processo-'.$dt->format("Y-m-d").'" class="select-pesq chosen-select processoAgenda-'.$dt->format("Y-m-d").'" data-placeholder="'.$langvars['global_select'].'" tabindex="2">';
									$rtn[] = '<option></option>';
								$res = $sql->query('SELECT id, cliente_id, equipamento_id, interno_processo FROM processos WHERE interno_estado IN("20","30","31","40","41") AND agendamento_id = 0 ORDER BY `id` DESC');
								while($process = $sql->fetch($res)) {
									$cliente 		= $sql->fetch($sql->query('SELECT nome FROM clientes WHERE id = "'.$process->cliente_id.'"'));
									$equipamento 	= $sql->fetch($sql->query('SELECT cliente_ref FROM equipamentos WHERE id = "'.$process->equipamento_id.'"'));
									$rtn[] = '<option value="'.$process->id.'">'.$process->interno_processo.' | '.$cliente->nome.' '.($equipamento->cliente_ref != '' ? '|' : '').' '.$equipamento->cliente_ref.'</option>';
								}
								$rtn[] = '</select>';
							$rtn[] = '</p>';
							$rtn[] = '<p>';
								$rtn[] = '<span class="input-text" style="padding-right:2px;">'.$langvars['form_hour'].'</span></br>';
								$rtn[] = '<select class="select-task" id="select-hora-'.$dt->format("Y-m-d").'" style="margin: 0 0 0 0px;" name="horaH">';
									$rtn[] = '<option value="00">00</option>';
									$rtn[] = '<option value="01">01</option>';
									$rtn[] = '<option value="02">02</option>';
									$rtn[] = '<option value="03">03</option>';
									$rtn[] = '<option value="04">04</option>';
									$rtn[] = '<option value="05">05</option>';
									$rtn[] = '<option value="06">06</option>';
									$rtn[] = '<option value="07">07</option>';
									$rtn[] = '<option value="08" selected>08</option>';
									$rtn[] = '<option value="09">09</option>';
									for ($i=10;$i<=23;$i++) {
										$rtn[] = '<option value="'.$i.'">'.$i.'</option>';
									}
								$rtn[] = '</select>';
								$rtn[] = '<span style="vertical-align: sub; padding-right: 4px;">:</span>';
								$rtn[] = '<select class="select-task" id="select-minutos-'.$dt->format("Y-m-d").'" name="horaM">';
									$rtn[] = '<option value="00">00</option>';
									$rtn[] = '<option value="15">15</option>';
									$rtn[] = '<option value="30">30</option>';
									$rtn[] = '<option value="45">45</option>';
								$rtn[] = '</select>';
							$rtn[] = '</p>';
							$rtn[] = '<p>';
								$rtn[] = '<span class="listAgendarAdd" id="'.$dt->format("Y-m-d").'" onclick="dp.calendario.agendamentoAgendar(\''.$dt->format("Y-m-d").'\');" style="position:absolute;right:35px;font-weight:400;font-size:12px;vertical-align:bottom;padding:5px 10px;background-color:#E6E6E6;border: 1px solid #CCCCCC;cursor:pointer;">AGENDAR</span>';
							$rtn[] = '</p>';
							$rtn[] = '</br>';
							$rtn[] = '<p class="listProcessAgendar-'.$dt->format("Y-m-d").'" style="margin-top:30px;"></p>';
						$rtn[] = '</td>';
					$rtn[] = '</tr>';
				$rtn[] = '</table>';
				$rtn[] = '<div class="col-left-save">';
					$rtn[] = '<input type="hidden" name="action" value="insertAgenda" />';
					$rtn[] = '<input type="hidden" name="calendar[finalizado]" value="0" />';
					$rtn[] = '<input type="hidden" name="calendar[completo]" value="1" />';
					$rtn[] = '<input type="submit" class="butao-save" value="Guardar" onclick="dp.calendario.verificaCampos(\''.$dt->format("Y-m-d").'\');" />';
				$rtn[] = '</div>';
			$rtn[] = '</form>';
		*/
		$rtn[] = '</div>';

		$query = $sql->query('SELECT * FROM `agendamentos` WHERE `data` = "'.$dt->format("Y-m-d").'" '.$teamID.'  GROUP BY `data` ORDER BY `data` ASC');

		//echo 'SELECT * FROM `agendamentos` WHERE `data` = "'.$dt->format("Y-m-d").'" '.$teamID.'  GROUP BY `data` ORDER BY `data` ASC<br><br>';

		if(mysql_num_rows($query) > 0) {
			while($row = $sql->fetch($query)) {
			//echo $row->id.' ';
				$rtn[] = '<script type="text/javascript" charset="utf-8">dp.calendario.calendarioView("'.$row->id.'");</script>';
				$rtn[] = '<table class="wrapper-calendar" id="example-'.$row->id.''.$prints.'" cellpadding="0" cellspacing="0" border="0" class="display">';
					$rtn[] = '<thead>';
						$rtn[] = '<tr>';
							$rtn[] = '<th width="200px" >'.$langvars['calendar_cliente'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_cliente_ref'].'</th>';
							$rtn[] = '<th width="50px" style="text-align:center;">'.$langvars['calendar_hora'].'</th>';
							if ( $prints != 'a' ) {
							$rtn[] = '<th width="50px" style="text-align:center;">'.$langvars['calendar_data'].'</th>';
							}
							$rtn[] = '<th width="100px">'.$langvars['calendar_processo'].'</th>';
							if ( $prints != 'a' ) {
							$rtn[] = '<th width="150px" style="text-align:center;">'.$langvars['form_process_status'].'</th>';
							}
							$rtn[] = '<th width="300px">'.$langvars['calendar_instalador_nome'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_local_nome'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_instalador_contactos'].'</th>';
							if ( $prints != 'a' ) {
							$rtn[] = '<th width="70px">'.$langvars['calendar_cliente_datalimite'].'</th>';
							}

							$rtn[] = '<th width="70px">'.$langvars['calendar_volume'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_concelho'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_localidade'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_tipo'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_carrinha'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_tecnicos'].'(s)</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_trabalho'].'</th>';
							if ( $prints != 'a' ) {
								$rtn[] = '<th width="100px">'.$langvars['calendar_realizado_total'].'</th>';
							}
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_valvulas'].'</th>';
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_azoto'].'</th>';
							if ( $prints != 'a' ) {
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_vpn'].'</th>';
							}
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_tuv'].'</th>';
							if ( $prints != 'a' ) {
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_faturado'].'</th>';
							}
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_fatura'].'</th>';
							if ( $prints != 'a' ) {
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_enviado'].'</th>';
							$rtn[] = '<th width="50px" style="text-align:center;">Agendamento</th>';
							$rtn[] = '<th width="150px" style="text-align:center;">Anexos</th>';
							$rtn[] = '<th width="60px" style="text-align:center;" id="'.$row->id.'">'.$langvars['calendar_accoes'].'</th>';
							}
						$rtn[] = '</tr>';
					$rtn[] = '</thead>';
					$rtn[] = '<tbody>';
						$querysec = $sql->query('SELECT *,
					`clientes`.`nome` AS cliente,
					`equipamentos`.`cliente_ref` AS quinhentos,
					`processos`.`id` AS processoid ,
					`equipamentos`.`id` AS equipamentoid,
					`carrinhas`.`descricao` AS carrinhadesc ,
					`processos_tarefas`.`formalidades_austria` AS austria,
					`processos_tarefas`.`formalidades_vpn` AS vpn,
					`processos_tarefas`.`formalidades_faturado_pdf` AS faturado_pdf,
					`processos_tarefas`.`formalidades_enviado` AS enviado,
					(SELECT firstname FROM `dc_admin` WHERE `id`=`agendamentos`.`tecnico1`) AS tecnico1,
					(SELECT firstname FROM `dc_admin` WHERE `id`=`agendamentos`.`tecnico2`) AS tecnico2,
					(SELECT firstname FROM `dc_admin` WHERE `id`=`agendamentos`.`tecnico3`) AS tecnico3,
					(SELECT firstname FROM `dc_admin` WHERE `id`=`agendamentos`.`tecnico4`) AS tecnico4,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `estado`="10" AND `processos_tarefas`.`id_processo`=`processos`.`id`) AS porfazer,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `id_tarefa`="15" AND `processos_tarefas`.`id_processo`=`processos`.`id`) AS tarefasEA,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `processos_tarefas`.`id_processo`=`processos`.`id`) AS total
					FROM `processos`
					INNER JOIN `agendamentos`  ON `processos`.`agendamento_id`=`agendamentos`.`id`
					INNER JOIN clientes ON `clientes`.`id`=`processos`.`cliente_id`
					INNER JOIN equipamentos ON `equipamentos`.`id`=equipamento_id
					INNER JOIN carrinhas ON `carrinhas`.`id`=equipa
					INNER JOIN processos_tarefas ON `processos_tarefas`.`id_processo`=`processos`.`id`
					LEFT  JOIN ots_pending_list ON `ots_pending_list`.`id`=`agendamentos`.`id`
					WHERE `agendamentos`.`data`="'.$dt->format("Y-m-d").'" '.$teamID2.'  ORDER BY `processos`.`agendamento_hora` ASC');

						while($print = $sql->fetch($querysec)) {
								$revisao = explode('-',$print->interno_processo);
								if ( $revisao[2]!="") { $action = "revision"; } else { $action = ""; }

								$rtn[] = '<tr id="'.$print->id.'" class="'.$action.'">';

									$rtn[] = '<td name="cliente">'.$print->cliente.'</td>';
									$rtn[] = '<td>'.$print->quinhentos.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>';

									//$rtn[] = '<td  id="'.$pDados->id.'" name="hora" style="text-align:center;">'.substr(str_replace(":","h",$print->agendamento_hora),0,5).'</td>';
									$rtn[] = '<td class="editable" id="'.$print->processoid.'" name="agendamento_hora" style="text-align:center;">'.$print->agendamento_hora.'</td>';
									if ( $prints != 'a' ) {
									$rtn[] = '<td class="data" id="'.$print->processoid.'" name="data" style="text-align:center;">'.$print->data.'</td>';
									}
									$rtn[] = '<td>'.$print->interno_processo.'</td>';
									$estado	= $sql->fetch($sql->query('SELECT * FROM processos_estados WHERE id = "'.$print->interno_estado.'"'));
									if ( $prints != 'a' ) {
									$rtn[] = '<td style="text-align:left;">'.$estado->nome.'</td>';
									}
									$rtn[] = '<td class="editable" id="'.$print->processoid.'" name="instalador_nome">'.$print->instalador_nome.'</td>';
									$rtn[] = '<td class="editable" id="'.$print->equipamentoid.'" name="local_nome">'.$print->local_nome.'</td>';
									$rtn[] = '<td class="editable" id="'.$print->processoid.'" name="instalador_contactos">'.$print->instalador_contactos.'</td>';
									if ( $prints != 'a' ) {
									$rtn[] = '<td class="" id="'.$print->processoid.'" name="cliente_datalimite">'.$print->cliente_datalimite.'</td>';
									}

									$rtn[] = '<td  class="editable" id="'.$print->equipamentoid.'" name="volume">'.$print->volume.'</td>';
									$rtn[] = '<td  class="editable" id="'.$print->equipamentoid.'" name="local_concelho">'.$print->local_concelho.'</td>';
									$rtn[] = '<td  class="editable" id="'.$print->equipamentoid.'" name="local_localidade">'.$print->local_localidade.'</td>';
									$rtn[] = '<td  class="editable" id="'.$print->processoid.'" name="equipamento_obs">'.$print->equipamento_obs.'</td>';

									$rtn[] = '<td class="selectvan" id="'.$print->agendamento_id.'" name="equipa">'.$print->carrinhadesc.'</td>';
									$rtn[] = '<td class="tecnics" id="'.$print->agendamento_id.'" name="tecnicos">';
										$rtn[] = $print->tecnico1;
										if(!empty($print->tecnico2)) { $rtn[] = ' | '.$print->tecnico2; }
										if(!empty($print->tecnico3)) { $rtn[] = ' | '.$print->tecnico3; }
										if(!empty($print->tecnico4)) { $rtn[] = ' | '.$print->tecnico4; }
									$rtn[] = '</td>';
									$rtn[] = '<td>';
									$sigla = $sql->query('SELECT tarefas.codigo_interno, tarefas.nome, processos_tarefas.estado FROM processos_tarefas INNER JOIN tarefas ON processos_tarefas.id_tarefa=tarefas.id WHERE id_processo = "'.$print->processoid.'" GROUP BY codigo_interno');
									$count = 0;
									while($sig = $sql->fetch($sigla)) {
										if ($count++ > 0) $rtn[] = ' | ';
										if($sig->codigo_interno == 'EXTRA') {
											if($sig->estado == '20') {
												$rtn[] = '<span style="color:red;font-weight:bold;">'.$sig->nome.'</span>';
											}
											if($sig->estado > '20') {
												$rtn[] = '<span style="color:green;font-weight:bold;">'.$sig->nome.'</span>';
											}
											if($sig->estado == '10') {
												$rtn[] = $sig->nome;
											}
										} else {
											if($sig->estado == '20') {
												$rtn[] = '<span style="color:red;font-weight:bold;">'.$sig->codigo_interno.'</span>';
											}
											if($sig->estado > '20') {
												$rtn[] = '<span style="color:green;font-weight:bold;">'.$sig->codigo_interno.'</span>';
											}
											if($sig->estado == '10') {
												$rtn[] = $sig->codigo_interno;
											}
										}
									}
									$rtn[] = '</td>';
								if ( $prints != 'a' ) {
									$rtn[] = '<td>';
									$total = $print->total;
									$totalpendentes = $print->porfazer;
									$porrealizar = $total-$totalpendentes;
									@$printBar = 100-($totalpendentes*100)/$total;
										$rtn[] = '<div style="border: 1px solid #666666;background:#C0C0C0;height:100%;max-height:25px;">';
											$rtn[] = '<div style="background: green;height: 100%; width:'.$printBar.'%;"></div>';
											$rtn[] = '<div style="color:#FFF;height: 100%; width:100%;margin-top:-19px;text-align:center;">';
												$rtn[] = $porrealizar.' / '.$total;
											$rtn[] = '</div>';
										$rtn[] = '</div>';
									$rtn[] = '</td>';
								}
									$rtn[] = '<td>'.verificaProcessoValvulas($print->processoid).'</td>';
									$rtn[] = '<td>'.verificaProcessoN2($print->processoid).'</td>';
								if ( $prints != 'a' ) {
									$rtn[] = '<td class="calendarVPN-'.$print->processoid.'" id="'.$print->processoid.'">';
										$rtn[] = clickFormalidades($print->processoid,'VPN');
										if($print->tarefasEA == 0) { $rtn[] = '<div class="block-check"></div>'; } else {
											if($print->vpn == 0) {
												$rtn[] = '<div id="formalidadesVPN-'.$print->processoid.'" name="0" class="error-check"></div>';
											} else {
												$rtn[] = '<div id="formalidadesVPN-'.$print->processoid.'" name="1" class="sucess-check"></div>';
											}
										}
									$rtn[] = '</td>';
								}
									$rtn[] = '<td class="calendarAUSTRIA-'.$print->processoid.'" id="'.$print->processoid.'">';
										$rtn[] = clickFormalidades($print->processoid,'AUSTRIA');
										if($print->tarefasEA == 0) { $rtn[] = '<div class="block-check"></div>'; } else {
											if($print->austria == 0) {
												$rtn[] = '<div id="formalidadesAUSTRIA-'.$print->processoid.'" name="0" class="error-check"></div>';
											} else {
												$rtn[] = '<div id="formalidadesAUSTRIA-'.$print->processoid.'" name="1" class="sucess-check"></div>';
											}
										}
									$rtn[] = '</td>';
								if ( $prints != 'a' ) {
									$rtn[] = '<td class="calendarFATURADO-'.$print->processoid.'" id="'.$print->processoid.'" style="text-align:center;">';
										$rtn[] = clickFormalidades($print->processoid,'FATURADO');
										if($print->faturado_pdf == '') {
											$rtn[] = '<div id="formalidadesFATURADO-'.$print->processoid.'" name="0" class="error-check" style="display:inline-block;"></div>';
											//$rtn[] = '<div id="formalidadesFaturadoEdit-'.$pDados->id.'" class="editafatura" processo="'.$pDados->id.'" name="formalidadesFATURA" style="padding-left:5px;padding-top:3px;vertical-align:top;display:inline-block;">'.$formalidades->formalidades_faturado_pdf.'</div>';
										} else {
											$rtn[] = '<div id="formalidadesFATURADO-'.$print->processoid.'" name="1" class="sucess-check" style="display:inline-block;"></div>';
											//$rtn[] = '<div id="formalidadesFaturadoEdit-'.$pDados->id.'" class="editafatura" processo="'.$pDados->id.'" name="formalidadesFATURA" style="padding-left:5px;padding-top:3px;vertical-align:top;display:inline-block;">'.$formalidades->formalidades_faturado_pdf.'</div>';
										}
									$rtn[] = '</td>';
								}
									$rtn[] = '<td class="editafatura" id="'.$print->processoid.'" name="formalidades_faturado_pdf">'.$print->faturado_pdf.'</td>';
								if ( $prints != 'a' ) {
									$rtn[] = '<td class="calendarENVIADO-'.$print->processoid.'" id="'.$print->processoid.'">';
										$rtn[] = clickFormalidades($print->processoid,'ENVIADO');
										if($print->enviado == 0) {
											$rtn[] = '<div id="formalidadesENVIADO-'.$print->processoid.'" name="0" class="error-check"></div>';
										} else {
											$rtn[] = '<div id="formalidadesENVIADO-'.$print->processoid.'" name="1" class="sucess-check"></div>';
										}
									$rtn[] = '</td>';
									$rtn[] = '<td style="padding:0px;">';
										$rtn[] = '<center>';
											$rtn[] = $print->agendamento_id;
										$rtn[] = '</center>';
									$rtn[] = '</td>';
									$rtn[] = '<td style="padding:0px;">';
										$rtn[] = '<center>';
											$rtn[] = '<span style="cursor:pointer;width:100%;text-align:center;display:inline-block;" class="cadd-'.$pDados->id.'" name="calendar" id="'.$pDados->id.'" onclick="dp.calendario.uploadfilesOpen(this);">Ver/Inserir ficheiros</span>';
										$rtn[] = '</center>';
									$rtn[] = '</td>';
									$rtn[] = '<td style="padding:0px;" id="'.$print->processoid.'">';
										$rtn[] = '<center>';
											if($porrealizar == 0) {
												$rtn[] = '<a href="'.$base.'schedule/'.$print->agendamento_id.'" title="Reagendar"><img src="'.$base.'img/site/calendar.png"></a>';
											}
											$rtn[] = '<a href="'.$base.'process/'.$print->processoid.'" title="Ver"><img src="'.$base.'img/site/lupa.png"></a>';
											$rtn[] = delete_button('','class="delAgendamento" onclick="dp.calendario.agendamentoDelete(\''.$print->processoid.'\');"');
										$rtn[] = '</center>';
									$rtn[] = '</td>';
								}
								$rtn[] = '</tr>	';
						}
					$rtn[] = '</tbody>';
				$rtn[] = '</table>';

			}
		} else {
			$rtn[] = '<p>';
				$rtn[] = 'Nao existem agendamentos para esta data.';
			$rtn[] = '</p>';
		}
	}

	return @implode('',$rtn);
}

// CALENDÁRIO PARA TÉCNICOS
function calendarioTec($datainicio,$datafim,$carrinha,$prints){
	global $sql;
	global $lang;
	global $langvars;
	global $act;
	global $admin;

	//$data = '2013-05-30';
	$data = date('Y-m-d');

	if(date('D', time()) === 'Mon') {
		$dataSegunda = date('Y-m-d');
		//$dataSegunda = date('Y-m-d', strtotime($data. ' last Monday'));
	} else {
		$dataSegunda = date('Y-m-d', strtotime($data. ' last Monday'));
	}
	$dataDomingo = date('Y-m-d', strtotime($dataSegunda. ' + 7 Days'));


	if($carrinha != '') { $teamID = 'AND `equipa`="'.$carrinha.'"'; $teamID2 = 'AND `agendamentos`.`equipa`="'.$carrinha.'"'; } else { $teamID = ''; $teamID2 = ''; }
	if($datainicio != '') { $data1 = $datainicio; } else { $data1 = $dataSegunda; }
	//if($datafim != '') { $data2 = date('Y-m-d', strtotime($datafim. ' + 0 Days')); } else { $data2 = $dataDomingo; }
	if($datafim != '') { $data2 = date('Y-m-d', strtotime($datafim. ' + 1 Days')); } else { $data2 = $dataDomingo; }

	$begin = new DateTime( ''.$data1.'' );
	$end = new DateTime(''.$data2.'' );

	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);

	foreach ($period as $dt) {
		$rtn[] = '<h2>';
			$rtn[] = $dt->format("Y-m-d").' <span style="vertical-align: middle; color: #AAA;">('.diasemana($dt->format("Y-m-d")).')</span>';
		$rtn[] = '</h2>';
		$rtn[] = '<div class="line-subtitle"></div>';

		$query = $sql->query('SELECT * FROM `agendamentos` WHERE `data` = "'.$dt->format("Y-m-d").'" '.$teamID.' AND ( `tecnico1`="'.$admin->id.'" OR `tecnico2`="'.$admin->id.'" OR `tecnico3`="'.$admin->id.'" OR `tecnico4`="'.$admin->id.'") GROUP BY `data` ORDER BY `data` ASC');
		if(mysql_num_rows($query) > 0) {
			while($row = $sql->fetch($query)) {
				$rtn[] = '<script type="text/javascript" charset="utf-8">dp.calendario.calendarioView("'.$row->id.'");</script>';
				$rtn[] = '<table class="wrapper-calendar" id="example-'.$row->id.''.$prints.'" cellpadding="0" cellspacing="0" border="0" class="display">';
					$rtn[] = '<thead>';
						$rtn[] = '<tr>';
							$rtn[] = '<th width="200px" >'.$langvars['calendar_cliente'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_processo'].'</th>';
							$rtn[] = '<th width="50px" style="text-align:center;">'.$langvars['calendar_hora'].'</th>';
							$rtn[] = '<th width="50px" style="text-align:center;">'.$langvars['calendar_data'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_instalador_nome'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_local_nome'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_instalador_contactos'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_cliente_datalimite'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_cliente_ref'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_volume'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_concelho'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_localidade'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_tipo'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_carrinha'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_tecnicos'].'(s)</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_trabalho'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_realizado_total'].'</th>';
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_valvulas'].'</th>';
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_azoto'].'</th>';
							$rtn[] = '<th width="100px" style="text-align:center;">'.$langvars['subtitle_agend'].'</th>';
							$rtn[] = '<th width="60px" style="text-align:center;" id="'.$row->id.'">'.$langvars['calendar_accoes'].'</th>';

						$rtn[] = '</tr>';
					$rtn[] = '</thead>';
					$rtn[] = '<tbody>';

						$querysec = $sql->query('SELECT *,
					`clientes`.`nome` AS cliente,
					`equipamentos`.`cliente_ref` AS quinhentos,
					`processos`.`id` AS processoid ,
					`equipamentos`.`id` AS equipamentoid,
					`carrinhas`.`descricao` AS carrinhadesc ,
					`processos_tarefas`.`formalidades_austria` AS austria,
					`processos_tarefas`.`formalidades_vpn` AS vpn,
					`processos_tarefas`.`formalidades_faturado_pdf` AS faturado_pdf,
					`processos_tarefas`.`formalidades_enviado` AS enviado,
					`ots_pending_list`.`tecnico1` AS tecnico1,
					`ots_pending_list`.`tecnico2` AS tecnico2,
					`ots_pending_list`.`tecnico3` AS tecnico3,
					`ots_pending_list`.`tecnico4` AS tecnico4,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `estado`="10" AND `processos_tarefas`.`id_processo`=`processos`.`id`) AS porfazer,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `id_tarefa`="15" AND `processos_tarefas`.`id_processo`=`processos`.`id`) AS tarefasEA,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `processos_tarefas`.`id_processo`=`processos`.`id`) AS total
					FROM `processos`
					INNER JOIN `agendamentos`  ON `processos`.`agendamento_id`=`agendamentos`.`id`
					INNER JOIN clientes ON `clientes`.`id`=`processos`.`cliente_id`
					INNER JOIN equipamentos ON `equipamentos`.`id`=equipamento_id
					INNER JOIN carrinhas ON `carrinhas`.`id`=equipa
					INNER JOIN processos_tarefas ON `processos_tarefas`.`id_processo`=`processos`.`id`
					INNER JOIN ots_pending_list ON `ots_pending_list`.`id`=`agendamentos`.`id`
					WHERE `agendamentos`.`data`="'.$dt->format("Y-m-d").'" ORDER BY `processos`.`agendamento_hora` ASC');


						while($print = $sql->fetch($querysec)) {
							$revisao = explode('-',$print->interno_processo);
								if ( $revisao[2]!="") { $action = "revision"; } else { $action = ""; }

								$rtn[] = '<tr id="'.$print->id.'" class="'.$action.'">';
									$rtn[] = '<td id="'.$print->cliente.'" name="cliente">'.$print->cliente.'</td>';
									$rtn[] = '<td>'.$print->interno_processo.'</td>';
									//$rtn[] = '<td  id="'.$pDados->id.'" name="hora" style="text-align:center;">'.substr(str_replace(":","h",$print->agendamento_hora),0,5).'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="agendamento_hora" style="text-align:center;">'.$print->agendamento_hora.'</td>';
									$rtn[] = '<td  id="'.$print->agendamento_id.'" name="data" style="text-align:center;">'.$print->data.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="instalador_nome">'.$print->instalador_nome.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="local_nome">'.$print->local_nome.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="instalador_contactos">'.$print->instalador_contactos.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="cliente_datalimite">'.$print->cliente_datalimite.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="cliente_ref">'.$print->quinhentos.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="volume">'.$print->volume.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="local_concelho">'.$print->local_concelho.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="local_localidade">'.$print->local_localidade.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="equipamento_obs">'.$print->equipamento_obs.'</td>';
									$rtn[] = '<td  id="'.$print->agendamento_id.'" name="equipa">'.$print->carrinhadesc.'</td>';
									$rtn[] = '<td  id="'.$print->agendamento_id.'" name="tecnicos">';
										$rtn[] = $print->tecnico1;
										if(!empty($print->tecnico2)) { $rtn[] = ' | '.$print->tecnico2; }
										if(!empty($print->tecnico3)) { $rtn[] = ' | '.$print->tecnico3; }
										if(!empty($print->tecnico4)) { $rtn[] = ' | '.$print->tecnico4; }
									$rtn[] = '</td>';
									$rtn[] = '<td>';
									$sigla = $sql->query('SELECT tarefas.codigo_interno FROM processos_tarefas INNER JOIN tarefas ON processos_tarefas.id_tarefa=tarefas.id WHERE id_processo = "'.$print->processoid.'" GROUP BY codigo_interno');
									$count = 0;
									while($sig = $sql->fetch($sigla)) {
										if ($count++ > 0) $rtn[] = ' | ';
										if($sig->codigo_interno == 'EXTRA') {
											$rtn[] = $sig->nome;
										} else {
											$rtn[] = $sig->codigo_interno;
										}
									}
									$rtn[] = '</td>';
									$rtn[] = '<td>';
									$total = $print->total;
									$totalpendentes = $print->porfazer;
									$porrealizar = $total-$totalpendentes;
									@$printBar = 100-($totalpendentes*100)/$total;
										$rtn[] = '<div style="border: 1px solid #666666;background:#C0C0C0;height:100%;max-height:25px;">';
											$rtn[] = '<div style="background: green;height: 100%; width:'.$printBar.'%;"></div>';
											$rtn[] = '<div style="color:#FFF;height: 100%; width:100%;margin-top:-19px;text-align:center;">';
												$rtn[] = $porrealizar.' / '.$total;
											$rtn[] = '</div>';
										$rtn[] = '</div>';
									$rtn[] = '</td>';
									$rtn[] = '<td>'.verificaProcessoValvulas($print->processoid).'</td>';
									$rtn[] = '<td>'.verificaProcessoN2($print->processoid).'</td>';

									$rtn[] = '<td style="padding:0px;">';
										$rtn[] = '<center>';
											$rtn[] = $print->agendamento_id;
										$rtn[] = '</center>';
									$rtn[] = '</td>';
									$rtn[] = '<td style="padding:0px;" id="'.$print->id.'">';
										$rtn[] = '<center>';
											$rtn[] = '<a href="'.$base.'process/'.$print->id.'"><img src="'.$base.'img/site/lupa.png"></a>';
										$rtn[] = '</center>';
									$rtn[] = '</td>';

								$rtn[] = '</tr>	';
						}
					$rtn[] = '</tbody>';
				$rtn[] = '</table>';

			}
		} else {
			$rtn[] = '<p>';
				$rtn[] = $langvars['global_No_agenda'];
			$rtn[] = '</p>';
		}
	}

	return @implode('',$rtn);
}


// CALENDÁRIO PARA CLIENTES
function calendarioCli($datainicio,$datafim,$carrinha,$prints){
	global $sql;
	global $lang;
	global $langvars;
	global $act;
	global $admin;
	global $cliente;

	//$data = '2013-05-30';
	$data = date('Y-m-d');

	if(date('D', time()) === 'Mon') {
		$dataSegunda = date('Y-m-d');
		//$dataSegunda = date('Y-m-d', strtotime($data. ' last Monday'));
	} else {
		$dataSegunda = date('Y-m-d', strtotime($data. ' last Monday'));
	}
	$dataDomingo = date('Y-m-d', strtotime($dataSegunda. ' + 7 Days'));


	if($carrinha != '') { $teamID = 'AND `equipa`="'.$carrinha.'"'; $teamID2 = 'AND `agendamentos`.`equipa`="'.$carrinha.'"'; } else { $teamID = ''; $teamID2 = ''; }
	if($datainicio != '') { $data1 = $datainicio; } else { $data1 = $dataSegunda; }
	//if($datafim != '') { $data2 = date('Y-m-d', strtotime($datafim. ' + 0 Days')); } else { $data2 = $dataDomingo; }
	if($datafim != '') { $data2 = date('Y-m-d', strtotime($datafim. ' + 1 Days')); } else { $data2 = $dataDomingo; }

	$begin = new DateTime( ''.$data1.'' );
	$end = new DateTime(''.$data2.'' );

	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);

	foreach ($period as $dt) {
		$rtn[] = '<h2>';
			$rtn[] = $dt->format("Y-m-d").' <span style="vertical-align: middle; color: #AAA;">('.diasemana($dt->format("Y-m-d")).')</span>';
		$rtn[] = '</h2>';
		$rtn[] = '<div class="line-subtitle"></div>';

		$query = $sql->query('SELECT `processos`.*, `agendamentos`.* FROM `processos` INNER JOIN `agendamentos` ON `processos`.`agendamento_id`=`agendamentos`.`id` WHERE `agendamentos`.`data`="'.$dt->format("Y-m-d").'" AND `processos`.`cliente_id`="'.$cliente->id.'" ORDER BY `processos`.`agendamento_hora` ASC');
		if(mysql_num_rows($query) > 0) {
			while($row = $sql->fetch($query)) {
				$rtn[] = '<script type="text/javascript" charset="utf-8">dp.calendario.calendarioView("'.$row->id.'");</script>';
				$rtn[] = '<table class="wrapper-calendar" id="example-'.$row->id.''.$prints.'" cellpadding="0" cellspacing="0" border="0" class="display">';
					$rtn[] = '<thead>';
						$rtn[] = '<tr>';
							$rtn[] = '<th width="200px" >'.$langvars['calendar_cliente'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_processo'].'</th>';
							$rtn[] = '<th width="50px" style="text-align:center;">'.$langvars['calendar_hora'].'</th>';
							//$rtn[] = '<th width="50px" style="text-align:center;">'.$langvars['calendar_data'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_instalador_nome'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_local_nome'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_instalador_contactos'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_cliente_datalimite'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_cliente_ref'].'</th>';
							$rtn[] = '<th width="70px">'.$langvars['calendar_volume'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_concelho'].'</th>';
							$rtn[] = '<th width="150px">'.$langvars['calendar_localidade'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_tipo'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_carrinha'].'</th>';
							$rtn[] = '<th width="300px">'.$langvars['calendar_tecnicos'].'(s)</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_trabalho'].'</th>';
							$rtn[] = '<th width="100px">'.$langvars['calendar_realizado_total'].'</th>';
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_valvulas'].'</th>';
							$rtn[] = '<th width="40px" style="text-align:center;">'.$langvars['calendar_azoto'].'</th>';
							//$rtn[] = '<th width="100px" style="text-align:center;">Agendamento</th>';
							//$rtn[] = '<th width="60px" style="text-align:center;" id="'.$row->id.'">'.$langvars['calendar_accoes'].'</th>';

						$rtn[] = '</tr>';
					$rtn[] = '</thead>';
					$rtn[] = '<tbody>';
						$querysec = $sql->query('SELECT *,
					`clientes`.`nome` AS cliente,
					`equipamentos`.`cliente_ref` AS quinhentos,
					`processos`.`id` AS processoid ,
					`equipamentos`.`id` AS equipamentoid,
					`carrinhas`.`descricao` AS carrinhadesc ,
					`processos_tarefas`.`formalidades_austria` AS austria,
					`processos_tarefas`.`formalidades_vpn` AS vpn,
					`processos_tarefas`.`formalidades_faturado_pdf` AS faturado_pdf,
					`processos_tarefas`.`formalidades_enviado` AS enviado,
					`ots_pending_list`.`tecnico1` AS tecnico1,
					`ots_pending_list`.`tecnico2` AS tecnico2,
					`ots_pending_list`.`tecnico3` AS tecnico3,
					`ots_pending_list`.`tecnico4` AS tecnico4,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `estado`="10" AND `processos_tarefas`.`id_processo`=`processos`.`id`) AS porfazer,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `id_tarefa`="15" AND `processos_tarefas`.`id_processo`=`processos`.`id`) AS tarefasEA,
					(SELECT COUNT(*) FROM `processos_tarefas` WHERE `processos_tarefas`.`id_processo`=`processos`.`id`) AS total
					FROM `processos`
					INNER JOIN `agendamentos`  ON `processos`.`agendamento_id`=`agendamentos`.`id`
					INNER JOIN clientes ON `clientes`.`id`=`processos`.`cliente_id`
					INNER JOIN equipamentos ON `equipamentos`.`id`=equipamento_id
					INNER JOIN carrinhas ON `carrinhas`.`id`=equipa
					INNER JOIN processos_tarefas ON `processos_tarefas`.`id_processo`=`processos`.`id`
					INNER JOIN ots_pending_list ON `ots_pending_list`.`id`=`agendamentos`.`id`
					WHERE `agendamentos`.`data`="'.$dt->format("Y-m-d").'" ORDER BY `processos`.`agendamento_hora` ASC');

						while($print = $sql->fetch($querysec)) {
							$revisao = explode('-',$print->interno_processo);
								if ( $revisao[2]!="") { $action = "revision"; } else { $action = ""; }


								$rtn[] = '<tr id="'.$print->id.'" class="'.$action.'">';
									$rtn[] = '<td id="'.$print->cliente.'" name="cliente">'.$print->cliente.'</td>';
									$rtn[] = '<td>'.$print->interno_processo.'</td>';
									//$rtn[] = '<td  id="'.$pDados->id.'" name="hora" style="text-align:center;">'.substr(str_replace(":","h",$print->agendamento_hora),0,5).'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="agendamento_hora" style="text-align:center;">'.$print->agendamento_hora.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="instalador_nome">'.$print->instalador_nome.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="local_nome">'.$print->local_nome.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="instalador_contactos">'.$print->instalador_contactos.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="cliente_datalimite">'.$print->cliente_datalimite.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="cliente_ref">'.$print->quinhentos.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="volume">'.$print->volume.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="local_concelho">'.$print->local_concelho.'</td>';
									$rtn[] = '<td  id="'.$eDados->id.'" name="local_localidade">'.$print->local_localidade.'</td>';
									$rtn[] = '<td  id="'.$pDados->id.'" name="equipamento_obs">'.$print->equipamento_obs.'</td>';
									$rtn[] = '<td  id="'.$print->agendamento_id.'" name="equipa">'.$print->carrinhadesc.'</td>';
									$rtn[] = '<td  id="'.$print->agendamento_id.'" name="tecnicos">';
										$rtn[] = $print->tecnico1;
										if(!empty($print->tecnico2)) { $rtn[] = ' | '.$print->tecnico2; }
										if(!empty($print->tecnico3)) { $rtn[] = ' | '.$print->tecnico3; }
										if(!empty($print->tecnico4)) { $rtn[] = ' | '.$print->tecnico4; }
									$rtn[] = '</td>';






									$rtn[] = '<td>';
									$sigla = $sql->query('SELECT tarefas.codigo_interno FROM processos_tarefas INNER JOIN tarefas ON processos_tarefas.id_tarefa=tarefas.id WHERE id_processo = "'.$print->processoid.'" GROUP BY codigo_interno');
									$count = 0;
									while($sig = $sql->fetch($sigla)) {
										if ($count++ > 0) $rtn[] = ' | ';
										if($sig->codigo_interno == 'EXTRA') {
											$rtn[] = $sig->nome;
										} else {
											$rtn[] = $sig->codigo_interno;
										}
									}
									$rtn[] = '</td>';
									$rtn[] = '<td>';
									$total = $print->total;
									$totalpendentes = $print->porfazer;
									$porrealizar = $total-$totalpendentes;
									@$printBar = 100-($totalpendentes*100)/$total;
										$rtn[] = '<div style="border: 1px solid #666666;background:#C0C0C0;height:100%;max-height:25px;">';
											$rtn[] = '<div style="background: green;height: 100%; width:'.$printBar.'%;"></div>';
											$rtn[] = '<div style="color:#FFF;height: 100%; width:100%;margin-top:-19px;text-align:center;">';
												$rtn[] = $porrealizar.' / '.$total;
											$rtn[] = '</div>';
										$rtn[] = '</div>';
									$rtn[] = '</td>';
									$rtn[] = '<td>'.verificaProcessoValvulas($print->processoid).'</td>';
									$rtn[] = '<td>'.verificaProcessoN2($print->processoid).'</td>';

									/*$rtn[] = '<td style="padding:0px;">';
											$rtn[] = '<center>';
												$rtn[] = $pDados->agendamento_id;
											$rtn[] = '</center>';
										$rtn[] = '</td>';
									$rtn[] = '<td style="padding:0px;" id="'.$pDados->id.'">';
										$rtn[] = '<center>';
											$rtn[] = '<a href="'.$base.'process/'.$pDados->id.'"><img src="'.$base.'img/site/lupa.png"></a>';
										$rtn[] = '</center>';
									$rtn[] = '</td>';*/

								$rtn[] = '</tr>	';
						}
					$rtn[] = '</tbody>';
				$rtn[] = '</table>';
			break;
			}

		} else {
			$rtn[] = '<p>';
				$rtn[] = $langvars['global_No_agenda'];
			$rtn[] = '</p>';
		}
	}

	return @implode('',$rtn);
}



// LISTAR PROCESSOS SELECIONADOS PARA AGENDAR
function addProcessAgenda($idprocesso,$horaH,$horaM){
	global $sql;
	global $lang;
	global $langvars;
	global $base;

	$rtn[]	= '<div class="processBlock" id="blockP-'.$idprocesso.'">';
	$rtn[]	= '<span id="'.$idprocesso.'" class="'.$idprocesso.'" style="float:right;cursor:pointer;margin-bottom:-20px;" onclick="dp.calendario.eliminaProcessoAgendar(this);"><img src="'.$base.'img/site/delete.png" /></span>';
	$res	= $sql->query('SELECT * FROM processos WHERE id = "'.$idprocesso.'"');
	while($ipro = $sql->fetch($res)) {
		$cDados 	= $sql->fetch($sql->query('SELECT * FROM clientes WHERE id = "'.$ipro->cliente_id.'"'));
		$eDados 	= $sql->fetch($sql->query('SELECT * FROM equipamentos WHERE id = "'.$ipro->equipamento_id.'"'));
		$etDados 	= $sql->fetch($sql->query('SELECT * FROM equipamentos_tipo WHERE id = "'.$eDados->tipo_id.'"'));

		$rtn[] = '<table class="process-detail">';
			$rtn[] = '<tbody>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;vertical-align:middle;padding: 5px 10px 5px 0;" class="title-detail">'.$langvars['form_hour'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">';
						$rtn[] = '<select class="select-pesq-horas-'.$idprocesso.' select-task select-pesq-horas" style="margin: 0 0 0 0px;" name="horaH-'.$ipro->id.'">
								<option value="06" '.($horaH == '06' ? 'selected="selected"' : '').'>06</option>
								<option value="07" '.($horaH == '07' ? 'selected="selected"' : '').'>07</option>
								<option value="08" '.($horaH == '08' || $horaH == '' ? 'selected="selected"' : '').'>08</option>
								<option value="09" '.($horaH == '09' ? 'selected="selected"' : '').'>09</option>
								<option value="10" '.($horaH == '10' ? 'selected="selected"' : '').'>10</option>
								<option value="11" '.($horaH == '11' ? 'selected="selected"' : '').'>11</option>
								<option value="12" '.($horaH == '12' ? 'selected="selected"' : '').'>12</option>
								<option value="13" '.($horaH == '13' ? 'selected="selected"' : '').'>13</option>
								<option value="14" '.($horaH == '14' ? 'selected="selected"' : '').'>14</option>
								<option value="15" '.($horaH == '15' ? 'selected="selected"' : '').'>15</option>
								<option value="16" '.($horaH == '16' ? 'selected="selected"' : '').'>16</option>
								<option value="17" '.($horaH == '17' ? 'selected="selected"' : '').'>17</option>
								<option value="18" '.($horaH == '18' ? 'selected="selected"' : '').'>18</option>
								<option value="19" '.($horaH == '19' ? 'selected="selected"' : '').'>19</option>
								<option value="20" '.($horaH == '20' ? 'selected="selected"' : '').'>20</option>
								<option value="21" '.($horaH == '21' ? 'selected="selected"' : '').'>21</option>
								<option value="22" '.($horaH == '22' ? 'selected="selected"' : '').'>22</option>
								<option value="23" '.($horaH == '23' ? 'selected="selected"' : '').'>23</option>
								<option value="00" '.($horaH == '00' ? 'selected="selected"' : '').'>00</option>
								<option value="01" '.($horaH == '01' ? 'selected="selected"' : '').'>01</option>
								<option value="02" '.($horaH == '02' ? 'selected="selected"' : '').'>02</option>
								<option value="03" '.($horaH == '03' ? 'selected="selected"' : '').'>03</option>
							  </select>
							  <span style="vertical-align: sub; padding-right: 4px;">:</span>
							  <select class="select-pesq-horas-'.$idprocesso.' select-task select-pesq-horas" name="horaM-'.$ipro->id.'">
								<option value="00" '.($horaM == '00' || $horaM == '' ? 'selected="selected"' : '').'>00</option>
								<option value="15" '.($horaM == '15' ? 'selected="selected"' : '').'>15</option>
								<option value="30" '.($horaM == '30' ? 'selected="selected"' : '').'>30</option>
								<option value="45" '.($horaM == '45' ? 'selected="selected"' : '').'>45</option>
							  </select>';
					$rtn[] = '</td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_process_code'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;"><a href="'.$base.'process/'.$ipro->id.'" target="_blank">'.$ipro->interno_processo.'</a></td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_name'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">'.$eDados->local_nome.'</td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_nfabric'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">'.$eDados->nr_fabrico.'</td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_type_equip'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">'.$etDados->nome.'</td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_local'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">'.$eDados->local_localidade.'</td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_client'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">'.$cDados->nome.'</td>';
				$rtn[] = '</tr>';
				$rtn[] = '<tr>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;vertical-align:middle;" class="title-detail">'.$langvars['form_client_code'].'</td>';
					$rtn[] = '<td style="background-color:#f2f2f2;padding: 5px 10px 5px 0;">'.$eDados->cliente_ref.'</td>';
				$rtn[] = '</tr>';
			$rtn[] = '</tbody>';
		$rtn[] = '</table>';

		/*$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text" style="vertical-align: middle;">'.$langvars['form_hour'].'</span>';
		$rtn[] = '<select class="select-pesq-horas-'.$idprocesso.' select-task select-pesq-horas" style="margin: 0 0 0 0px;" name="horaH-'.$ipro->id.'">
					<option value="06" '.($horaH == '06' ? 'selected="selected"' : '').'>06</option>
					<option value="07" '.($horaH == '07' ? 'selected="selected"' : '').'>07</option>
					<option value="08" '.($horaH == '08' || $horaH == '' ? 'selected="selected"' : '').'>08</option>
					<option value="09" '.($horaH == '09' ? 'selected="selected"' : '').'>09</option>
					<option value="10" '.($horaH == '10' ? 'selected="selected"' : '').'>10</option>
					<option value="11" '.($horaH == '11' ? 'selected="selected"' : '').'>11</option>
					<option value="12" '.($horaH == '12' ? 'selected="selected"' : '').'>12</option>
					<option value="13" '.($horaH == '13' ? 'selected="selected"' : '').'>13</option>
					<option value="14" '.($horaH == '14' ? 'selected="selected"' : '').'>14</option>
					<option value="15" '.($horaH == '15' ? 'selected="selected"' : '').'>15</option>
					<option value="16" '.($horaH == '16' ? 'selected="selected"' : '').'>16</option>
					<option value="17" '.($horaH == '17' ? 'selected="selected"' : '').'>17</option>
					<option value="18" '.($horaH == '18' ? 'selected="selected"' : '').'>18</option>
					<option value="19" '.($horaH == '19' ? 'selected="selected"' : '').'>19</option>
					<option value="20" '.($horaH == '20' ? 'selected="selected"' : '').'>20</option>
					<option value="21" '.($horaH == '21' ? 'selected="selected"' : '').'>21</option>
					<option value="22" '.($horaH == '22' ? 'selected="selected"' : '').'>22</option>
					<option value="23" '.($horaH == '23' ? 'selected="selected"' : '').'>23</option>
					<option value="00" '.($horaH == '00' ? 'selected="selected"' : '').'>00</option>
					<option value="01" '.($horaH == '01' ? 'selected="selected"' : '').'>01</option>
					<option value="02" '.($horaH == '02' ? 'selected="selected"' : '').'>02</option>
					<option value="03" '.($horaH == '03' ? 'selected="selected"' : '').'>03</option>
				  </select>
				  <span style="vertical-align: sub; padding-right: 4px;">:</span>
				  <select class="select-pesq-horas-'.$idprocesso.' select-task select-pesq-horas" name="horaM-'.$ipro->id.'">
					<option value="00" '.($horaM == '00' || $horaM == '' ? 'selected="selected"' : '').'>00</option>
					<option value="15" '.($horaM == '15' ? 'selected="selected"' : '').'>15</option>
					<option value="30" '.($horaM == '30' ? 'selected="selected"' : '').'>30</option>
					<option value="45" '.($horaM == '45' ? 'selected="selected"' : '').'>45</option>
				  </select>';
		$rtn[] = '</p>';
		$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text">'.$langvars['form_process_code'].'</span><a href="'.$base.'process/'.$ipro->id.'" target="_blank">'.$ipro->interno_processo.'</a></p>';
		$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text">'.$langvars['form_equipment'].'</span>'.$eDados->nr_fabrico.'</p>';
		$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text">'.$langvars['form_type_equip'].'</span>'.$etDados->nome.'</p>';
		$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text">'.$langvars['form_local'].'</span>'.$eDados->local_localidade.'</p>';
		$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text">'.$langvars['form_local2'].'</span>'.$eDados->local_nome.'</p>';
		$rtn[] = '<p style="margin: 5px 0px;"><span class="topic-text">'.$langvars['form_client'].'</span>'.$cDados->nome.'</p>';*/
		$rtn[] = '<input type="hidden" name="calendarProc[]" value="'.$ipro->id.'" />';
	}

	$rtn[]	= '</div>';

	return implode('',$rtn);
}
/*
function mapa_pesquisa($estadoprocesso,$clientesprocesso,$instaladorprocesso,$tipovolume,$tipoprocesso,$tipotarefa) {
	global $sql;
	global $lang;
	global $langvars;
	global $base;

	$rtn[] = '<style>';
	$rtn[] = '#map_canvas { height:600px; width:750px;  position:relative; float:left; margin-top:10px; }';
	$rtn[] = '#search { height:600px; width:200px; position:relative; float:left; padding:10px;}';
	$rtn[] = '</style>';

	$i=0;
	$numero=0;
		//PESQUISA POR ESTADO DE PROCESSO
		$size = sizeof($estadoprocesso);
		if ( $size > 0 ) {
		$Pesq_estado .= 'AND ( ';
		foreach ($estadoprocesso as $estado) {
			$Pesq_estado .= 'interno_estado = "'.$estado.'"';
			$Pesq_estado .= ' OR ';
		}
		$Pesq_estado = substr($Pesq_estado, 0, -4);
		$Pesq_estado .= ' )';
		}

		//PESQUISA POR CLIENTE
		$size = sizeof($clientesprocesso);
		if ( $size > 0 ) {
		$Pesq_cliente .= 'AND ( ';
		foreach ($clientesprocesso as $cli) {
			$Pesq_cliente .= 'cliente_id = "'.$cli.'"';
			$Pesq_cliente .= ' OR ';
		}
		$Pesq_cliente = substr($Pesq_cliente, 0, -4);
		$Pesq_cliente .= ' )';
		}

		//PESQUISA POR INSTALADOR
		$size = sizeof($instaladorprocesso);
		if ( $size > 0 ) {
		$Pesq_instalador .= 'AND ( ';
		foreach ($instaladorprocesso as $cli) {
			$Pesq_instalador .= 'instalador_nome = "'.$cli.'"';
			$Pesq_instalador .= ' OR ';
		}
		$Pesq_instalador = substr($Pesq_instalador, 0, -4);
		$Pesq_instalador .= ' )';
		}

		//PESQUISA POR TIPO DE EQUIPAMENTO
		$size = sizeof($tipoprocesso);
		if ( $size > 0 ) {
		$Pesq_tipo .= 'AND ( ';
		foreach ($tipoprocesso as $tipo) {
			$Pesq_tipo .= 'tipo_id = "'.$tipo.'"';
			$Pesq_tipo .= ' OR ';
		}
		$Pesq_tipo = substr($Pesq_tipo, 0, -4);
		$Pesq_tipo .= ' )';
		}

		//PESQUISA POR TIPO DE TAREFA
		$size = sizeof($tipotarefa);
		if ( $size > 0 ) {
		$Pesq_tarefa .= 'AND ( ';
		foreach ($tipotarefa as $tarefa) {
			$Pesq_tarefa .= 'id_tarefa = "'.$tarefa.'"';
			$Pesq_tarefa .= ' OR ';
		}
		$Pesq_tarefa = substr($Pesq_tarefa, 0, -4);
		$Pesq_tarefa .= ' )';
		}

		//PESQUISA POR TIPO DE VOLUME
		$size = sizeof($tipovolume);
		if ( $size > 0 ) {
		$Pesq_volume .= 'AND ( ';
		foreach ($tipovolume as $volume) {
			$Pesq_volume .= $volume;
			$Pesq_volume .= ' OR ';
		}
		$Pesq_volume = substr($Pesq_volume, 0, -4);
		$Pesq_volume .= ' )';
		}

		$res = $sql->query('SELECT * FROM equipamentos WHERE local_google!="" '.$Pesq_tipo.' '.$Pesq_volume.'');
		while($dbdata = $sql->fetch($res)) {

		//RESET AOS CONTEUDOS
		$Cprocesso = '';
		$Ctarefas = '';
		$Cequipamento = '';
		$Ccontato = '';

		$clientes = mysql_fetch_array(mysql_query('SELECT * FROM clientes WHERE id = "'.$dbdata->cliente_id.'" '));
		$processo = mysql_fetch_array(mysql_query('SELECT * FROM processos WHERE equipamento_id = "'.$dbdata->id.'" '.$Pesq_estado.' '.$Pesq_cliente.' '.$Pesq_instalador.''));
		$valida_tarefa = mysql_fetch_array(mysql_query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$processo['id'].'" '.$Pesq_tarefa.''));


		// DEFINIÇÃO DE MARCADOR
		if ( $dbdata->cliente_id == "66") { $cor = $base.'img/site/icon-marker-blue.png'; }
		elseif ( $dbdata->cliente_id == "9") { $cor = $base.'img/site/icon-marker-blue.png'; }
		elseif ( $dbdata->cliente_id == "24") { $cor = $base.'img/site/icon-marker-green.png'; }
		elseif ( $dbdata->cliente_id == "56") { $cor = $base.'img/site/icon-marker-yellow.png'; }
		elseif ( $dbdata->cliente_id == "30") { $cor = $base.'img/site/icon-marker-orange.png'; }
		elseif ( $dbdata->cliente_id == "17") { $cor = $base.'img/site/icon-marker-orange.png'; }
		elseif ( $dbdata->cliente_id == "50") { $cor = $base.'img/site/icon-marker-red.png'; }
		else { $cor = $base.'img/site/icon-marker-grey.png'; }




			if ( $processo['interno_processo'] != '' && $valida_tarefa['id'] != "" ) {


				$Cprocesso .= '<span onclick="dp.agendar.agendamentoAgendarMapa(\''.$processo['id'].'\');" style="display:inline-block;margin-left:2px;margin-top:5px;font-weight:400;font-size:12px;vertical-align:bottom;padding:5px 10px;background-color:#E6E6E6;border: 1px solid #CCCCCC;cursor:pointer;">Agendar este processo</span>';

				//CONTEUDO PROCESSO

				$Cprocesso .= '<table class="dataTable"><tr><th colspan="3" align="center"><h5 style="margin:0px;">PROCESSO - '.$processo['interno_processo'].'</h5></th></tr>';
				$Cprocesso .= '<tr><td><b>'.$langvars['form_client'].'</b><br>'.$clientes['nome'].'</td>';
				$Cprocesso .= '<td><b>'.$langvars['form_install_name'].'</b><br>'.$processo['instalador_nome'].'</td>';
				$Cprocesso .= '<td><b>CODIGO INTERNO</b><br>?'.$processo['cliente_codinterno'].'</td></tr>';
				$Cprocesso .= '<tr><td><b>'.$langvars['form_data_pedido'].'</b><br>'.$processo['cliente_datapedido'].'</td>';
				$Cprocesso .= '<td><b>'.$langvars['form_data_limite'].'</b><br>'.$processo['cliente_datalimite'].'</td>';
				$Cprocesso .= '<td><b>CONTACTOS</b><br>?</td></tr></table>';


				$Ctarefas .='<table class="dataTable"><tr><th><h5 style="margin:0px;">TAREFAS AGENDADAS</h5></th></tr>';

				$tare = $sql->query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$processo['id'].'" ');
				while($tarefas = $sql->fetch($tare)) {
					$tarefas2 = mysql_fetch_array(mysql_query('SELECT nome FROM tarefas WHERE id = "'.$tarefas->id_tarefa.'" '));
					$Ctarefas .= '<tr><td>'.$tarefas2['nome'].'</tr></td>';
				}

				$Ctarefas .='</table>';
				$Cequipamento .='<table class="dataTable"><tr><th colspan="3"><h5 style="margin:0px;">EQUIPAMENTO </h5></th></tr>';
				$tipoequimapento = mysql_fetch_array(mysql_query('SELECT nome FROM equipamentos_tipo WHERE id = "'.$dbdata->tipo_id.'" '));
				$Cequipamento .= '<tr><td><b>'.$langvars['form_type_equip'].'</b><br>'.$tipoequimapento['nome'].'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_client'].'</b><br>'.$clientes['nome'].' - REPETICAO</td>';
				$Cequipamento .= '<td><b>Ref. Cliente</b><br>'.$dbdata->cliente_ref.'</td></tr>';
				$Cequipamento .= '<tr><td><b>'.$langvars['form_nfabric'].'</b><br>'.$dbdata->nr_fabrico.'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_nregist'].'</b><br>'.$dbdata->nr_registo.'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_volume'].'</b><br>'.$dbdata->volume.'</td></tr>';
				$Cequipamento .= '<tr><td><b>'.$langvars['form_timbre'].'</b><br>'.$dbdata->timbre.'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_year'].'</b><br>'.$dbdata->ano.'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_local_install'].'</b><br>'.$dbdata->local_nome.'</td></tr>';
				$Cequipamento .= '<tr><td><b>'.$langvars['form_contact'].'</b><br>'.$dbdata->local_contacto.'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_gps'].'</b><br>'.$dbdata->local_gps.'</td>';
				$Cequipamento .= '<td><b>'.$langvars['form_address'].'</b><br>'.$dbdata->local_morada.'</td></tr></table>';

				$Cequipamento .='<h5 style="margin-bottom:10px;">OBS. CLIENTE</h5><div class="line-subtitle"></div>';
				$Cequipamento .='<p>'.$dbdata->observacoes.'</p>';
				$Cequipamento .='<h5 style="margin-bottom:10px;">OBS. PELA QTEC</h5><div class="line-subtitle"></div>';
				$Cequipamento .='<p>?</p>';
				$Cequipamento .='<h5 style="margin-bottom:10px;">OBS. EQUIPAMENTO</h5><div class="line-subtitle"></div>';
				$Cequipamento .='<p>'.$dbdata->local_obs.'</p>';

				$Ccontato .='<h5 style="margin-bottom:10px;">MORADA</h5><div class="line-subtitle"></div>';
				$Ccontato .= '<div><br>'.$clientes['nome'].'<br>'.$clientes['morada'].'<br>'.$clientes['cp'].' '.$clientes['localidade'].'<br></div>';
				$Ccontato .='<h5 style="margin-bottom:10px;">CONTACTO</h5><div class="line-subtitle"></div>';
				$Ccontato .= '<div><br>'.$clientes['contacto_nome'].'<br>'.$clientes['contacto_email'].'<br>'.$clientes['contacto_telf'].'</div>';

				// VARIAVEIS A PASSAR
				$point = explode(',', $dbdata->local_google);
				$equipamento2[$i] = $dbdata->id;
				$processo[$i] = $processo['id'];

				$icon[$i] = $cor;
				$pointsx[$i] = $point[0];
				$pointsy[$i] = $point[1];
				$conteudo[$i] = '<div style="height:400px; width:600px;overflow-y:scroll; ">'.utf8_encode($Cprocesso).utf8_encode($Ctarefas).utf8_encode($Cequipamento).utf8_encode($Ccontato).'</div>';
				$i++;

			}
		}

	$equipamento2 = json_encode($equipamento2);
	$x = json_encode($pointsx);
	$y = json_encode($pointsy);
	$icon = json_encode($icon);
	$processo = json_encode($processo);
	$conteudo = json_encode($conteudo);

	$rtn[] = '<div id="map_canvas"></div>';
	$rtn[] = '<div id="search">';
	$rtn[] = '<form method="POST">';
	$rtn[] = 'Estado Processo';
	$rtn[] = '<select name="EstadoProcesso[]" class="select-addEquipProcess chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2" multiple="multiple">';
	$rtn[] = '<option> </option>';

		$res = $sql->query('SELECT * FROM processos_estados');
		while($estado = $sql->fetch($res)) {
		if (@in_array($estado->id, $estadoprocesso)) { $var ="SELECTED";}	else { $var =""; }
		$rtn[] = '<option '.$var.' value="'.$estado->id.'" >'.$estado->nome.'</option>';
		}

	$rtn[] = '</select>';
	$rtn[] = '<br><br>';
	$rtn[] = 'Cliente';
	$rtn[] = '<select name="ClientesProcesso[]" class="select-addEquipProcess chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2" multiple="multiple">';
	$rtn[] = '<option> </option>';

		$resu = $sql->query('SELECT * FROM clientes ORDER BY nome');
		while($client = $sql->fetch($resu)) {
		if (@in_array($client->id, $clientesprocesso)) { $var ="SELECTED";}	else { $var =""; }
		$rtn[] = '<option '.$var.' value="'.$client->id.'">'.$client->nome.'</option>';
		}

	$rtn[] = '</select>';
	$rtn[] = '<br><br>';
	$rtn[] = 'Instalador';
	$rtn[] = '<select name="InstaladorProcesso[]" class="select-addEquipProcess chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2" multiple="multiple">';
	$rtn[] = '<option> </option>';

		$resu = $sql->query('SELECT DISTINCT instalador_nome FROM processos ORDER BY instalador_nome');
		while($instalador = $sql->fetch($resu)) {
		if (@in_array($instalador->instalador_nome, $instaladorprocesso)) { $var ="SELECTED";}	else { $var =""; }
		$rtn[] = '<option '.$var.' value="'.$instalador->instalador_nome.'">'.$instalador->instalador_nome.'</option>';
		}

	$rtn[] = '</select>';
	$rtn[] = '<br><br>';
	$rtn[] = 'Volume';
	$rtn[] = '<select name="TipoVolume[]" class="select-addEquipProcess chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2" multiple="multiple">';
	$rtn[] = '<option> </option>';
	if (@in_array("(volume < 5000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume < 5000)">0 - 5.000 </option>';
	if (@in_array("(volume > 5000 AND volume < 10000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume > 5000 AND volume < 10000)">5.000 - 10.000</option>';
	if (@in_array("(volume > 10000 AND volume < 13000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume > 10000 AND volume < 13000)">10.000 - 13.000</option>';
	if (@in_array("(volume > 13000 AND volume < 22000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume > 13000 AND volume < 22000)">13.000 - 22.000</option>';
	if (@in_array("(volume > 22000 AND volume < 35000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume > 22000 AND volume < 35000)">22.000 - 35.000</option>';
	if (@in_array("(volume > 35000 AND volume < 60000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume > 35000 AND volume < 60000)">35.000 - 60.000</option>';
	if (@in_array("(volume > 60000)", $tipovolume)) { $var ="SELECTED";}	else { $var =""; }
	$rtn[] = '<option '.$var.' value="(volume > 60000)">+60.000</option>';


	$rtn[] = '</select>';
	$rtn[] = '<br><br>';
	$rtn[] = 'Tipo de Equipamento';
	$rtn[] = '<select name="TipoProcesso[]" class="select-addEquipProcess chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2" multiple="multiple">';
	$rtn[] = '<option> </option>';

		$resu = $sql->query('SELECT * FROM `equipamentos_tipo` ');
		while($tipo_eq = $sql->fetch($resu)) {
		if (@in_array($tipo_eq->id, $tipoprocesso)) { $var ="SELECTED";}	else { $var =""; }
		$rtn[] = '<option '.$var.' value="'.$tipo_eq->id.'">'.$tipo_eq->nome.'</option>';
		}

	$rtn[] = '</select>';
	$rtn[] = '<br><br>';
	$rtn[] = 'Tipo de Tarefa';
	$rtn[] = '<select name="TipoTarefa[]" class="select-addEquipProcess chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2" multiple="multiple">';
	$rtn[] = '<option> </option>';

		$resu = $sql->query('SELECT * FROM `tarefas` ');
		while($tipo_tarefa = $sql->fetch($resu)) {
		if (@in_array($tipo_tarefa->id, $tipotarefa)) { $rtn[] = $var ="SELECTED";}	else { $var =""; }
		$rtn[] = '<option '.$var.' value="'.$tipo_tarefa->id.'">'.$tipo_tarefa->codigo_interno.'</option>';
		}

	$rtn[] = '</select>';
	$rtn[] = '<input type="submit" value="'.$langvars['global_pesquisar'].'" style="float:right;margin-top:40px;padding:5px 5px;background: #EEE;border:1px solid #CCC;">';
	$rtn[] = '<form>';
	$rtn[] = '</div>';
	$rtn[] = '<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>';
	$rtn[] = '<script type="text/javascript">
	var map;

	function initialize() {
	  var mapOptions = { center: new google.maps.LatLng(39.931486, -5.473633),
						 zoom: 6,
						 mapTypeId: google.maps.MapTypeId.ROADMAP };
	  map = new google.maps.Map(document.getElementById("map_canvas"), mapOptions);
	  window.onresize = function(event) {
	 google.maps.event.trigger(gMap, "resize");
	}


	  var conteudo = '.$conteudo.';
	  var arraylng = '.$x.';
	  var arraylat = '.$y.';
	  var equipamento = '.$equipamento2.';
	  var icon = '.$icon.';
	  var processo = '.$processo.';


	  var markers = [];


	  var infowindow = new google.maps.InfoWindow({
	  width:"400"
	  });

	  for (var i = 0; i < arraylng.length; i++) {
		var marker = new google.maps.Marker({
		  position: new google.maps.LatLng(arraylng[i], arraylat[i]),
		  map: map,
		  icon: icon[i]
		});

		makeInfoWindowEvent(map, infowindow, conteudo[i], marker);

		markers.push(marker);
	  }
	}

	function makeInfoWindowEvent(map, infowindow, contentString, marker) {
	  google.maps.event.addListener(marker, "click", function() {
		infowindow.setContent(contentString);
		infowindow.open(map, marker);
	  });
	}
	google.maps.event.addDomListener(window, "load", initialize);

	</script>';

	return implode('',$rtn);
}
*/
/////////////////////////////////////////////////
/////////////// FORMALIDADES ////////////////////
/////////////////////////////////////////////////
function formalidadeVPN($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_vpn="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FVPN-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = '<div id="formalidadesVPN-'.$id.'" name="1" class="sucess-check" onclick="dp.formalidades.formalidadeVPN(\''.$id.'\');"></div';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_vpn="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FVPN-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = '<div id="formalidadesVPN-'.$id.'" name="0" class="error-check" onclick="dp.formalidades.formalidadeVPN(\''.$id.'\');"></div>';
	}

	return implode('',$rtn);
}
function formalidadeAUSTRIA($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_austria="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FAUSTRIA-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = '<div id="formalidadesAUSTRIA-'.$id.'" name="1" class="sucess-check" onclick="dp.formalidades.formalidadeAUSTRIA(\''.$id.'\');"></div>';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_austria="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FAUSTRIA-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = '<div id="formalidadesAUSTRIA-'.$id.'" name="0" class="error-check" onclick="dp.formalidades.formalidadeAUSTRIA(\''.$id.'\');"></div>';
	}

	return implode('',$rtn);
}
function formalidadeENVIADO($id,$status) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;
	global $langmail;
	global $assinatura;

	if($status == 0) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_enviado="1" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FENV-ON","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$default	= $sql->fetch($sql->query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$id.'"'));
			if($default->formalidades_faturado_pdf != '') {





						//ENVIO DE MAIL P/ RESPONSAVEL
						$tecnico = mysql_fetch_array(mysql_query('SELECT * FROM processos WHERE id = "'.$id.'" '));
						$cliente = mysql_fetch_array(mysql_query('SELECT * FROM clientes WHERE id = "'.$tecnico['cliente_id'].'" '));
						//QUERY EMAILS
						$email1 = mysql_fetch_array(mysql_query('SELECT * FROM dc_admin WHERE id = "'.$tecnico['interno_responsavel'].'" '));
						//QUERY FILES
						$ficheiro = mysql_fetch_array(mysql_query('SELECT * FROM `files` WHERE id_processo = "'.$_POST['idprocessoFile'].'" AND `group`="2" AND status="1" ORDER BY id DESC '));

						$to      = array($email1['email']);
						$subject = 'Processo Concluido';
						$editado = str_replace('#PROCESSO',$tecnico['interno_processo'],$langmail['email_concluido']);
						$editado = str_replace('#FICHEIRO',' <a href="'.$base.'include/upload/'.$_POST['idprocessoFile'].'/'.$ficheiro['name'].'" target="_blank">'.$ficheiro['description'].'</a> ',$editado);
						$editado = str_replace('#CLIENTE',$cliente['nome'],$editado);
						$message .= $editado.$assinatura;
						echo sendEmail($to, $subject, $message);


				$query = $sql->query('UPDATE processos_tarefas SET estado="80" WHERE id_processo = "'.$id.'"');
			}
		$rtn[] = '<div id="formalidadesENVIADO-'.$id.'" name="1" class="sucess-check" onclick="dp.formalidades.formalidadeENVIADO(\''.$id.'\');"></div>';
	}
	if($status == 1) {
		$query = $sql->query('UPDATE processos_tarefas SET formalidades_enviado="0" WHERE id_processo = "'.$id.'"');
		$query = $sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("FENV-OFF","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$id.'")');
		$rtn[] = '<div id="formalidadesENVIADO-'.$id.'" name="0" class="error-check" onclick="dp.formalidades.formalidadeENVIADO(\''.$id.'\');"></div>';
	}

	return implode('',$rtn);
}
// EDITAR OBSERVAÇÕES NO MAPA
function gravarOBSmapa($id,$observacoes) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;

	$query = $sql->query('UPDATE processos SET interno_obs="'.utf8_decode($observacoes).'" WHERE id = "'.$id.'"');

	$rtn[] = '<span id="interno_obs">'.$observacoes.'</span>';

	return implode('',$rtn);
}
// ALTERAR AGENDAMENTO
function reAgendar($id,$processo){
	global $sql;
	global $admin;

	$processInfo 		= $sql->fetch($sql->query('SELECT * FROM processos WHERE `id` = "'.$processo.'"'));

	if($processInfo->interno_estado != '45') {
		$processInAgendamento = $sql->fetch($sql->query('SELECT COUNT(*) AS totalProcessos FROM processos WHERE `agendamento_id` = "'.$processInfo->agendamento_id.'"'));

		if($processInAgendamento->totalProcessos == 1) {
			$sql->query('DELETE FROM agendamentos WHERE id = "'.$processInfo->agendamento_id.'"');
		}

		$sql->query('UPDATE processos SET `interno_estado`="45", `agendamento_move_user`="'.$id.'", `agendamento_id`="0", `agendamento_confirmado`=NULL, `agendamento_hora`=NULL WHERE id = "'.$processo.'"');
		$sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("PT","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$processo.'")');
	} else {
		$sql->query('UPDATE processos SET `interno_estado`="60", `agendamento_id`="'.$id.'" WHERE id = "'.$processo.'"');
		$sql->query('INSERT INTO dc_historico (`action`,`data`,`hora`,`userid`,`id_processo`) VALUES ("PR","'.date('Y-m-d').'","'.date("H:i:s").'","'.$admin->id.'","'.$processo.'")');
	}

	return json_encode($total);
}
// ALERTAS DE VERIFICAÇÃO NO MOMENTO DA CRIAÇÃO DE NOVO AGENDAMENTO
function validaAgendamento($data,$equipa,$tecnicos){
	global $sql;
	global $lang;
	global $langvars;
	global $act;

	//$res = $sql->query('SELECT * FROM agendamentos WHERE data = "'.$data.'" AND equipa = "'.$equipa.'" ORDER BY `id` DESC');
	$res = $sql->query('SELECT * FROM agendamentos WHERE data = "'.$data.'" ORDER BY `id` DESC');
	while($agend = $sql->fetch($res)) {

		$tecnico1 	= $sql->fetch($sql->query('SELECT * FROM agendamentos WHERE (tecnico1 = "'.$tecnicos[0]['value'].'" OR tecnico2 = "'.$tecnicos[0]['value'].'" OR tecnico3 = "'.$tecnicos[0]['value'].'" OR tecnico4 = "'.$tecnicos[0]['value'].'") AND `id` = "'.$agend->id.'"'));
			if ( $tecnico1->tecnico1 == $tecnicos[0]['value'] ) { $teste[] = $tecnico1->tecnico1; $demo[] = $tecnico1->id; }
			if ( $tecnico1->tecnico2 == $tecnicos[0]['value'] ) { $teste[] = $tecnico1->tecnico2; $demo[] = $tecnico1->id; }
			if ( $tecnico1->tecnico3 == $tecnicos[0]['value'] ) { $teste[] = $tecnico1->tecnico3; $demo[] = $tecnico1->id; }
			if ( $tecnico1->tecnico4 == $tecnicos[0]['value'] ) { $teste[] = $tecnico1->tecnico4; $demo[] = $tecnico1->id; }

		if(!empty($tecnicos[1]['value'])) {
			$tecnico2 	= $sql->fetch($sql->query('SELECT * FROM agendamentos WHERE (tecnico1 = "'.$tecnicos[1]['value'].'" OR tecnico2 = "'.$tecnicos[1]['value'].'" OR tecnico3 = "'.$tecnicos[1]['value'].'" OR tecnico4 = "'.$tecnicos[1]['value'].'") AND `id` = "'.$agend->id.'"'));
				if ( $tecnico2->tecnico1 == $tecnicos[1]['value'] ) { $teste[] = $tecnico2->tecnico1; $demo[] = $tecnico2->id; }
				if ( $tecnico2->tecnico2 == $tecnicos[1]['value'] ) { $teste[] = $tecnico2->tecnico2; $demo[] = $tecnico2->id; }
				if ( $tecnico2->tecnico3 == $tecnicos[1]['value'] ) { $teste[] = $tecnico2->tecnico3; $demo[] = $tecnico2->id; }
				if ( $tecnico2->tecnico4 == $tecnicos[1]['value'] ) { $teste[] = $tecnico2->tecnico4; $demo[] = $tecnico2->id; }
		}

		if(!empty($tecnicos[2]['value'])) {
			$tecnico3 	= $sql->fetch($sql->query('SELECT * FROM agendamentos WHERE (tecnico1 = "'.$tecnicos[2]['value'].'" OR tecnico2 = "'.$tecnicos[2]['value'].'" OR tecnico3 = "'.$tecnicos[2]['value'].'" OR tecnico4 = "'.$tecnicos[2]['value'].'") AND `id` = "'.$agend->id.'"'));
				if ( $tecnico3->tecnico1 == $tecnicos[2]['value'] ) { $teste[] = $tecnico3->tecnico1; $demo[] = $tecnico3->id; }
				if ( $tecnico3->tecnico2 == $tecnicos[2]['value'] ) { $teste[] = $tecnico3->tecnico2; $demo[] = $tecnico3->id; }
				if ( $tecnico3->tecnico3 == $tecnicos[2]['value'] ) { $teste[] = $tecnico3->tecnico3; $demo[] = $tecnico3->id; }
				if ( $tecnico3->tecnico4 == $tecnicos[2]['value'] ) { $teste[] = $tecnico3->tecnico4; $demo[] = $tecnico3->id; }
		}

		if(!empty($tecnicos[3]['value'])) {
			$tecnico4 	= $sql->fetch($sql->query('SELECT * FROM agendamentos WHERE (tecnico1 = "'.$tecnicos[3]['value'].'" OR tecnico2 = "'.$tecnicos[3]['value'].'" OR tecnico3 = "'.$tecnicos[3]['value'].'" OR tecnico4 = "'.$tecnicos[3]['value'].'") AND `id` = "'.$agend->id.'"'));
				if ( $tecnico4->tecnico1 == $tecnicos[3]['value'] ) { $teste[] = $tecnico4->tecnico1; $demo[] = $tecnico4->id; }
				if ( $tecnico4->tecnico2 == $tecnicos[3]['value'] ) { $teste[] = $tecnico4->tecnico2; $demo[] = $tecnico4->id; }
				if ( $tecnico4->tecnico3 == $tecnicos[3]['value'] ) { $teste[] = $tecnico4->tecnico3; $demo[] = $tecnico4->id; }
				if ( $tecnico4->tecnico4 == $tecnicos[3]['value'] ) { $teste[] = $tecnico4->tecnico4; $demo[] = $tecnico4->id; }
		}

	}

	if(empty($teste) || empty($tecnicos)) {
		$rtn[] = '<input name="accept" type="checkbox" checked="checked" value="1" style="display:none;" />';
	} else {

		$testeprint = array_unique($teste);

		if (is_array($testeprint)) {
			foreach ($testeprint as $idTec) {

				$tecInfo 	= $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE `id` = "'.$idTec.'"'));
				$rtn[] = utf8_encode('<span style="color:#ff9900;">O <span style="text-transform:lowercase;">'.$langvars['perm_tecnico'].'</span> <b>'.$tecInfo->firstname.'</b> '.$langvars['global_seleccionado'].'.</span><br>');

				$equipInfo 	= $sql->fetch($sql->query('SELECT COUNT(*) AS equipaTecnicos FROM agendamentos WHERE `equipa` = "'.$equipa.'" AND (tecnico1 = "'.$idTec.'" OR tecnico2 = "'.$idTec.'" OR tecnico3 = "'.$idTec.'" OR tecnico4 = "'.$idTec.'")  AND data = "'.$data.'"'));

				if($equipInfo->equipaTecnicos == 0) {
					$carrinhaRTN[] = '';
				} else {
					$carInfo 	= $sql->fetch($sql->query('SELECT * FROM carrinhas WHERE `id` = "'.$equipa.'"'));
					$carrinhaRTN[] = utf8_encode('<br><span style="color:#ff9900;">A carrinha <b>'.$carInfo->descricao.'</b> '.$langvars['global_seleccionado'].'.</span><br>');
				}


			}
		}

		$carrinhaprint = array_unique($carrinhaRTN);

		$rtn[] = implode('',$carrinhaprint);

		$rtn[] = '<br><br>'.checkbox('accept','accept','1','','','Desejo guardar mesmo assim').'<br>';
	}

	return json_encode($rtn);
}
function popUpFicheiros($id,$area) {
	global $sql;
	global $generic;
	global $langvars;
	global $base;
	global $admin;
	global $langmail;
	global $assinatura;
	global $acesso;
	global $getPage;


	//$rtn[] = calendar();

	//$relatorio = $sql->query('SELECT * FROM relatorios_pending_list');
	//while($rel = $sql->fetch($relatorio)) {
		$idProcess = $sql->fetch($sql->query('SELECT * FROM processos WHERE id = "'.$id.'"'));
		$tRelInfo = $sql->fetch($sql->query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$idProcess->id.'" GROUP BY `id_processo`'));
		$procTasksEA 	= $sql->fetch($sql->query('SELECT COUNT(*) AS todastarefasEA FROM processos_tarefas WHERE id_tarefa="15" AND id_processo = "'.$idProcess->id.'"'));
		$formalidades 	= $sql->fetch($sql->query('SELECT * FROM processos_tarefas WHERE id_processo = "'.$idProcess->id.'"'));

		$rtn[] = '<div class="popUpBack" id="pUpBack-'.$idProcess->id.'" style="display:block"></div>';
		$rtn[] = '<div id="viewFiles-'.$idProcess->id.'" style="display:block" class="formularioPopUp">';
			$rtn[] = '<span class="cback-'.$idProcess->id.'" id="'.$idProcess->id.'" onclick="dp.calendario.uploadfilesClose(this);" style="position:absolute;right:20px;cursor:pointer;">';
				$rtn[] = '<img src="'.$base.'img/site/pop_sprite.png" />';
			$rtn[] = '</span>';
			$rtn[] = '<h0>'.$langvars['subtitle_anex'].'</h0>';
			$rtn[] = '<div class="line-title" style="margin-bottom:20px;"></div>';
			$rtn[] = '<table>';
				$rtn[] = '<tr>';
					$rtn[] = utf8_encode('<td id="listDOCS-'.$idProcess->id.'" class="'.$idProcess->id.'">'.listarProcessoDocs($idProcess->id).'</td>');
					$rtn[] = '<th class="border"></th>';
					$rtn[] = '<td>';
						$rtn[] = '<h2>UPLOAD DE FICHEIROS</h2>';
						$rtn[] = '<div class="line-subtitle" style="margin-bottom:20px;"></div>';
						$rtn[] = '<form class="filesCalendarUpload" id="filesCalendarUpload-'.$idProcess->id.'" method="POST" enctype="multipart/form-data" action>';

							//$rtn[] = '<input type="hidden" name="form[relatorio_estado]" value="2" />';
							$rtn[] = '<input type="hidden" name="action" value="uploadFiles" />';
							$rtn[] = '<input type="hidden" name="type" value="calendario" />';
							$rtn[] = '<input type="hidden" name="form[idprocesso]" value="'.$idProcess->id.'" />';
							$rtn[] = '<div class="error-box"></div>';

							if($area == 'reports') {
								$adminEstado = $acesso->tecnico == '1' ? 'NOT id = "5" AND NOT id = "1" AND NOT id = "3" AND NOT id = "4"' : 'NOT id = "5"';
								$rtn[] = utf8_encode('<p>'.$langvars['form_report_status'].'<select name="form[relatorio_estado]" class="select-pesq chosen-select " data-placeholder="'.$langvars['global_select'].'" tabindex="2">');
									$rtn[] = '<option></option>';
									$ress = $sql->query('SELECT * FROM relatorios_estado WHERE '.$adminEstado.' ORDER BY `id` DESC');
									while($status = $sql->fetch($ress)) {
										$rtn[] = utf8_encode('<option value="'.$status->id.'" '.($status->id == $tRelInfo->relatorio_tecnico_aprovado || $status->id == '2' ? 'selected' : '').'>'.$status->estado.'</option>');
									}
								$rtn[] = '</select></p>';
							}
							if($area == 'reports-pending') {
								$rtn[] = utf8_encode('<p>'.$langvars['form_report_status'].'<select name="form[relatorio_estado]" class="select-pesq chosen-select '.($acesso->tecnico == '1' ? '' : 'relatorio_estado').'" data-placeholder="'.$langvars['global_select'].'" tabindex="2">');
									$rtn[] = '<option></option>';
									$ress = $sql->query('SELECT * FROM relatorios_estado WHERE NOT id = "1" AND NOT id = "5" AND NOT id = "2" ORDER BY `id` DESC');
									while($status = $sql->fetch($ress)) {
										$rtn[] = utf8_encode('<option value="'.$status->id.'" '.($status->id == $tRelInfo->relatorio_tecnico_aprovado || $status->id == '4' ? 'selected' : '').'>'.$status->estado.'</option>');
									}
								$rtn[] = '</select></p>';
								$rtn[] = '<p id="relatorio_obs">';
									$rtn[] = '<textarea  class="textarea-task" name="form[relatorio_obs]" style="width: 100%; max-width: 96%;resize:none;">'.($tRelInfo->relatorio_obs ? $tRelInfo->relatorio_obs : '').'</textarea>';
								$rtn[] = '</p>';
								//if($tRelInfo->relatorio_obs != '') {
								//	$rtn[] = '<p>'.$tRelInfo->relatorio_obs.'</p>';
								//}
							}
							if($area == 'calendar') {
								$rtn[] = utf8_encode('<p>'.$langvars['form_report_status'].'<select name="form[relatorio_estado]" class="select-pesq chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2">');
									$rtn[] = '<option></option>';
									$ress = $sql->query('SELECT * FROM relatorios_estado WHERE NOT id = "5" ORDER BY `id` DESC');
									while($status = $sql->fetch($ress)) {
										$rtn[] = utf8_encode('<option value="'.$status->id.'" '.($status->id == $tRelInfo->relatorio_tecnico_aprovado ? 'selected' : '').'>'.$status->estado.'</option>');
									}
								$rtn[] = '</select></p>';
							}


							if($area == 'reports') {
							$rtn[] = utf8_encode('<p>'.$langvars['form_file_type'].'</p><select name="form[group]" class="select-pesq chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2">');
								$rtn[] = '<option></option>';
								$adminsFile = $admin->id != '9' ? ',"3"' : '';
								$res = $sql->query('SELECT * FROM files_groups WHERE id IN ("2"'.$adminsFile.')');
								while($filegroup = $sql->fetch($res)) {
									$selectOption = $_GET['page'] == 'reports' && $filegroup->id == '2' ? 'selected' : '';
									$rtn[] = utf8_encode('<option value="'.$filegroup->id.'" '.$selectOption.'>'.$filegroup->descricao.'</option>');
								}
							$rtn[] = '</select>';
							}
							if($area == 'reports-pending') {
								$rtn[] = utf8_encode(''.$langvars['form_file_type'].'<select name="form[group]" class="select-pesq chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2">');
									$rtn[] = '<option></option>';
									$res = $sql->query('SELECT * FROM files_groups WHERE id = "3"');
									while($filegroup = $sql->fetch($res)) {
										$selectOption = $_GET['page'] == 'reports-pending' && $filegroup->id == '3' ? 'selected' : '';
										$rtn[] = utf8_encode('<option value="'.$filegroup->id.'" '.$selectOption.'>'.$filegroup->descricao.'</option>');
									}
								$rtn[] = '</select>';
							}
							if($area == 'calendar') {
								$rtn[] = utf8_encode(''.$langvars['form_file_type'].'<select name="form[group]" class="select-pesq chosen-select" data-placeholder="'.$langvars['global_select'].'" tabindex="2">');
									$rtn[] = '<option></option>';
									$res = $sql->query('SELECT * FROM files_groups');
									while($filegroup = $sql->fetch($res)) {
										$rtn[] = utf8_encode('<option value="'.$filegroup->id.'">'.$filegroup->descricao.'</option>');
									}
								$rtn[] = '</select>';
							}

							$rtn[] = '<input type="file" name="files[]" id="filesuploadinput" style="margin-top:10px;" multiple />';

					if($acesso->formalidades == '1') {
						$rtn[] = '</br></br><h2>FORMALIDADES</h2>';
						$rtn[] = '<div class="line-subtitle" style="margin-bottom:0px;"></div>';

					$rtn[] = '<table class="process-detail">';
						$rtn[] = '<tr>';
							$rtn[] = '<td class="title-detail" style="padding:10px 0px;vertical-align:middle;">'.$langvars['calendar_vpn'].'</td>';
							$rtn[] = '<td style="padding:10px 0px;vertical-align:middle;">';


							if($procTasksEA->todastarefasEA == 0) { $rtn[] = '<div class="block-check" style="float: left;"></div>'; } else {
								if($formalidades->formalidades_vpn == 0) {
									$rtn[] = '<div id="VPN-'.$idProcess->id.'" style="float: left;"><div id="formalidadesVPN-'.$idProcess->id.'" name="0" class="error-check" style="float:left;" onclick="dp.formalidades.formalidadeVPN(\''.$idProcess->id.'\');"></div></div>';
									$logVPNOFF = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FVPN-OFF" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
									$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logVPNOFF->userid.'"'));
									$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logVPNOFF->data.'  '.$logVPNOFF->hora.'  '.$userName->firstname.'</span>';
								} else {
									$rtn[] = '<div id="VPN-'.$idProcess->id.'" style="float: left;"><div id="formalidadesVPN-'.$idProcess->id.'" name="1" class="sucess-check" style="float:left;" onclick="dp.formalidades.formalidadeVPN(\''.$idProcess->id.'\');"></div></div>';
									$logVPNON = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FVPN-ON" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
									$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logVPNON->userid.'"'));
									$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logVPNON->data.'  '.$logVPNON->hora.'  '.$userName->firstname.'</span>';
								}
							}
							$rtn[] = '
							</td>
						</tr>
						<tr>
							<td class="title-detail" style="padding:10px 0px;vertical-align:middle;">'.$langvars['calendar_tuv'].'</td>
							<td style="padding:10px 0px;vertical-align:middle;">';

							if($procTasksEA->todastarefasEA == 0) { $rtn[] = '<div class="block-check" style="float: left;"></div>'; } else {
								if($formalidades->formalidades_austria == 0) {
									$rtn[] = '<div id="AUSTRIA-'.$idProcess->id.'" style="float: left;"><div id="formalidadesAUSTRIA-'.$idProcess->id.'" name="0" class="error-check" style="float:left;" onclick="dp.formalidades.formalidadeAUSTRIA(\''.$idProcess->id.'\');"></div></div>';
									$logAUSTRIAOFF = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FAUSTRIA-OFF" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
									$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logAUSTRIAOFF->userid.'"'));
									$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logAUSTRIAOFF->data.'  '.$logAUSTRIAOFF->hora.'  '.$userName->firstname.'</span>';
								} else {
									$rtn[] = '<div id="AUSTRIA-'.$idProcess->id.'" style="float: left;"><div id="formalidadesAUSTRIA-'.$idProcess->id.'" name="1" class="sucess-check" style="float:left;" onclick="dp.formalidades.formalidadeAUSTRIA(\''.$idProcess->id.'\');"></div></div>';
									$logAUSTRIAON = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FAUSTRIA-ON" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
									$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logAUSTRIAON->userid.'"'));
									$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logAUSTRIAON->data.'  '.$logAUSTRIAON->hora.'  '.$userName->firstname.'</span>';
								}
							}
							$rtn[] = '
							</td>
						</tr>
						<tr>
							<td class="title-detail" style="padding:10px 0px;vertical-align:middle;">'.$langvars['calendar_faturado'].'</td>
							<td style="padding:10px 0px;vertical-align:middle;">';

							if($formalidades->formalidades_faturado_pdf == '') {
								$rtn[] = '<div id="formalidadesFATURADO-'.$idProcess->id.'" name="0" class="error-check" style="display:inline-block;float:left;cursor:auto;"></div>';
								$logFATURADOOFF = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FFAT-OFF" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
								$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logFATURADOOFF->userid.'"'));
								$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logFATURADOOFF->data.'  '.$logFATURADOOFF->hora.'  '.$userName->firstname.'</span>';
							} else {
								$rtn[] = '<div id="formalidadesFATURADO-'.$idProcess->id.'" name="1" class="sucess-check" style="display:inline-block;float:left;cursor:auto;"></div>';
								$logFATURADOON = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FFAT-ON" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
								$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logFATURADOON->userid.'"'));
								$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logFATURADOON->data.'  '.$logFATURADOON->hora.'  '.$userName->firstname.'</span>';
							}
							$rtn[] = utf8_encode('
							</td>
						</tr>
						<tr>
							<td class="title-detail" style="padding:10px 0px;vertical-align:middle;">'.$langvars['calendar_fatura'].'</td>
							<!--<td><?=$formalidades->formalidades_faturado_pdf?></td>-->
							<td style="padding:10px 0px;vertical-align:middle;">'.text_input('form[formalidades_faturado_pdf]',($formalidades ? $formalidades->formalidades_faturado_pdf : ''),'','').'</td>
						</tr>
						<tr>
							<td class="title-detail" style="padding:10px 0px;vertical-align:middle;">'.$langvars['calendar_enviado'].'</td>
							<td style="padding:10px 0px;vertical-align:middle;">
							');
							if($formalidades->formalidades_enviado == 0) {
								$rtn[] = '<div id="ENVIADO-'.$idProcess->id.'" style="float: left;"><div id="formalidadesENVIADO-'.$idProcess->id.'" name="0" class="error-check" style="display:inline-block;float:left;" onclick="dp.formalidades.formalidadeENVIADO(\''.$idProcess->id.'\');"></div></div>';
								$logENVIADOOFF = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FENV-OFF" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
								$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logENVIADOOFF->userid.'"'));
								$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logENVIADOOFF->data.'  '.$logENVIADOOFF->hora.'  '.$userName->firstname.'</span>';
							} else {
								$rtn[] = '<div id="ENVIADO-'.$idProcess->id.'" style="float: left;"><div id="formalidadesENVIADO-'.$idProcess->id.'" name="1" class="sucess-check" style="display:inline-block;float:left;" onclick="dp.formalidades.formalidadeENVIADO(\''.$idProcess->id.'\');"></div></div>';
								$logENVIADOON = $sql->fetch($sql->query('SELECT * FROM dc_historico WHERE action="FENV-ON" AND id_processo = "'.$idProcess->id.'" ORDER BY `id` DESC LIMIT 1'));
								$userName = $sql->fetch($sql->query('SELECT * FROM dc_admin WHERE id="'.$logENVIADOON->userid.'"'));
								$rtn[] = '<span style="opacity:0.4;padding-left:5px;vertical-align:text-bottom;">'.$logENVIADOON->data.'  '.$logENVIADOON->hora.'  '.$userName->firstname.'</span>';
							}
							$rtn[] = '
							</td>
						</tr>
						</table>
						</br>';
						 }

							$rtn[] = '<p style="padding-bottom:15px;">';
								$rtn[] = '<input style="float:right;" type="submit" class="butao-save" value="Guardar" />';
							$rtn[] = '</p>';
							$rtn[] = '<script type="text/javascript">dp.calendario.uploadfiles(\''.$idProcess->id.'\');</script>';
						$rtn[] = '</form>';
					$rtn[] = '</td>';
				$rtn[] = '</tr>';
			$rtn[] = '</table>';
		$rtn[] = '</div>';
	//}

	return implode('',$rtn);
}



function prelatorio($id,$obs,$state)
{
	global $sql;
	global $admin;

	$date = date('Y-m-d H:i:s');
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=".$state." WHERE `IDGDProcesso`='".$id."' ");

	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",124,'.$state.','.$admin->codExterno.',"'.$obs.'","","","")');
	return "UPDATE `processos` SET `IDWorkFlowState`=103 WHERE `IDGDProcesso`='".$id."' ";
}

function pavancar($id)
{
	global $sql;
	global $admin;
	global $base;
	$date = date('Y-m-d H:i:s');
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=124 WHERE `IDGDProcesso`='".$id."' ");
	$proc_code=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));
	$tr = $sql->query('SELECT * FROM  `intervenientes` WHERE `status`!=2 AND `id_processo`="' . $id . '"');
	while($target=$sql->fetch($tr))
	{
		$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",' . $id . ' ,"' . $target->id_user . '","' . $date . '","J&#225; possui os documentos para prosseguir na Avalia&ccedil;&atilde;o <a href='.$base.'process/'.$id.'>'.$proc_code->Referencia.'</a>" ,0,3)');

	}
  $dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",' .$id. ' ,"' .$admin->codExterno . '","' . $date . '","J&#225; possui os documentos para prosseguir na Avalia&ccedil;&atilde;o <a href='.$base.'process/'.$id.'>'.$proc_code->Referencia.'</a>" ,0,17)');


	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",121,124,'.$admin->codExterno.',"","","","")');
	return "UPDATE `processos` SET `IDWorkFlowState`=103 WHERE `IDGDProcesso`='".$id."' ";
}

function pagendarVisita($id,$obs,$data,$hora,$types)
{
	global $sql;
	global $admin;
	global $base;
	$date = date('Y-m-d H:i:s');
	if($types){
		foreach ($types as $value) {
			$obs .= " | ".$value." | ";
		}
	}
	$tt=utf8_encode($obs);
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=107, `DataVisita`='".$data." ".$hora."' WHERE `IDGDProcesso`='".$id."' ");
	$str="Visita marcada para o dia ".$data.", &agrave;s ".$hora." - ".$tt;
	//$str=utf8_encode($str);
	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",106,107,'.$admin->codExterno.',"'.utf8_decode($str).'","","","")');

	$gestor=$sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=2');
	$processo=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'" '));
	while($g=$sql->fetch($gestor))
	{
		$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",' . $id . ' ,"' . $g->id_user . '","' . $date . '","A visita da Avalia&ccedil;&atilde;o <a href='.$base.'process/'.$id . '>'.$processo->Referencia.'</a> foi marcada para o dia '.$data.' &#224;s '.$hora.'-'.$obs.'",0,9)');
//		echo 'INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",' . $id . ' ,"' . $g->id_user . '","' . $date . '","A visita da Avalia&ccedil;&atilde;o <a href='.$base.'process/'.$id . '>'.$processo->Referencia.'</a> foi marcada para o dia '.$data.' &#224;s '.$hora.'-'.$obs.'",0,9)';
	}


}
/*function pagendarVisitaToPendente($id,$obs,$data,$hora,$types)
{
	global $sql;
	global $admin;
	global $base;
	$date = date('Y-m-d H:i:s');
	if($types){
		foreach ($types as $value) {
			$obs .= " | ".$value." | ";
		}
	}
	$tt=utf8_encode($obs);
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=145 WHERE `IDGDProcesso`='".$id."' ");
	$str="Visita não foi marcada.".$tt;
	//$str=utf8_encode($str);
	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",106,145,'.$admin->codExterno.',"'.utf8_decode($str).'","","","")');

}*/


function pagendarVisitaToPendente($id,$obs,$data,$hora,$types)
{
	global $sql;
	global $admin;
	global $base;
	$processo=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'" '));

	$date = date('Y-m-d H:i:s');
	if($types){
		foreach ($types as $value) {
			$obs .= " | ".$value." | ";
		}
	}
	$tt=utf8_encode($obs);
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=145 WHERE `IDGDProcesso`='".$id."' ");
	$str=$tt;
	//$str=utf8_encode($str);
	$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",' . $id . ' ,"' . $admin->codExterno . '","' . $date . '","A visita da Avalia&ccedil;&atilde;o <a href='.$base.'process/'.$id . '>'.$processo->Referencia.'</a> não foi marcada. '.utf8_decode($str).'",0,9)');
	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",106,145,'.$admin->codExterno.',"'.utf8_decode($str).'","","","")');



}


function pagendarVisitaPendente($id,$obs,$data,$hora,$types)
{
	global $sql;
	global $admin;
	global $base;
	$date = date('Y-m-d H:i:s');
	if($types){
		foreach ($types as $value) {
			$obs .= " | ".$value." | ";
		}
	}
	$tt=utf8_encode($obs);
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=107, `DataVisita`='".$data." ".$hora."' WHERE `IDGDProcesso`='".$id."' ");
	$str="Visita marcada para o dia ".$data.", &agrave;s ".$hora." - ".$tt;
	//$str=utf8_encode($str);
	$processo=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'" '));
	$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",' . $id . ' ,"' .$admin->codExterno. '","' . $date . '","A visita da Avalia&ccedil;&atilde;o <a href='.$base.'process/'.$id . '>'.$processo->Referencia.'</a> foi marcada para o dia '.$data.' &#224;s '.$hora.'-'.utf8_decode($obs).'",0,9)');
	
$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",145,107,'.$admin->codExterno.',"'.utf8_decode($str).'","","","")');




}
function pcheckvisita($id,$obs,$state)
{
	global $sql;
	global $admin;
	$date = date('Y-m-d H:i:s');
  $obs.= " | ";
	if($_POST['types']){
		foreach ($_POST['types'] as $value) {
			$obs .= $value." | ";
		}
	}
	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=".$state." WHERE `IDGDProcesso`='".$id."' ");

	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",107,'.$state.','.$admin->codExterno.',"'.$obs.'","","","")');



	return "UPDATE `processos` SET `IDWorkFlowState`=103 WHERE `IDGDProcesso`='".$id."' ";
}
function pregressaestado($id,$obs,$retun,$state,$coord,$area1,$area2,$avalimovel)
{
	global $sql;
	global $admin;
	global $base;
  global $langvars;
	$date = date('Y-m-d H:i:s');
  $proc_code=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));

	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=".$retun." WHERE `IDGDProcesso`='".$id."' ");
	//$query=$sql->query("UPDATE `processos` SET `DataConclusao`='".$date."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `coord`='".$coord."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `area1`='".$area1."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `area2`='".$area2."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `avaliacaoimovel`='".$avalimovel."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `avaliacaoimovel`='".$avalimovel."' WHERE `IDGDProcesso`='".$id."' ");

	$query=$sql->query("UPDATE `processos` SET `valorfatura`='".($avalimovel - $proc_code->valorfatura2)."' WHERE `IDGDProcesso`='".$id."' ");

	$date=date("Y-m-d");
	$proc_code=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));
	$target=$sql->query('SELECT * FROM  `intervenientes` WHERE `tipo_user`=1 AND `id_processo`="'.$id.'" AND `status`=1');
	while($inter=$sql->fetch($target)){
		if($retun==124){
			$str="O relat&#243;rio do processo <a href=".$base."process/".$id."> ".$proc_code->Referencia."</a> precisa de retifica&#231;&#245;es. ".$obs." ";
			$msg=utf8_decode($str);
			$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",'.$id.' ,"'.$inter->id_user.'","'.$date.'","'.$msg.'",0,5)');

		}
		if($retun==121){
			$str="O processo <a href=".$base."process/".$id."> ".$proc_code->Referencia."</a> precisa de mais documentos. ".$obs." ";
			$msg=utf8_decode($str);
			$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",'.$id.' ,"'.$inter->id_user.'","'.$date.'","'.$msg.'",0,6)');

		}
	}
$date = date('Y-m-d H:i:s');
	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",'.$state.','.$retun.','.$admin->codExterno.',"'.$obs.'","","","")');



/*STAT FILL*/
$processo = $sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));
$intervenientes_gestor = $sql->fetch($sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=2'));
$intervenientes_avaliador = $sql->fetch($sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=1 AND `status`!=2'));
$query_1 = $sql->fetch($sql->query('SELECT * FROM `GDProcessoTipo` WHERE `IDGDProcessoTipo`="'.$processo->IDGDProcessoTipo.'"'));
$query_2 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `IdUser`="'.$processo->IDEntidade.'"'));
$query_3 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `CodUser`="'.$intervenientes_gestor->id_user.'"'));
$query_4 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `CodUser`="'.$intervenientes_avaliador->id_user.'"'));
$query_5 = $sql->fetch($sql->query('SELECT * FROM `WebParish` WHERE `IDWebParish`="'.$processo->idWebParish.'"'));
$query_6 = $sql->fetch($sql->query('SELECT * FROM `WebMunicipality` WHERE `IDWebMunicipality`="'.$processo->CodConcelho.'"'));
$query_7 = $sql->fetch($sql->query('SELECT * FROM `distritos` WHERE `codDistrito`="'.$processo->idWebDistrict.'"'));

/*CLASS MEDIA*/
$filecontrol=$sql->query('SELECT * FROM `file_control` WHERE `process`="'.$id.'" AND `score`!=6 AND `score`!=0 AND `hon`>0');
$score=0;
$conta="";
$hon=0;
$n=0;
while($file=$sql->fetch($filecontrol))
{

  $score+=$file->score;
  $hon+=$file->hon;
  $n++;
}
if($n>0)
$score=$score/$n;
if($score>=0)
$a = number_format($score,2);
else
$a = 0;
/*---------*/

/*DIAS DO PROCESSO*/

$workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'"');
$first=true;

while ($work=$sql->fetch($workflow)) {
  if($first)
  {
    $datetime1=strtotime($work->workflowdate);
    $first=false;
  }
  else {
    $datetime2=strtotime($work->workflowdate);
  }
}

$interval = $datetime2-$datetime1;
if($interval>=0)
$b= floor($interval/(60*60*24))."</td>";
else
$b=0;

/*--------*/

/*n_dias_agendar*/
$datetime1="";
$datetime2="";

$interval=0;
$workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=106');
$from=array();
while($work=$sql->fetch($workflow))
{
  array_push($from,strtotime($work->workflowdate));
}
$workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=106');
$to=array();
while($work=$sql->fetch($workflow))
{
  array_push($to,strtotime($work->workflowdate));
}
$n=0;
foreach ($from as $value) {
    $interval += $to[$n] - $value;
    $n++;
}
if($interval>=0)
$c = floor($interval/(60*60*24));
else
$c = 0;
/*-------*/

$interval=0;

/*n_dias_visita*/
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=116');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=116');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
        $n=0;
        foreach ($from as $value) {
            $interval += $to[$n] - $value;
            $n++;
        }
        if($interval>0)
        $d = floor($interval/(60*60*24));
        else
        $d = 0;
/*--------*/
/*n_dias_aguarda*/
$interval=0;

        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=121');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=121');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
        $n=0;
        foreach ($from as $value) {
            $interval += $to[$n] - $value;
            $n++;
        }
        if($interval>=0)
        $e = floor($interval/(60*60*24));
        else
      $e = 0;

/*--------*/

$aguardou=$langvars['warning-no'];
if(floor($interval/(60*60*24)))
{
$aguardou=$langvars['warning-yes'];
}

/*n_dias_relatorio*/
$interval=0;
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=124');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=124');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
        $n=0;
        foreach ($from as $value) {
            $interval += $to[$n] - $value;
            $n++;
        }
        $f = floor($interval/(60*60*24));
/*--------*/

/*n_dias_avaliacao*/
$interval=0;


        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=127');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=127');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
    $n=0;
  foreach ($from as $value) {
    $interval += $to[$n] - $value;
    $n++;
}
$g = $interval/(60*60*24);

/*--------*/

$class_media = $a;
$n_dias_processo = $b;
$n_dias_agendar = $c;
$n_dias_visita = $d;
$n_dias_aguarda = $e;
$n_dias_relatorio = $f;
$n_dias_avaliacao = $g;
$tipo_processo = $query_1->CODGDProcessoTipo;
$data_entrada = $processo->DataEntrada;
$cliente = $query_2->Fullname;
$gestor = $query_3->Username;
$avaliador = $query_4->Username;
$data_visita = $processo->DataVisita;
$aguardou_elementos = $aguardou;
$data_conclusao = $processo->DataConclusao;
$distrito = $query_7->Distrito;
$concelho = $query_6->WebMunicipality;
$freguesia = $query_5->WebParish;
$soma_honorarios = $hon;

$data_controlo_t = $processo->data_cliente;
$dconc = strtotime($data_conclusao);
$dcont = strtotime($data_controlo_t);
$cInterval = $dcont - $dconc;
$data_controlo = floor($cInterval/(60*60*24));
if($data_controlo<0)
$data_controlo = 0;


$sql->query('INSERT INTO `stats_pessoais` (n_dias_controlo,`class_media`,`n_dias_processo`,`n_dias_agendar`,`n_dias_visita`,`n_dias_aguarda`,`n_dias_relatorio`,`n_dias_avaliacao`,`tipo_processo`,`data_entrada`,`cliente`,`gestor`,`avaliador`,`data_visita`,`aguardou_elementos`,`data_conclusao`,`distrito`,`concelho`,`freguesia`,`soma_honorarios`,`processo`) VALUES ("'.$data_controlo.'","'.$class_media.'","'.$n_dias_processo.'","'.$n_dias_agendar.'","'.$n_dias_visita.'","'.$n_dias_aguarda.'","'.$n_dias_relatorio.'","'.$n_dias_avaliacao.'","'.$tipo_processo.'","'.$data_entrada.'","'.$cliente.'","'.$gestor.'","'.$avaliador.'","'.$data_visita.'","'.$aguardou_elementos.'","'.$data_conclusao.'","'.$distrito.'","'.$concelho.'","'.$freguesia.'","'.$soma_honorarios.'","'.$id.'")');
/*STAT FILL*/
}
function pregressaestado2($id,$obs,$retun,$state,$area1,$area2,$avalimovel)
{
	global $sql;
	global $admin;
	global $base;
  global $langvars;
	$date = date('Y-m-d H:i:s');
  $proc_code=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));

	$query=$sql->query("UPDATE `processos` SET `IDWorkFlowState`=".$retun." WHERE `IDGDProcesso`='".$id."' ");
	//$query=$sql->query("UPDATE `processos` SET `DataConclusao`='".$date."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `area1`='".$area1."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `area2`='".$area2."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `avaliacaoimovel`='".$avalimovel."' WHERE `IDGDProcesso`='".$id."' ");
	$query=$sql->query("UPDATE `processos` SET `avaliacaoimovel`='".$avalimovel."' WHERE `IDGDProcesso`='".$id."' ");
//	$query=$sql->query("UPDATE `processos` SET `valorfatura`='".$avalimovel."' WHERE `IDGDProcesso`='".$id."' ");
  $query=$sql->query("UPDATE `processos` SET `valorfatura`='".($avalimovel - $proc_code->valorfatura2)."' WHERE `IDGDProcesso`='".$id."' ");

	$date=date("Y-m-d");
	$proc_code=$sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));
	$target=$sql->query('SELECT * FROM  `intervenientes` WHERE `tipo_user`=1 AND `id_processo`="'.$id.'" AND `status`=1');
	while($inter=$sql->fetch($target)){
		if($retun==124){
			$str="O relat&#243;rio do processo <a href=".$base."process/".$id."> ".$proc_code->Referencia."</a> precisa de retifica&#231;&#245;es. ".$obs." ";
			$msg=utf8_decode($str);
			$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",'.$id.' ,"'.$inter->id_user.'","'.$date.'","'.$msg.'",0,5)');

		}
		if($retun==121){
			$str="O processo <a href=".$base."process/".$id."> ".$proc_code->Referencia."</a> precisa de mais documentos. ".$obs." ";
			$msg=utf8_decode($str);
			$dachange = $sql->query('INSERT INTO `alertas`(`created_by`,`processo_id`,`user_id`, `data`, `message`, `lido`,`type`) VALUES ("'.$admin->codExterno.'",'.$id.' ,"'.$inter->id_user.'","'.$date.'","'.$msg.'",0,6)');

		}
	}
$date = date('Y-m-d H:i:s');
	$dachange = $sql->query('INSERT INTO `GDProcessoWorkflow`(`idgdprocesso`, `workflowdate`, `idfrom`, `idto`, `iduser`, `comentario`, `dias`, `isrollback`, `Rollbacked`) VALUES ('.$id.' ,"'.$date.'",'.$state.','.$retun.','.$admin->codExterno.',"'.$obs.'","","","")');



/*STAT FILL*/
$processo = $sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));
$intervenientes_gestor = $sql->fetch($sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=2'));
$intervenientes_avaliador = $sql->fetch($sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=1 AND `status`!=2'));
$query_1 = $sql->fetch($sql->query('SELECT * FROM `GDProcessoTipo` WHERE `IDGDProcessoTipo`="'.$processo->IDGDProcessoTipo.'"'));
$query_2 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `IdUser`="'.$processo->IDEntidade.'"'));
$query_3 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `CodUser`="'.$intervenientes_gestor->id_user.'"'));
$query_4 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `CodUser`="'.$intervenientes_avaliador->id_user.'"'));
$query_5 = $sql->fetch($sql->query('SELECT * FROM `WebParish` WHERE `IDWebParish`="'.$processo->idWebParish.'"'));
$query_6 = $sql->fetch($sql->query('SELECT * FROM `WebMunicipality` WHERE `IDWebMunicipality`="'.$processo->CodConcelho.'"'));
$query_7 = $sql->fetch($sql->query('SELECT * FROM `distritos` WHERE `codDistrito`="'.$processo->idWebDistrict.'"'));

/*CLASS MEDIA*/
$filecontrol=$sql->query('SELECT * FROM `file_control` WHERE `process`="'.$id.'" AND `score`!=6 AND `score`!=0 AND `hon`>0');
$score=0;
$conta="";
$hon=0;
$n=0;
while($file=$sql->fetch($filecontrol))
{

  $score+=$file->score;
  $hon+=$file->hon;
  $n++;
}
if($n>0)
$score=$score/$n;
if($score>=0)
$a = number_format($score,2);
else
$a = 0;
/*---------*/

/*DIAS DO PROCESSO*/

$workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'"');
$first=true;

while ($work=$sql->fetch($workflow)) {
  if($first)
  {
    $datetime1=strtotime($work->workflowdate);
    $first=false;
  }
  else {
    $datetime2=strtotime($work->workflowdate);
  }
}

$interval = $datetime2-$datetime1;
if($interval>=0)
$b= floor($interval/(60*60*24))."</td>";
else
$b=0;

/*--------*/

/*n_dias_agendar*/
$datetime1="";
$datetime2="";

$interval=0;
$workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=106');
$from=array();
while($work=$sql->fetch($workflow))
{
  array_push($from,strtotime($work->workflowdate));
}
$workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=106');
$to=array();
while($work=$sql->fetch($workflow))
{
  array_push($to,strtotime($work->workflowdate));
}
$n=0;
foreach ($from as $value) {
    $interval += $to[$n] - $value;
    $n++;
}
if($interval>=0)
$c = floor($interval/(60*60*24));
else
$c = 0;
/*-------*/

$interval=0;

/*n_dias_visita*/
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=116');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=116');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
        $n=0;
        foreach ($from as $value) {
            $interval += $to[$n] - $value;
            $n++;
        }
        if($interval>0)
        $d = floor($interval/(60*60*24));
        else
        $d = 0;
/*--------*/
/*n_dias_aguarda*/
$interval=0;

        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=121');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=121');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
        $n=0;
        foreach ($from as $value) {
            $interval += $to[$n] - $value;
            $n++;
        }
        if($interval>=0)
        $e = floor($interval/(60*60*24));
        else
      $e = 0;

/*--------*/

$aguardou=$langvars['warning-no'];
if(floor($interval/(60*60*24)))
{
$aguardou=$langvars['warning-yes'];
}

/*n_dias_relatorio*/
$interval=0;
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=124');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=124');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
        $n=0;
        foreach ($from as $value) {
            $interval += $to[$n] - $value;
            $n++;
        }
        $f = floor($interval/(60*60*24));
/*--------*/

/*n_dias_avaliacao*/
$interval=0;


        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=127');
        $from=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($from,strtotime($work->workflowdate));
        }
        $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=127');
        $to=array();
        while($work=$sql->fetch($workflow))
        {
          array_push($to,strtotime($work->workflowdate));
        }
    $n=0;
  foreach ($from as $value) {
    $interval += $to[$n] - $value;
    $n++;
}
$g = $interval/(60*60*24);

/*--------*/

$class_media = $a;
$n_dias_processo = $b;
$n_dias_agendar = $c;
$n_dias_visita = $d;
$n_dias_aguarda = $e;
$n_dias_relatorio = $f;
$n_dias_avaliacao = $g;
$tipo_processo = $query_1->CODGDProcessoTipo;
$data_entrada = $processo->DataEntrada;
$cliente = $query_2->Fullname;
$gestor = $query_3->Username;
$avaliador = $query_4->Username;
$data_visita = $processo->DataVisita;
$aguardou_elementos = $aguardou;
$data_conclusao = $processo->DataConclusao;
$distrito = $query_7->Distrito;
$concelho = $query_6->WebMunicipality;
$freguesia = $query_5->WebParish;
$soma_honorarios = $hon;

$data_controlo_t = $processo->data_cliente;
$dconc = strtotime($data_conclusao);
$dcont = strtotime($data_controlo_t);
$cInterval = $dcont - $dconc;
$data_controlo = floor($cInterval/(60*60*24));
if($data_controlo<0)
$data_controlo = 0;


$sql->query('INSERT INTO `stats_pessoais` (n_dias_controlo,`class_media`,`n_dias_processo`,`n_dias_agendar`,`n_dias_visita`,`n_dias_aguarda`,`n_dias_relatorio`,`n_dias_avaliacao`,`tipo_processo`,`data_entrada`,`cliente`,`gestor`,`avaliador`,`data_visita`,`aguardou_elementos`,`data_conclusao`,`distrito`,`concelho`,`freguesia`,`soma_honorarios`,`processo`) VALUES ("'.$data_controlo.'","'.$class_media.'","'.$n_dias_processo.'","'.$n_dias_agendar.'","'.$n_dias_visita.'","'.$n_dias_aguarda.'","'.$n_dias_relatorio.'","'.$n_dias_avaliacao.'","'.$tipo_processo.'","'.$data_entrada.'","'.$cliente.'","'.$gestor.'","'.$avaliador.'","'.$data_visita.'","'.$aguardou_elementos.'","'.$data_conclusao.'","'.$distrito.'","'.$concelho.'","'.$freguesia.'","'.$soma_honorarios.'","'.$id.'")');
/*STAT FILL*/
}

function statfill($id)
{
  global $sql;
  global $langvars;
  global $admin;
  global $base;
  /*STAT FILL*/
  $processo = $sql->fetch($sql->query('SELECT * FROM `processos` WHERE `IDGDProcesso`="'.$id.'"'));
  $intervenientes_gestor = $sql->fetch($sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=2'));
  $intervenientes_avaliador = $sql->fetch($sql->query('SELECT * FROM `intervenientes` WHERE `id_processo`="'.$id.'" AND `tipo_user`=1 AND `status`!=2'));
  $query_1 = $sql->fetch($sql->query('SELECT * FROM `GDProcessoTipo` WHERE `IDGDProcessoTipo`="'.$processo->IDGDProcessoTipo.'"'));
  $query_2 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `IdUser`="'.$processo->IDEntidade.'"'));
  $query_3 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `CodUser`="'.$intervenientes_gestor->id_user.'"'));
  $query_4 = $sql->fetch($sql->query('SELECT * FROM `nrUser` WHERE `CodUser`="'.$intervenientes_avaliador->id_user.'"'));
  $query_5 = $sql->fetch($sql->query('SELECT * FROM `WebParish` WHERE `IDWebParish`="'.$processo->idWebParish.'"'));
  $query_6 = $sql->fetch($sql->query('SELECT * FROM `WebMunicipality` WHERE `IDWebMunicipality`="'.$processo->CodConcelho.'"'));
  $query_7 = $sql->fetch($sql->query('SELECT * FROM `distritos` WHERE `codDistrito`="'.$processo->idWebDistrict.'"'));

  /*CLASS MEDIA*/
  $filecontrol=$sql->query('SELECT * FROM `file_control` WHERE `process`="'.$id.'" AND `score`!=6 AND `score`!=0 AND `hon`>0');
  $score=0;
  $conta="";
  $hon=0;
  $n=0;
  while($file=$sql->fetch($filecontrol))
  {

    $score+=$file->score;
    $hon+=$file->hon;
    $n++;
  }
  if($n>0)
  $score=$score/$n;
  if($score>=0)
  $a = number_format($score,2);
  else
  $a = 0;
  /*---------*/

  /*DIAS DO PROCESSO*/

  $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'"');
  $first=true;

  while ($work=$sql->fetch($workflow)) {
    if($first)
    {
      $datetime1=strtotime($work->workflowdate);
      $first=false;
    }
    else {
      $datetime2=strtotime($work->workflowdate);
    }
  }

  $interval = $datetime2-$datetime1;
  if($interval>=0)
  $b= floor($interval/(60*60*24))."</td>";
  else
  $b=0;

  /*--------*/

  /*n_dias_agendar*/
  $datetime1="";
  $datetime2="";

  $interval=0;
  $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=106');
  $from=array();
  while($work=$sql->fetch($workflow))
  {
    array_push($from,strtotime($work->workflowdate));
  }
  $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=106');
  $to=array();
  while($work=$sql->fetch($workflow))
  {
    array_push($to,strtotime($work->workflowdate));
  }
  $n=0;
  foreach ($from as $value) {
      $interval += $to[$n] - $value;
      $n++;
  }
  if($interval>=0)
  $c = floor($interval/(60*60*24));
  else
  $c = 0;
  /*-------*/

  $interval=0;

  /*n_dias_visita*/
          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=116');
          $from=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($from,strtotime($work->workflowdate));
          }
          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=116');
          $to=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($to,strtotime($work->workflowdate));
          }
          $n=0;
          foreach ($from as $value) {
              $interval += $to[$n] - $value;
              $n++;
          }
          if($interval>0)
          $d = floor($interval/(60*60*24));
          else
          $d = 0;
  /*--------*/
  /*n_dias_aguarda*/
  $interval=0;

          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=121');
          $from=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($from,strtotime($work->workflowdate));
          }
          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=121');
          $to=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($to,strtotime($work->workflowdate));
          }
          $n=0;
          foreach ($from as $value) {
              $interval += $to[$n] - $value;
              $n++;
          }
          if($interval>=0)
          $e = floor($interval/(60*60*24));
          else
        $e = 0;

  /*--------*/

  $aguardou=$langvars['warning-no'];
  if(floor($interval/(60*60*24)))
  {
  $aguardou=$langvars['warning-yes'];
  }

  /*n_dias_relatorio*/
  $interval=0;
          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=124');
          $from=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($from,strtotime($work->workflowdate));
          }
          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=124');
          $to=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($to,strtotime($work->workflowdate));
          }
          $n=0;
          foreach ($from as $value) {
              $interval += $to[$n] - $value;
              $n++;
          }
          $f = floor($interval/(60*60*24));
  /*--------*/

  /*n_dias_avaliacao*/
  $interval=0;


          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idto`=127');
          $from=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($from,strtotime($work->workflowdate));
          }
          $workflow = $sql->query('SELECT * FROM  `GDProcessoWorkflow` WHERE  `idgdprocesso` ="'.$id.'" AND `idfrom`=127');
          $to=array();
          while($work=$sql->fetch($workflow))
          {
            array_push($to,strtotime($work->workflowdate));
          }
      $n=0;
    foreach ($from as $value) {
      $interval += $to[$n] - $value;
      $n++;
  }
  $g = $interval/(60*60*24);

  /*--------*/
/*Data de conclusao*/
$dataConclusao = $sql->fetch($sql->query('SELECT * FROM GDProcessoWorkflow WHERE idgdprocesso="'.$id.'" and idto="131" and idfrom!="131" ORDER BY id DESC LIMIT 1'));
$data_conclusao = $processo->DataConclusao;
$data_conclusao = $dataConclusao->workflowdate;
/*Data de controlo*/
$data_controlo_t = $processo->data_cliente;
$dconc = strtotime($data_conclusao);
$dcont = strtotime($data_controlo_t);
$cInterval = $dcont - $dconc;
$data_controlo = floor($cInterval/(60*60*24));
if($data_controlo<0)
$data_controlo = 0;
/*Data limite*/
$data_limite_t = $processo->DataLimite;
$dlim = strtotime($data_limite_t);
$cInterval = $dconc - $dlim;
$data_limite = floor($cInterval/(60*60*24));
if($data_limite<0)
$data_limite = 0;
  /*-------*/

  $class_media = $a;
  $n_dias_processo = $b;
  $n_dias_agendar = $c;
  $n_dias_visita = $d;
  $n_dias_aguarda = $e;
  $n_dias_relatorio = $f;
  $n_dias_avaliacao = $g;
  $tipo_processo = $query_1->CODGDProcessoTipo;
  $data_entrada = $processo->DataEntrada;
  $cliente = $query_2->Fullname;
  $gestor = $query_3->Username;
  $avaliador = $query_4->Username;
  $data_visita = $processo->DataVisita;
  $aguardou_elementos = $aguardou;
  $distrito = $query_7->Distrito;
  $concelho = $query_6->WebMunicipality;
  $freguesia = $query_5->WebParish;
  $soma_honorarios = $hon;
  $sql->query('INSERT INTO `stats_pessoais` (`class_media`,`n_dias_limite`,`n_dias_controlo`,`n_dias_processo`,`n_dias_agendar`,`n_dias_visita`,`n_dias_aguarda`,`n_dias_relatorio`,`n_dias_avaliacao`,`tipo_processo`,`data_entrada`,`cliente`,`gestor`,`avaliador`,`data_visita`,`aguardou_elementos`,`data_conclusao`,`distrito`,`concelho`,`freguesia`,`soma_honorarios`,`processo`) VALUES ("'.$class_media.'","'.$data_limite.'","'.$data_controlo.'","'.$n_dias_processo.'","'.$n_dias_agendar.'","'.$n_dias_visita.'","'.$n_dias_aguarda.'","'.$n_dias_relatorio.'","'.$n_dias_avaliacao.'","'.$tipo_processo.'","'.$data_entrada.'","'.$cliente.'","'.$gestor.'","'.$avaliador.'","'.$data_visita.'","'.$aguardou_elementos.'","'.$data_conclusao.'","'.$distrito.'","'.$concelho.'","'.$freguesia.'","'.$soma_honorarios.'","'.$id.'")');
  /*STAT FILL*/
}
?>
