self.addEventListener('install', e => {
    e.waitUntil(
        caches.open('gesvalt').then(cache => {
            return cache.addAll([
                '/',
                '/home/',
				'/teste/'
            ])
                .then(() => self.skipWaiting());
        })
    )
});

self.addEventListener('activate', event => {
    event.waitUntil(self.clients.claim());
});
self.addEventListener('fetch', function(e){
    e.respondWith(
        caches.match(e.request).then(response => {
            return response || fetch(e.request);
        })
    );
});
