<?php
header('Content-Type: text/html; charset=utf-8');
ob_start();
include 'config/config.php';
include 'classes/init.php';
include 'config/admin.php';
include 'funcoes/website.php';
include 'funcoes/appController.php';
include 'config/user.php';
include 'config/dcConfig.php';
require 'include/vendor/autoload.php';
//error_reporting(-1);
//ini_set("display_errors",1);
use PhpOffice\PhpSpreadsheet\Spreadsheet;
$reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReaderForFile("tool/excel.xls");
$reader->setReadDataOnly(true);
$spreadsheet = $reader->load("tool/excel.xls");
// $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load();
$worksheet = $spreadsheet->getActiveSheet();
$i = 0;
$y = 0;

foreach ($worksheet->getRowIterator() as $row) {
    $cellIterator = $row->getCellIterator();
    $cellIterator->setIterateOnlyExistingCells(FALSE); // This loops through all cells,
    //    even if a cell value is not set.
    // By default, only cells that have a value
    foreach ($cellIterator as $cell) {

        $arr[$i][$y] =  $cell->getValue();
        $y++;
    }
    $i++;                                               //    set will be iterated.
    $y=0;
}
$string = file_get_contents("tool/json.json");
$json_a = json_decode($string, true);
$linhas = [];
$pos_to_replace = [4,15,16,21,22,23,24,26];
$lines = 0;
foreach ($arr as $key => $value) {
    $count = 0;
    $lines++;
    $processo   = [];
    if ($lines > 0) {
        $latitude = 0;
        $longitude = 0;
        foreach ($value as $k => $v) {
            if(in_array($count,$pos_to_replace))
            {
                $processo[$count]=translate($v);
            }else{
                $processo[$count]=$v;
            }

            $count++;
        }
    }
    $linhas[] = $processo;
}

function translate($a)
{
    global $json_a;
    $traducoes = $json_a["en"];
    foreach ($traducoes as $key=>$value){
        $a = str_replace($key,$value,$a);
    }
   return $a;
}

?>
    <!doctype html>

    <html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Olhar de Prata - Tradutor</title>
        <meta name="description" content="Olhar de Prata - Tradutor.">
        <meta name="author" content="SitePoint">

          <link rel="icon" href="https://olhardeprata.pt/favicon.ico">
        <link rel="icon" href="https://olhardeprata.pt/favicon.svg" type="image/svg+xml">
        <link rel="apple-touch-icon" href="/apple-touch-icon.png">

        <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/jszip-2.5.0/dt-1.12.1/b-2.2.3/b-html5-2.2.3/datatables.min.css"/>

        <script type="text/javascript" src="https://cdn.datatables.net/v/dt/jszip-2.5.0/dt-1.12.1/b-2.2.3/b-html5-2.2.3/datatables.min.js"></script>

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@200;300;400&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="css/styles.css?v=1.0">

    </head>
<body>
<img src="https://olhardeprata.pt/wp-content/uploads/2022/03/OP_logo.png">
    <form name="uploads" method="post" enctype="multipart/form-data">

        <p class="line">Excel</p>
        <input type="file" name="exl">
        <a class="botao" href="https://portal.gesvalt.pt/tool/excel.xls">Último ficheiro</a>
        <p class="line">JSON</p>
        <input type="file" name="jsn">
        <a class="botao" href="https://portal.gesvalt.pt/tool/json.json">Último ficheiro</a>
        <button>Enviar</button>
    </form>

<style>
    *{
        font-family: 'Nunito Sans', sans-serif;
    }
    .botao{
        background: #333;
        color: white;
        padding: 7px;
        border-radius: 3px;
    }
    .line{
        font-weight: 600;
        font-size: 12px;
        border-bottom: 1px solid;
        width: 400px;

    }
    table.dataTable{
        width: 100%!important;
        float: left!important;
        overflow: scroll!important;
    }
    button{
        ackground: white;
        float: left;
        margin-right: 100%;
        margin-top: 39px;
        border-radius: 4px;
        border: 1px solid;
        width: 400px;
        font-weight: 600;
        font-size: 12px;
    }
    form{
        background: #f1f1f1;
        float: left;
        padding: 7px;
        width: 400px;
        margin-left: 50%;
        margin-right: 50%;
        transform: translateX(-50%);
        border-radius: 4px;
    }
    img{
        float: left;
        width: 400px;
        margin-left: 50%;
        margin-right: 50%;
        transform: translateX(-50%);
    }
    button.dt-button{
        background: #333!important;
        color: white!important;
        width: 188px!important;
        border-radius: 4px!important;
    }
</style>
<br>


<?php
if($_FILES){
    $tmpFilePath = $_FILES[ 'exl' ][ 'tmp_name' ];
    $tmpFilePath2 = $_FILES[ 'jsn' ][ 'tmp_name' ];
    if($tmpFilePath!="")
    {
        move_uploaded_file($tmpFilePath,"tool/excel.xls");
    }else{
        echo "Sem excel";
    }
    if($tmpFilePath2!="")
    {
        move_uploaded_file($tmpFilePath2,"tool/json.json");
    }
?>

<table>
    <thead>
    <tr>
    <?php
        foreach ($linhas[0] as $key=>$value)
        {
            echo "<th>$value</th>";
        }
        unset($linhas[0]);
    ?>
    </tr>
    </thead>
    <tbody>
    <?php
    foreach ($linhas as $k=>$v)
    {
        echo "<tr>";
        foreach ($v as $key=>$value)
        {
            echo "<td>$value</td>";
        }
        echo "</tr>";
    }
    ?>
    </tbody>
</table>

<script>
    $('table').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5'
        ]
    } );
</script>

<?php
}
?>
</body>
</html>
