<?php
class Calendario
{
	public $lang;
	
	public function __construct()
	{
		global $sql;
		$this->lang = 'PT';
	}
	
	public function showCalendar($diffmes = '')
	{		
		global $act;		
		
		$weekendday = '#9a9323';
		$currentday = '#8ca8d3';		
		$diffyear = 0;
		
		if ($diffmes == '')
			$diffmes = 0;
		
		$monthNames = $this->getMonthNames();
		
		if (!isset($_GET["month"]))
		{
			$getmonth = date("m");
		}
		else
		{
			$getmonth = $_GET["month"];
		}
		
		if (!isset($_GET["year"]))
		{
			$getyear  = date("Y");
		}
		else
		{
			$getyear = $_GET["year"];
		}
		
		$this->cMonth = $getmonth + $diffmes;
		$this->cYear  = $getyear;		
		/*
			Permite recuar 2 meses, quando impressos 3 calendrios 
			Ex: [mes - 2] [mes - 1] [mes - 0]
		
		if($this->cMonth == -1)
		{ 
			$this->cYear--; 
			$this->cMonth = 11; 
		}		
		*/
		
		/*
			Permite recuar 1 mes, e avanar 1 ms, quando impressos 3 calendrios 
			Ex: [mes - 1] [mes] [mes + 1]
		*/
		if($this->cMonth == 0)
		{ 
			$this->cYear--; 
			$this->cMonth = 12; 
		}		
		if($this->cMonth == 13)
		{ 
			$this->cYear++; 
			$this->cMonth = 1; 
		}
		
		/*
			Permite avanar 2 meses quando impressos 3 calendrios 
			Ex: [mes] [mes + 1] [mes + 2]
		*/	
		if($this->cMonth == 14)
		{ 
			$this->cYear++; 
			$this->cMonth = 2; 
		}
	
			
		
		$this->prev_year = $this->cYear;
		$this->next_year = $this->cYear;
		$this->prev_month = $this->cMonth-1;
		$this->next_month = $this->cMonth+1;
		
		if ($this->prev_month == 0 )
		{
			$this->prev_month = 12;
			$this->prev_year = $this->cYear - 1;
		}
		
		if ($this->next_month == 13 )
		{
			$this->next_month = 1;
			$this->next_year = $this->cYear + 1;
		}
				
		$timestamp = mktime(0,0,0,$this->cMonth,1,$this->cYear);
		$maxday    = date("t",$timestamp);
		$thismonth = getdate ($timestamp);		
		$this->startday  = $thismonth['wday']-1;		
		
		?>
        <table cellpadding="1" cellspacing="1" align="center" class="calendario">
            <tr>
                <td colspan="7">
                
                    <table class="calendario-header" cellspacing="0" cellpadding="0">
                        <tr>
                        	<td class="left">
                            <?php
							if ($diffmes == 0) {
							?>
                                <a href="<?php echo $act->url(array('month', 'year'))."&amp;month=". $this->prev_month . "&amp;year=" . $this->prev_year; ?>">
                                <img src="http://www.portalsocial.pt/ps/img/bg-calendar-arrow-left.png" alt="Anterior" />
                                </a>
                             <?php } ?>
                            </td>
                        	<td class="center"><?=$monthNames[$this->cMonth-1].' '.$this->cYear; ?></td>
                        	<td class="right">
                            <?php
							if ($diffmes == 0) {
							?>
                                <a href="<?php echo $act->url(array('month', 'year'))."&amp;month=". $this->next_month . "&amp;year=" . $this->next_year; ?>">
                                <img src="http://www.portalsocial.pt/ps/img/bg-calendar-arrow-right.png" alt="Seguinte" />
                                </a>
                             <?php } ?>
                            </td>
                        </tr>
                    </table>
                
                </td>
            </tr>
        <tr align="center">
        <?php
		$weekdays = $this->getWeekDays();
		for ($i = 0; $i <= 6; $i++)
		{
			echo '<td class="days" width="24">'.$weekdays[$i].'</td>';
		}
		?>
          </tr>
  		
		<?php 		
		for($i=0; $i <($maxday+$this->startday); $i++)
		{								
			$this->getTableBreakOnZero($i);
		
			if ( $i < $this->startday )
			{ 
				echo "<td style='background:transparent;'></td>"; 
			}
			else
			{
				/*if ($this->getEvents($i))
				{			
					$this->checkFimSemana($i) ? $weekendcolor = 'color:#c2c2c2;' :  $weekendcolor = '' ;			
					$this->checkDiaActual($i) ? $todaycolor = 'color:#000000;' : $todaycolor = ''; 
					echo '<form action="" method="post" name="form'.$i.'calendar">'; 
					echo '<input name="year" type="hidden" value="'.$this->cYear.'">'; 
					echo '<input name="month" type="hidden" value="'.$this->cMonth.'">';
					echo '<input name="showday" type="hidden" value="'.($i - $this->startday + 1).'">';	
					echo '</form>';
					echo '<td valign="middle" align="center" class="highlight" style="'.$todaycolor.$weekendcolor.'">
							<a href="#" class="'.$this->checkiftoday($i).'" onclick="document.form'.$i.'calendar.submit()">'. ($i - $this->startday + 1) . '</a>
						  </td>';	
				}*/
				
				if ($this->getEvents($i))
				{			
					$this->checkFimSemana($i) ? $weekendcolor = 'color:'.$weekendday.';' :  $weekendcolor = '' ;			
					$this->checkDiaActual($i) ? $todaycolor = 'color:'.$currentday.';' : $todaycolor = '';
					echo '<td valign="middle" align="center" class="highlight" style="'.$todaycolor.$weekendcolor.'">
							<a href="'.$act->url(array('showy', 'showm', 'showd')).'&amp;showy='.$this->cYear.'&amp;showm='.$this->cMonth.'&amp;showd='.($i - $this->startday + 1).'" class="'.$this->checkiftoday($i).'">'. ($i - $this->startday + 1) . '</a>
						  </td>';	
				}
				
				else
				{
					$this->checkFimSemana($i) ? $weekendcolor = 'color:'.$weekendday.';' :  $weekendcolor = '' ;			
					$this->checkDiaActual($i) ? $todaycolor = 'color:'.$currentday.';' : $todaycolor = '';   
					echo "<td valign='middle' style='".$todaycolor.$weekendcolor."' align='center'>".($i - $this->startday + 1)."</td>";
				}
			}				
			$this->getTableBreakOnSix($i);
		}
		echo $i < 35 ? '</tr></table>':'</table>';
	}
	
	

	private function checkDiaActual($i)
	{
		$y = $this->cYear;
		$m = sprintf("%02d", $this->cMonth);
		$d = sprintf("%02d", ($i - $this->startday + 1));
		$compareday = $y."-".$m."-".$d;
		$today = date("Y-m-d");
		if ($compareday == $today)
			return true;
		else
			return false;
	}
	
	
	private function checkFimSemana($i)
	{
		if ($i == 5 || $i == 6 || $i == 12 || $i == 13 || $i == 19 || $i == 20 || $i == 26  || $i == 27 || $i == 33 || $i == 34)
			return true;								
		else
			return false;
	}
	
	
	public function getTableBreakOnZero($i)
	{
		if($i == 0 || ($i % 7) == 0){ echo '<tr>'; }			
	}
	
	
	public function getTableBreakOnSix($i)
	{
		if(($i % 7) == 6)
			echo '</tr>'; 
	}
	
	
	private function getEvents($i)
	{
		global $sql;
		$result = $sql->query("SELECT * FROM events WHERE initDate <= '".$this->cYear."-".$this->cMonth."-".($i - $this->startday + 1)."' And endDate >= '".$this->cYear ."-".$this->cMonth."-".($i - $this->startday + 1)."'");			
    	if ($sql->nrows($result) > 0)
			return true;
		else
			return false;	
	}
	
	
	private function checkiftoday($i)
	{
		$y = $this->cYear;
		$m = sprintf("%02d", $this->cMonth);
		$d = $i - $this->startday + 1;
		$compareday = $y."-".$m."-".$d;
		$today = date("Y-m-d");
		if ($compareday == $today)
			return "selected";
		else
			return "event";
	}
	
	
	/*
		Retorna lingua (PT)
	*/
	public function setlang ($mylang = '' )
	{
		if ($mylang != '')
		{
			$this->lang = $mylang;
		}		
		return $this->lang;
	}
	
	
	/*
		Retorna array de meses (nomes)
	*/
	private function getMonthNames()
	{
		if ($this->lang == 'PT' )
		{
			$monthNames = Array("Janeiro", "Fevereiro", "Mar&ccedil;o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"); 
			return $monthNames;
		}
		else
		{
			$monthNames = Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"); 
			return $monthNames;
		}
	}
	
	
	/*
		Retorna array de dias (nomes)  (ex: S,T,Q,Q,S,S)
	*/
	public function getWeekDays()
	{
		if ($this->lang == 'PT' )
			return $weekdays = Array("S", "T", "Q", "Q", "S", "S", "D");
		else
			return $weekdays = Array("M", "T", "W", "T", "F", "S", "S"); 
	}
	
	
	/*
		Imprime Calendrio Semanal
		ATENAO: Nao foi 'normalizado'!!
	*/
	public function showWeek()
	{	
		$weekdaynames = $this->getWeekDays();
		$weekNum = $this->getWeekNumber();
		
		isset($_POST['sy']) ? $yearStart = $_POST['sy'] : $yearStart = date("Y-01-01");		
		
		$oneDay = 24*60*60;		
		$tempTimestamp = strtotime($yearStart) + ($weekNum-1)*7*$oneDay;		
		$weekDay = date("w", $tempTimestamp);		
		$weekDay == 0 ? $tempTimestamp += $oneDay :	$tempTimestamp -= $weekDay * $oneDay;
		
		echo '<form action="" method="post" name="weekbefore">'; 
		echo '<input name="sy" type="hidden" value="'.$yearStart.'">';
		echo '<input name="week" type="hidden" value="'.($weekNum - 1).'">';
		echo '</form>';
		
		echo '<form action="" method="post" name="weekafter">'; 
		echo '<input name="sy" type="hidden" value="'.$yearStart.'">';
		echo '<input name="week" type="hidden" value="'.($weekNum + 1).'">';
		echo '</form>';
		
		echo '<table cellspacing="0" cellpadding="0"><tr>';
		echo '<td><a href="#" onclick="document.weekbefore.submit();" onmouseover="document.getElementById(\'ementa-nav-left\').style.border=\'1px solid #787878\';" onmouseout="document.getElementById(\'ementa-nav-left\').style.border=\'1px solid #c5c5c5\';">
			<img id="ementa-nav-left" style="border:1px solid #c5c5c5" src="http://www.portalsocial.pt/ps/img/ementa-nav-arrow-left.gif" title="Semana anterior" /></a>
			 </td><td>';
		echo '<table class="ementa-nav-inside" cellspacing="0" cellpadding="0"><tr>';
		for($i=0;$i<7;$i++)
		{
			$weekDate = date("d", $tempTimestamp);
			$tempTimestamp += $oneDay;			
			echo '<td align="center" style="padding-top:-5px; padding-right:4px;"><div class="ementa-nav-div-dnames">'.$weekdaynames[$i].'</div><div class="ementa-nav-div-dnumbers">'.$weekDate.'</div></td>';
		}		
		echo '</tr></table>';
		echo '</td><td><a href="#" onclick="document.weekafter.submit();" onmouseover="document.getElementById(\'ementa-nav-right\').style.border=\'1px solid #787878\';" onmouseout="document.getElementById(\'ementa-nav-right\').style.border=\'1px solid #c5c5c5\';">
			<img id="ementa-nav-right" style="border:1px solid #c5c5c5" src="http://www.portalsocial.pt/ps/img/ementa-nav-arrow-right.gif"  title="Semana seguinte" /></a>
			 </td><td>';
		echo '</tr></table>';
	}
	
	
	/*
		Retorna array de dias da semana seleccionada (ex: 11,12,13,14,15,16,17)
	*/
	public function getEmentaWeekDays()
	{
		isset($_POST['sy']) ? list($y, $trashd, $trashm) = explode("-",$_POST['sy']) : $y = date("Y");
		$weekNum = $this->getWeekNumber();		
		$umdia = 24*60*60;		
		$tempTimestamp = strtotime($yearStart) + ($weekNum -1)*7*$umdia;		
		$weekDay = date("w", $tempTimestamp);		
		$weekDay == 0 ? $tempTimestamp += $oneDay :	$tempTimestamp -= $weekDay * $umdia;		

		for($i=0;$i<7;$i++)
		{
			$dia = sprintf("%2d",date("d", $tempTimestamp));
			$mes = date("m", $tempTimestamp);
			$weekDate = $dia.'-'.$mes.'-'.$y;
			$tempTimestamp += $umdia;
			$dias[$i] = $weekDate;
		}		
		return $dias;		
	}
	
	
	/*
		Retorna numero da semana
	*/
	public function getWeekNumber()
	{		
		isset($_POST['week']) ? $this->weekNumber = $_POST['week'] : $this->weekNumber = (date("W") + 1);		
		return $this->weekNumber;
	}
	
	
	public function showMonth()
	{
		
		global $act;
		
		$monthNames = $this->getMonthNames();
		if (!isset($_REQUEST["month"])) $_REQUEST["month"] = date("n");
		if (!isset($_REQUEST["year"]))  $_REQUEST["year"]  = date("Y");
		
		$cMonth = ($_REQUEST["month"] + $somar);
		$cYear  = $_REQUEST["year"];
		
		if($cMonth == 13){ $cYear++; $cMonth = 1; }	
		if($cMonth == 14){ $cYear++; $cMonth = 2; }	
		$prev_year = $cYear;
		$next_year = $cYear;
		
		$prev_month = $cMonth-1;
		$next_month = $cMonth+1;
		
		if ($prev_month == 0 ) {
			$prev_month = 12;
			$prev_year = $cYear - 1;
		}
		if ($next_month == 13 ) {
			$next_month = 1;
			$next_year = $cYear + 1;
		}
		
		?>
        
        <table cellpadding="1" cellspacing="0" width="200" style="margin:0px; width:202px; margin-top:5px;" align="center">
            <tr>    
                <td align="right" style="color:#FFFFFF"><a href="<?php echo $act->url(array('month', 'year'))."&amp;month=".$prev_month."&amp;year=".$prev_year; ?>"><img src="http://www.portalsocial.pt/ps/img/bg-calendar-arrow-left.png"></a></td>
                
                <td height="30" width="150" valign="middle" align="center"><?php echo $monthNames[$cMonth-1].' '.$cYear; ?></td>
                
                <td align="left" style="color:#FFFFFF"><a href="<?php echo $act->url(array('month', 'year'))."&amp;month=".$next_month."&amp;year=".$next_year; ?>"><img src="http://www.portalsocial.pt/ps/img/bg-calendar-arrow-right.png"></a></td>
            </tr>
        
        </table>
		
        <?php
		
	}
	
}

?>