<?php

class Upload {

  public function __construct() {

  }

  public function uploadFile($file, $type, $target ,$myname='', $tamanho='500') {
    global $act;

		// Nome do ficheiro recebido
		$this->name     = $this->normalize_special_characters($file['name']);
		// Nome temporrio do ficheiro recebido
		$this->tmp_name = $file['tmp_name'];
		// Tamanho do ficheiro recebido. TODO
		$this->size     = $file['size'];
		// Tipo do ficheiro permitido
		$this->type     = explode(',',$type);
		// Destino para o ficheiro
		$this->target   = $target;
		// Tamanho final do ficheiro
		$this->tamanho  = $tamanho;

		$aviso = 1;
		$ext = pathinfo($this->name, PATHINFO_EXTENSION);

    if(!in_array($ext,$this->type)) {
      $aviso = 0;
    } else {
			$act->folder('create', $this->target);

      if(!empty($myname)) {
        $nome = $myname.'.'.$ext;
      } else {
        $nome = $this->name;
      }

			$newtarget = $this->target.$nome;

      if(in_array($ext,array('jpg', 'jpeg', 'png', 'gif'))) {
        $source = new Imagick($this->tmp_name);

        $width = $source->getImageWidth();
        $height = $source->getImageHeight();

        if($width >= $height) {
          if($width > $this->tamanho) {
            $newWidth = $this->tamanho;
            $newHeight = $height / ( $width / $newWidth );
          } else {
            $newWidth = $width;
            $newHeight = $height;
          }
        } else {
          if($height > $this->tamanho) {
            $newHeight = $this->tamanho;
            $newWidth = $width / ( $height / $newHeight );
          } else {
            $newWidth = $width;
            $newHeight = $height;
          }
        }

        $filenam = $this->target.$nome;

        $source->thumbnailImage($newWidth, $newHeight);
        $source->writeImage($filenam);
        $source->clear();
        $source->destroy();
        chmod($filenam, 0777);
      } elseif(!move_uploaded_file($this->tmp_name, $newtarget))
				$aviso = 0;
		}
		return $aviso;
	}

	function normalize_special_characters($str) {
		$str = ereg_replace( chr(ord("`")), "'", $str );
		$str = ereg_replace( chr(ord("")), "'", $str );
		$str = ereg_replace( chr(ord("")), ",", $str );
		$str = ereg_replace( chr(ord("`")), "'", $str );
		$str = ereg_replace( chr(ord("")), "'", $str );
		$str = ereg_replace( chr(ord("")), "\"", $str );
		$str = ereg_replace( chr(ord("")), "\"", $str );
		$str = ereg_replace( chr(ord("")), "'", $str );
		$unwanted_array = array(''=>'S', ''=>'s', ''=>'Z', ''=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E',
			''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I', ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U',
			''=>'U', ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss', ''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'c',
			''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i', ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o',
			''=>'o', ''=>'o', ''=>'u', ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', ' '=>'' );
		$str = strtr( $str, $unwanted_array );
		$str = ereg_replace( chr(149), "&#8226;", $str );
		$str = ereg_replace( chr(150), "&ndash;", $str );
		$str = ereg_replace( chr(151), "&mdash;", $str );
		$str = ereg_replace( chr(153), "&#8482;", $str );
		$str = ereg_replace( chr(169), "&copy;", $str );
		$str = ereg_replace( chr(174), "&reg;", $str );
		return $str;
	}

}
?>
