<?php
include '../../config/config.php';
include '../../classes/init.php';
include '../../funcoes/functions.php';
include '../../funcoes/website.php';
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Easy set variables
	 */
	
	/* Array of database columns which should be read and sent back to DataTables. Use a space where
	 * you want to insert a non-database field (for example a counter or static image)
	 */
	$aColumns = array( 'id','data', 'observacoes', 'equipa', 'tecnico1', 'tecnico2', 'tecnico3', 'tecnico4', 'id', 'id' );
	$sIndexColumn = "id";
	$sTable = "ots_pending_list";
	$gaSql['server']     = "localhost";
	
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * If you just want to use the basic configuration for DataTables with PHP server-side, there is
	 * no need to edit below this line
	 */
	
	/* 
	 * Local functions
	 */
	function fatal_error ( $sErrorMessage = '' )
	{
		header( $_SERVER['SERVER_PROTOCOL'] .' 500 Internal Server Error' );
		die( $sErrorMessage );
	}

	
	/* 
	 * MySQL connection
	 */
	if ( ! $gaSql['link'] = mysql_pconnect( $gaSql['server'], $userBD, $passBD ) )
	{
		fatal_error( 'Could not open connection to server' );
	}

	if ( ! mysql_select_db($bdname, $gaSql['link'] ) )
	{
		fatal_error( 'Could not select database ' );
	}
	mysql_query("SET character_set_client=utf8", $gaSql['link']);
    mysql_query("SET character_set_connection=utf8", $gaSql['link']);

	//To read utf8 data from MySql - needed if your result set contains utf8 data
    mysql_query("SET character_set_results=utf8", $gaSql['link']);
	
	/* 
	 * Paging
	 */
	$sLimit = "";
	if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
	{
		$sLimit = "LIMIT ".intval( $_GET['iDisplayStart'] ).", ".
			intval( $_GET['iDisplayLength'] );
	}
	
	
	/*
	 * Ordering
	 */
	$sOrder = "";
	if ( isset( $_GET['iSortCol_0'] ) )
	{
		$sOrder = "ORDER BY  ";
		for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
		{
			if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
			{
				$sOrder .= "`".$aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."` ".
				 	($_GET['sSortDir_'.$i]==='asc' ? 'asc' : 'desc') .", ";
			}
		}
		
		$sOrder = substr_replace( $sOrder, "", -2 );
		if ( $sOrder == "ORDER BY" )
		{
			$sOrder = "";
		}
	}
	
	
	/* 
	 * Filtering
	 * NOTE this does not match the built-in DataTables filtering which does it
	 * word by word on any field. It's possible to do here, but concerned about efficiency
	 * on very large tables, and MySQL's regex functionality is very limited
	 */
	$sWhere = "";
	if ( isset($_GET['sSearch']) && $_GET['sSearch'] != "" )
	{
		$sWhere = "WHERE (";
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( isset($_GET['bSearchable_'.$i]) && $_GET['bSearchable_'.$i] == "true" )
			{
				$sWhere .= $aColumns[$i]." LIKE '%".mysql_real_escape_string( $_GET['sSearch'] )."%' OR ";
			}
		}
		$sWhere = substr_replace( $sWhere, "", -3 );
		$sWhere .= ')';
	}
	
	/* Individual column filtering */
	for ( $i=0 ; $i<count($aColumns) ; $i++ )
	{
		if ( isset($_GET['bSearchable_'.$i]) && $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
		{
			if ( $sWhere == "" )
			{
				$sWhere = "WHERE ";
			}
			else
			{
				$sWhere .= " AND ";
			}
			$sWhere .= $aColumns[$i]." LIKE '%".mysql_real_escape_string($_GET['sSearch_'.$i])."%' ";
		}
	}
	
	
	/*
	 * SQL queries
	 * Get data to display
	 */
	$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
	";
	$rResult = mysql_query( $sQuery, $gaSql['link'] ) or fatal_error( 'MySQL Error: ' . mysql_errno() );
	
	/* Data set length after filtering */
	$sQuery = "
		SELECT FOUND_ROWS()
	";
	$rResultFilterTotal = mysql_query( $sQuery, $gaSql['link'] ) or fatal_error( 'MySQL Error: ' . mysql_errno() );
	$aResultFilterTotal = mysql_fetch_array($rResultFilterTotal);
	$iFilteredTotal = $aResultFilterTotal[0];
	
	/* Total data set length */
	$sQuery = "
		SELECT COUNT(".$sIndexColumn.")
		FROM   $sTable
	";
	$rResultTotal = mysql_query( $sQuery, $gaSql['link'] ) or fatal_error( 'MySQL Error: ' . mysql_errno() );
	$aResultTotal = mysql_fetch_array($rResultTotal);
	$iTotal = $aResultTotal[0];
	
	
	/*
	 * Output
	 */
	$output = array(
		"sEcho" => intval($_GET['sEcho']),
		"iTotalRecords" => $iTotal,
		"iTotalDisplayRecords" => $iFilteredTotal,
		"aaData" => array()
	);
	
	while ( $aRow = mysql_fetch_array( $rResult ) )
	{
		$row = array();
		$row['DT_RowId'] = $aRow['id'];
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $i == 7 )
			{
				$pDados 	= $sql->fetch($sql->query('SELECT * FROM processos WHERE agendamento_id = "'.$aRow['id'].'"'));
				$row[] = view_button(''.$base.'process/'.$pDados->id.'/ots/','').($porrealizar == 0 && $acesso->del_ot == '1' ? delete_button('','class="delOT"') : '');
			}
			if ( $aColumns[$i] == "tecnico1" )
			{
				if($aRow['tecnico2'] != '') { $tec2 = ' | '.$aRow['tecnico2']; } else { $tec2 = ''; }
				if($aRow['tecnico3'] != '') { $tec3 = ' | '.$aRow['tecnico3']; } else { $tec3 = ''; }
				if($aRow['tecnico4'] != '') { $tec4 = ' | '.$aRow['tecnico4']; } else { $tec4 = ''; }
				$row[] = $aRow[$aColumns[$i]].$tec2.$tec3.$tec4;
			}
			if ( $i == 5)
			{
				$IDprocesso = $sql->fetch($sql->query('SELECT * FROM processos WHERE agendamento_id = "'.$aRow[ 'id' ].'"'));
				$procTasksPend 	= $sql->fetch($sql->query('SELECT COUNT(*) AS todastarefasPend FROM processos p INNER JOIN processos_tarefas pt ON p.id=pt.id_processo WHERE p.agendamento_id="'.$aRow[ 'id' ].'" AND pt.estado IN ("10","20")'));
				//$procTasksPend 	= $sql->fetch($sql->query('SELECT COUNT(*) AS todastarefasPend FROM processos_tarefas WHERE estado IN("10","20") AND id_processo = "'.$IDprocesso->id.'"'));
				//$procTasks 		= $sql->fetch($sql->query('SELECT COUNT(*) AS todastarefas FROM processos_tarefas WHERE id_processo = "'.$IDprocesso->id.'"'));
				$procTasks 		= $sql->fetch($sql->query('SELECT COUNT(*) AS todastarefas FROM processos p INNER JOIN processos_tarefas pt ON p.id=pt.id_processo WHERE p.agendamento_id="'.$aRow[ 'id' ].'"'));
				$total = $procTasks->todastarefas;
				$totalpendentes = $procTasksPend->todastarefasPend;
				$porrealizar = $total-$totalpendentes;
				@$printBar = 100-($totalpendentes*100)/$total;
				if($porrealizar == '0') {
					$statusPrint = '0';
				} else { 
					$statusPrint = $printBar;
				}
				$row[] = '<div style="border: 1px solid #666666;background:#C0C0C0;height:25px;max-height:25px;">
							<div style="background: green;height: 25px; width:'.$statusPrint.'%;"></div>
							<div style="color:#FFF;height: 100%; width:100%;text-align:center;margin-top: -19px;">
								'.$porrealizar.' / '.$total.'
							</div>
						  </div>';
			}
			else if ( $i != 6 && $aColumns[$i] != 'tecnico2' && $aColumns[$i] != 'tecnico3' && $aColumns[$i] != 'tecnico4' && $i != 4)
			{
				/* General output */
				$row[] = $aRow[ $aColumns[$i] ];
			}
		}
		$output['aaData'][] = $row;
	}
	
	echo $_GET['callback'].'('.json_encode( $output ).');';
?>